/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ClassNameProvider;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GenerationUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GeneratorClassNameProvider;

public final class TypeWriter
extends PsiTypeVisitor<Object> {
    private final boolean acceptEllipsis;
    private final StringBuilder builder;
    private final ClassNameProvider classNameProvider;
    private final PsiElement context;

    public static void writeTypeForNew(@NotNull StringBuilder builder, @Nullable PsiType type2, @NotNull PsiElement context) {
        PsiType erased;
        if (type2 instanceof PsiArrayType && (erased = TypeConversionUtil.erasure((PsiType)type2)) != null) {
            type2 = erased;
        }
        TypeWriter.writeType(builder, type2, context, new GeneratorClassNameProvider());
    }

    public static void writeType(@NotNull StringBuilder builder, @Nullable PsiType type2, @NotNull PsiElement context) {
        TypeWriter.writeType(builder, type2, context, new GeneratorClassNameProvider());
    }

    public static void writeType(@NotNull StringBuilder builder, @Nullable PsiType type2, @NotNull PsiElement context, @NotNull ClassNameProvider classNameProvider) {
        if (type2 == null || PsiType.NULL.equals((Object)type2)) {
            builder.append("java.lang.Object");
            return;
        }
        if (type2 instanceof PsiPrimitiveType) {
            builder.append(type2.getCanonicalText());
            return;
        }
        boolean acceptEllipsis = TypeWriter.isLastParameter(context);
        type2.accept((PsiTypeVisitor)new TypeWriter(builder, classNameProvider, acceptEllipsis, context));
    }

    private TypeWriter(@NotNull StringBuilder builder, @NotNull ClassNameProvider classNameProvider, boolean acceptEllipsis, @NotNull PsiElement context) {
        this.acceptEllipsis = acceptEllipsis;
        this.builder = builder;
        this.classNameProvider = classNameProvider;
        this.context = context;
    }

    public Object visitEllipsisType(@NotNull PsiEllipsisType ellipsisType) {
        PsiType componentType = ellipsisType.getComponentType();
        componentType.accept((PsiTypeVisitor)this);
        if (this.acceptEllipsis) {
            this.builder.append("...");
        } else {
            this.builder.append("[]");
        }
        return this;
    }

    public Object visitPrimitiveType(@NotNull PsiPrimitiveType primitiveType) {
        if (this.classNameProvider.forStubs()) {
            this.builder.append(primitiveType.getCanonicalText());
            return this;
        }
        PsiType boxed = TypesUtil.boxPrimitiveType((PsiType)primitiveType, this.context.getManager(), this.context.getResolveScope());
        boxed.accept((PsiTypeVisitor)this);
        return this;
    }

    public Object visitArrayType(@NotNull PsiArrayType arrayType) {
        arrayType.getComponentType().accept((PsiTypeVisitor)this);
        this.builder.append("[]");
        return this;
    }

    public Object visitClassType(@NotNull PsiClassType classType) {
        PsiType[] parameters2 = classType.getParameters();
        PsiClass psiClass = classType.resolve();
        if (psiClass == null) {
            this.builder.append(classType.getClassName());
        } else if (psiClass instanceof GrAnonymousClassDefinition) {
            this.visitClassType(((GrAnonymousClassDefinition)psiClass).getBaseClassType());
        } else {
            String qname = this.classNameProvider.getQualifiedClassName(psiClass, this.context);
            this.builder.append(qname);
        }
        GenerationUtil.writeTypeParameters(this.builder, parameters2, this.context, this.classNameProvider);
        return this;
    }

    public Object visitCapturedWildcardType(@NotNull PsiCapturedWildcardType capturedWildcardType) {
        capturedWildcardType.getWildcard().accept((PsiTypeVisitor)this);
        return this;
    }

    public Object visitWildcardType(@NotNull PsiWildcardType wildcardType) {
        this.builder.append('?');
        PsiType bound = wildcardType.getBound();
        if (bound == null) {
            return this;
        }
        if (wildcardType.isExtends()) {
            this.builder.append(" extends ");
        } else {
            this.builder.append(" super ");
        }
        bound.accept((PsiTypeVisitor)this);
        return this;
    }

    public Object visitDisjunctionType(@NotNull PsiDisjunctionType disjunctionType) {
        throw new UnsupportedOperationException();
    }

    public Object visitType(@NotNull PsiType type2) {
        throw new UnsupportedOperationException();
    }

    private static boolean isLastParameter(@NotNull PsiElement context) {
        PsiElement scope;
        if (context instanceof PsiParameter && (scope = ((PsiParameter)context).getDeclarationScope()) instanceof PsiMethod) {
            PsiParameter[] parameters2 = ((PsiMethod)scope).getParameterList().getParameters();
            return parameters2.length > 0 && parameters2[parameters2.length - 1] == context;
        }
        return false;
    }
}

