/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringHelper;
import com.intellij.usageView.UsageInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyUnusedImportUtil;

public class GroovyImportOptimizerRefactoringHelper
implements RefactoringHelper<Set<GroovyFile>> {
    public Set<GroovyFile> prepareOperation(UsageInfo @NotNull [] usages) {
        HashSet<GroovyFile> files = new HashSet<GroovyFile>();
        for (UsageInfo usage : usages) {
            PsiFile file;
            if (usage.isNonCodeUsage || !((file = usage.getFile()) instanceof GroovyFile) || !((Boolean)ReadAction.compute(() -> file.isValid())).booleanValue() || !file.isPhysical()) continue;
            files.add((GroovyFile)file);
        }
        return files;
    }

    public void performOperation(@NotNull Project project, Set<GroovyFile> files) {
        HashMap redundants;
        Runnable findUnusedImports;
        ProgressManager progressManager = ProgressManager.getInstance();
        if (!progressManager.runProcessWithProgressSynchronously(findUnusedImports = () -> GroovyImportOptimizerRefactoringHelper.lambda$performOperation$2(progressManager, files, project, redundants = new HashMap()), GroovyBundle.message("optimize.imports.progress.title", new Object[0]), false, project)) {
            return;
        }
        WriteAction.run(() -> {
            for (GroovyFile groovyFile : redundants.keySet()) {
                if (!groovyFile.isValid()) continue;
                Pair pair = (Pair)redundants.get(groovyFile);
                List validImports = (List)pair.getFirst();
                Set usedImports = (Set)pair.getSecond();
                for (GrImportStatement importStatement : validImports) {
                    if (usedImports.contains(importStatement)) continue;
                    groovyFile.removeImport(importStatement);
                }
            }
        });
    }

    private static /* synthetic */ void lambda$performOperation$2(ProgressManager progressManager, Set files, Project project, Map redundants) {
        ProgressIndicator progressIndicator = progressManager.getProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.setIndeterminate(false);
        }
        int total = files.size();
        int i = 0;
        for (GroovyFile file : files) {
            double fraction = (double)i++ / (double)total;
            ApplicationManager.getApplication().runReadAction(() -> {
                if (!file.isValid()) {
                    return;
                }
                VirtualFile virtualFile = file.getVirtualFile();
                if (progressIndicator != null) {
                    progressIndicator.setText2(virtualFile.getPresentableUrl());
                    progressIndicator.setFraction(fraction);
                }
                if (ProjectRootManager.getInstance((Project)project).getFileIndex().isInSource(virtualFile)) {
                    Set<GrImportStatement> usedImports = GroovyUnusedImportUtil.usedImports(file);
                    List<GrImportStatement> validImports = PsiUtil.getValidImportStatements(file);
                    redundants.put(file, Pair.create(validImports, usedImports));
                }
            });
        }
    }
}

