/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.typing;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import kotlin.Lazy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.CallSignature;
import org.jetbrains.plugins.groovy.lang.typing.CurriedSignature;
import org.jetbrains.plugins.groovy.lang.typing.GroovyClosureType;
import org.jetbrains.plugins.groovy.util.FunctionsKt;

final class GroovyCurriedClosureType
extends GroovyClosureType {
    private final GroovyClosureType myOriginal;
    private final int myPosition;
    private final List<? extends Argument> myArguments;
    private final int myCurriedArgumentCount;
    private final Lazy<List<CallSignature<?>>> mySignatures;

    GroovyCurriedClosureType(@NotNull GroovyClosureType original, int position, @NotNull List<? extends Argument> arguments2, int curriedArgumentCount, @NotNull PsiElement context) {
        super(context);
        this.myOriginal = original;
        this.myPosition = position;
        this.myArguments = arguments2;
        this.myCurriedArgumentCount = curriedArgumentCount;
        this.mySignatures = FunctionsKt.recursionAwareLazy(() -> ContainerUtil.mapNotNull(this.myOriginal.getSignatures(), this::curry));
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.myOriginal.isValid();
    }

    @NotNull
    public List<CallSignature<?>> getSignatures() {
        return (List)this.mySignatures.getValue();
    }

    @Nullable
    private CallSignature<?> curry(CallSignature<?> original) {
        int position;
        if (original.isVararg()) {
            return new CurriedSignature(original, this.myPosition, this.myArguments);
        }
        int n = position = this.myPosition < 0 ? this.myPosition + original.getParameterCount() - this.myCurriedArgumentCount : this.myPosition;
        if (position < 0) {
            return null;
        }
        return new CurriedSignature(original, position, this.myArguments);
    }

    @Override
    @NotNull
    public PsiType curry(int position, @NotNull List<? extends Argument> arguments2, @NotNull PsiElement context) {
        return new GroovyCurriedClosureType(this, position, arguments2, this.myCurriedArgumentCount + this.myArguments.size(), context);
    }
}

