/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.surroundWith;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.surroundWith.GroovyConditionSurrounder;

public class IfExprSurrounder
extends GroovyConditionSurrounder {
    @Override
    protected TextRange surroundExpression(@NotNull GrExpression expression, PsiElement context) {
        GrIfStatement ifStatement = (GrIfStatement)GroovyPsiElementFactory.getInstance(expression.getProject()).createStatementFromText("if(a){4\n}", context);
        IfExprSurrounder.replaceToOldExpression(ifStatement.getCondition(), expression);
        ifStatement = expression.replaceWithStatement(ifStatement);
        GrStatement thenBranch = ifStatement.getThenBranch();
        assert (thenBranch instanceof GrBlockStatement);
        GrStatement[] statements2 = ((GrBlockStatement)thenBranch).getBlock().getStatements();
        assert (statements2.length > 0);
        GrStatement statement = statements2[0];
        int endOffset = statement.getTextRange().getStartOffset();
        statement.getNode().getTreeParent().removeChild(statement.getNode());
        return new TextRange(endOffset, endOffset);
    }

    public String getTemplateDescription() {
        return GroovyBundle.message("surround.with.if.expr", new Object[0]);
    }
}

