/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.ast;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtilBase;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ast.AffectedMembersCache;
import org.jetbrains.plugins.groovy.lang.resolve.ast.GrGeneratedConstructorUtils;
import org.jetbrains.plugins.groovy.lang.resolve.ast.GrVisibilityUtils;
import org.jetbrains.plugins.groovy.lang.resolve.ast.Visibility;
import org.jetbrains.plugins.groovy.transformations.AstTransformationSupport;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;
import org.jetbrains.plugins.groovy.transformations.immutable.GrImmutableUtils;

public class ConstructorAnnotationsProcessor
implements AstTransformationSupport {
    @Override
    public void applyTransformation(@NotNull TransformationContext context) {
        boolean canonical;
        GrTypeDefinition typeDefinition = context.getCodeClass();
        if (typeDefinition.getName() == null) {
            return;
        }
        GrModifierList modifierList = typeDefinition.getModifierList();
        if (modifierList == null) {
            return;
        }
        PsiAnnotation tupleConstructor = context.getAnnotation("groovy.transform.TupleConstructor");
        PsiAnnotation mapConstructorAnno = context.getAnnotation("groovy.transform.MapConstructor");
        boolean immutable = GrImmutableUtils.hasImmutableAnnotation((PsiModifierListOwner)typeDefinition);
        boolean bl = canonical = context.getAnnotation("groovy.transform.Canonical") != null;
        if (!immutable && !canonical && tupleConstructor == null && mapConstructorAnno == null) {
            return;
        }
        if (tupleConstructor != null && typeDefinition.getCodeConstructors().length > 0 && !PsiUtil.getAnnoAttributeValue(tupleConstructor, "force", false)) {
            return;
        }
        String originInfo = immutable ? "created by @Immutable" : (canonical ? "created by @Canonical" : (tupleConstructor != null ? "created by @TupleConstructor" : "created by @MapConstructor"));
        if (canonical || immutable || tupleConstructor != null) {
            GrLightMethodBuilder fieldsConstructor = ConstructorAnnotationsProcessor.generateFieldConstructor(context, tupleConstructor, immutable, canonical, originInfo);
            context.addMethod(fieldsConstructor);
        }
        List<GrLightMethodBuilder> mapConstructors = ConstructorAnnotationsProcessor.generateMapConstructor(typeDefinition, originInfo, context);
        for (GrLightMethodBuilder mapConstructor2 : mapConstructors) {
            context.addMethod(mapConstructor2);
        }
    }

    @NotNull
    private static List<GrLightMethodBuilder> generateMapConstructor(@NotNull GrTypeDefinition typeDefinition, String originInfo, @NotNull TransformationContext context) {
        if (GroovyConfigUtils.isAtLeastGroovy25(typeDefinition)) {
            PsiAnnotation mapConstructorAnno = typeDefinition.getAnnotation("groovy.transform.MapConstructor");
            if (mapConstructorAnno == null) {
                return Collections.emptyList();
            }
            GrLightMethodBuilder mapConstructor2 = new GrLightMethodBuilder(typeDefinition);
            ConstructorAnnotationsProcessor.checkContainingClass(context, mapConstructor2);
            mapConstructor2.setOriginInfo(originInfo);
            Visibility visibility = GrVisibilityUtils.getVisibility(mapConstructorAnno, mapConstructor2, Visibility.PUBLIC);
            mapConstructor2.addModifier(visibility.toString());
            Boolean specialParamHandling = GrAnnotationUtil.inferBooleanAttribute(mapConstructorAnno, "specialNamedArgHandling");
            String parameterRepresentation = Boolean.TRUE.equals(specialParamHandling) ? ConstructorAnnotationsProcessor.computeMapParameterPresentation(typeDefinition) : "java.util.Map";
            mapConstructor2.addParameter("args", parameterRepresentation);
            Boolean noArg = GrAnnotationUtil.inferBooleanAttribute(mapConstructorAnno, "noArg");
            if (Boolean.TRUE.equals(noArg)) {
                GrLightMethodBuilder noArgConstructor = new GrLightMethodBuilder(typeDefinition);
                ConstructorAnnotationsProcessor.checkContainingClass(context, noArgConstructor);
                noArgConstructor.setOriginInfo(originInfo);
                return List.of(mapConstructor2, noArgConstructor);
            }
            return List.of(mapConstructor2);
        }
        GrLightMethodBuilder mapConstructor3 = new GrLightMethodBuilder(typeDefinition);
        ConstructorAnnotationsProcessor.checkContainingClass(context, mapConstructor3);
        mapConstructor3.addParameter("args", "java.util.HashMap");
        mapConstructor3.setOriginInfo(originInfo);
        return List.of(mapConstructor3);
    }

    @NlsSafe
    @NotNull
    private static String computeMapParameterPresentation(@NotNull GrTypeDefinition clazz) {
        GrField[] fields = clazz.getCodeFields();
        if (fields.length != 1) {
            return "java.util.Map";
        }
        PsiType fieldType = fields[0].getDeclaredType();
        if (fieldType == null || fieldType.equalsToText("java.util.HashMap") || fieldType.equalsToText("java.util.Map") || fieldType.equalsToText("java.util.AbstractMap") || fieldType.equalsToText("java.lang.Object")) {
            return "java.util.LinkedHashMap";
        }
        return "java.util.Map";
    }

    @NotNull
    private static GrLightMethodBuilder generateFieldConstructor(@NotNull TransformationContext context, @Nullable PsiAnnotation tupleConstructor, boolean immutable, boolean canonical, @NotNull String originInfo) {
        GrModifierList modifierList;
        GrTypeDefinition typeDefinition = context.getCodeClass();
        GrLightMethodBuilder fieldsConstructor = new GrLightMethodBuilder(typeDefinition.getManager(), typeDefinition.getName());
        fieldsConstructor.setConstructor(true);
        fieldsConstructor.setNavigationElement(typeDefinition);
        fieldsConstructor.setContainingClass(typeDefinition);
        if (canonical && (modifierList = typeDefinition.getModifierList()) != null) {
            tupleConstructor = new GrLightAnnotation((PsiAnnotationOwner)modifierList, typeDefinition, "groovy.transform.TupleConstructor", Map.of());
        }
        if (immutable && (modifierList = typeDefinition.getModifierList()) != null) {
            tupleConstructor = new GrLightAnnotation((PsiAnnotationOwner)modifierList, typeDefinition, "groovy.transform.TupleConstructor", Map.of("defaults", "false"));
        }
        if (tupleConstructor != null) {
            boolean optional = !immutable && PsiUtil.getAnnoAttributeValue(tupleConstructor, "defaults", true);
            Visibility visibility = GrVisibilityUtils.getVisibility(tupleConstructor, fieldsConstructor, Visibility.PUBLIC);
            fieldsConstructor.addModifier(visibility.toString());
            AffectedMembersCache cache2 = GrGeneratedConstructorUtils.getAffectedMembersCache(tupleConstructor);
            ConstructorAnnotationsProcessor.checkContainingClass(context, fieldsConstructor);
            for (PsiNamedElement element : cache2.getAffectedMembers()) {
                GrLightParameter parameter;
                String name;
                if (element instanceof PsiField) {
                    name = AffectedMembersCache.getExternalName(element);
                    parameter = new GrLightParameter(name == null ? "arg" : name, ((PsiField)element).getType(), fieldsConstructor);
                } else if (element instanceof GrMethod) {
                    name = PropertyUtilBase.getPropertyName((PsiMember)((PsiMember)element));
                    PsiType type2 = PropertyUtilBase.getPropertyType((PsiMember)((PsiMethod)element));
                    parameter = new GrLightParameter(name == null ? "arg" : name, type2, fieldsConstructor);
                } else {
                    parameter = null;
                }
                if (parameter == null) continue;
                parameter.setOptional(optional);
                fieldsConstructor.addParameter(parameter);
            }
        }
        fieldsConstructor.setOriginInfo(originInfo);
        return fieldsConstructor;
    }

    private static void checkContainingClass(@NotNull TransformationContext context, @NotNull GrLightMethodBuilder constructor) {
        GrTypeDefinition codeClass = context.getCodeClass();
        GrModifierList modifierList = codeClass.getModifierList();
        if (modifierList == null || context.hasModifierProperty(modifierList, "static")) {
            return;
        }
        PsiClass containingClass = codeClass.getContainingClass();
        if (containingClass == null) {
            return;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(context.getProject());
        PsiClassType classType = factory.createType(containingClass);
        EnclosingClassParameter justTypeParameter = new EnclosingClassParameter("_containingClass", (PsiType)classType, (PsiElement)containingClass);
        constructor.addParameter(justTypeParameter);
    }

    public static class EnclosingClassParameter
    extends GrLightParameter {
        public EnclosingClassParameter(@NlsSafe @NotNull String name, @Nullable PsiType type2, @NotNull PsiElement scope) {
            super(name, type2, scope);
        }
    }
}

