/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.patterns.compiler.PatternCompilerFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.DelegatingScopeProcessor;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.dgm.DGMMemberContributor;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ClassUtil;
import org.jetbrains.plugins.groovy.lang.resolve.CategoryMemberContributorKt;
import org.jetbrains.plugins.groovy.lang.resolve.noncode.MixinMemberContributor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MultiProcessor;

public abstract class NonCodeMembersContributor {
    public static final ExtensionPointName<NonCodeMembersContributor> EP_NAME = ExtensionPointName.create((String)"org.intellij.groovy.membersContributor");
    private static volatile Cache cache;

    public void processDynamicElements(@NotNull PsiType qualifierType, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        throw new RuntimeException("One of two 'processDynamicElements()' methods must be implemented");
    }

    public void processDynamicElements(@NotNull PsiType qualifierType, @Nullable PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        this.processDynamicElements(qualifierType, processor, place, state);
    }

    protected boolean unwrapMultiprocessor() {
        return true;
    }

    @Nullable
    protected String getParentClassName() {
        return null;
    }

    @NotNull
    protected Collection<String> getClassNames() {
        String className = this.getParentClassName();
        return className == null ? Collections.emptyList() : Collections.singletonList(className);
    }

    private static void dropCache() {
        cache = null;
        PatternCompilerFactory.getFactory().dropCache();
    }

    private static void ensureInit() {
        if (cache != null) {
            return;
        }
        ArrayList<NonCodeMembersContributor> allTypeContributors = new ArrayList<NonCodeMembersContributor>();
        MultiMap contributorMap = new MultiMap();
        for (NonCodeMembersContributor contributor : (NonCodeMembersContributor[])EP_NAME.getExtensions()) {
            Collection<String> fqns = contributor.getClassNames();
            if (fqns.isEmpty()) {
                allTypeContributors.add(contributor);
                continue;
            }
            for (String fqn : fqns) {
                contributorMap.putValue((Object)fqn, (Object)contributor);
            }
        }
        cache = new Cache((MultiMap<String, NonCodeMembersContributor>)contributorMap, allTypeContributors.toArray(new NonCodeMembersContributor[0]));
    }

    @NotNull
    private static Iterable<NonCodeMembersContributor> getApplicableContributors(@Nullable PsiClass clazz) {
        ArrayList<NonCodeMembersContributor> result2 = new ArrayList<NonCodeMembersContributor>();
        if (clazz != null) {
            for (String superClassName : ClassUtil.getSuperClassesWithCache(clazz).keySet()) {
                result2.addAll(NonCodeMembersContributor.cache.classSpecifiedContributors.get((Object)superClassName));
            }
        }
        ContainerUtil.addAll(result2, (Object[])NonCodeMembersContributor.cache.allTypeContributors);
        return result2;
    }

    public static boolean runContributors(@NotNull PsiType qualifierType, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        NonCodeMembersContributor.ensureInit();
        PsiClass aClass = PsiTypesUtil.getPsiClass((PsiType)qualifierType);
        Iterable<? extends PsiScopeProcessor> unwrappedOriginals = MultiProcessor.allProcessors(processor);
        for (PsiScopeProcessor psiScopeProcessor : unwrappedOriginals) {
            if (!MixinMemberContributor.processClassMixins(qualifierType, psiScopeProcessor, place, state)) {
                return false;
            }
            if (!CategoryMemberContributorKt.processCategoriesInScope(qualifierType, psiScopeProcessor, place, state)) {
                return false;
            }
            if (DGMMemberContributor.processDgmMethods(qualifierType, psiScopeProcessor, place, state)) continue;
            return false;
        }
        List<MyDelegatingScopeProcessor> wrapped = Collections.singletonList(new MyDelegatingScopeProcessor(processor));
        List<MyDelegatingScopeProcessor> list = ContainerUtil.map(MultiProcessor.allProcessors(processor), MyDelegatingScopeProcessor::new);
        Iterable<NonCodeMembersContributor> contributors = NonCodeMembersContributor.getApplicableContributors(aClass);
        for (NonCodeMembersContributor contributor : contributors) {
            ProgressManager.checkCanceled();
            processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.CHANGE_LEVEL, null);
            List<MyDelegatingScopeProcessor> delegates = contributor.unwrapMultiprocessor() ? list : wrapped;
            for (MyDelegatingScopeProcessor delegatingProcessor : delegates) {
                ProgressManager.checkCanceled();
                contributor.processDynamicElements(qualifierType, aClass, delegatingProcessor, place, state);
                if (delegatingProcessor.wantMore) continue;
                return false;
            }
        }
        return true;
    }

    static {
        EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<NonCodeMembersContributor>(){

            public void extensionAdded(@NotNull NonCodeMembersContributor extension, @NotNull PluginDescriptor pluginDescriptor) {
                NonCodeMembersContributor.dropCache();
            }

            public void extensionRemoved(@NotNull NonCodeMembersContributor extension, @NotNull PluginDescriptor pluginDescriptor) {
                NonCodeMembersContributor.dropCache();
            }
        }, null);
    }

    private static final class Cache {
        public final MultiMap<String, NonCodeMembersContributor> classSpecifiedContributors;
        public final NonCodeMembersContributor[] allTypeContributors;

        private Cache(MultiMap<String, NonCodeMembersContributor> classSpecifiedContributors, NonCodeMembersContributor[] allTypeContributors) {
            this.classSpecifiedContributors = classSpecifiedContributors;
            this.allTypeContributors = allTypeContributors;
        }
    }

    private static class MyDelegatingScopeProcessor
    extends DelegatingScopeProcessor
    implements MultiProcessor {
        public boolean wantMore = true;

        MyDelegatingScopeProcessor(PsiScopeProcessor delegate) {
            super(delegate);
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (!this.wantMore) {
                return false;
            }
            this.wantMore = super.execute(element, state);
            return this.wantMore;
        }

        @Override
        @NotNull
        public Iterable<? extends PsiScopeProcessor> getProcessors() {
            return MultiProcessor.allProcessors(this.getDelegate());
        }
    }
}

