/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.compiled.SignatureParsing;
import com.intellij.psi.impl.compiled.StubBuildingVisitor;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.SingleEntryIndexer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public class GroovyTraitFieldsFileIndex
extends SingleEntryFileBasedIndexExtension<Collection<TraitFieldDescriptor>>
implements DataExternalizer<Collection<TraitFieldDescriptor>> {
    public static final ID<Integer, Collection<TraitFieldDescriptor>> INDEX_ID = ID.create((String)"groovy.trait.fields");
    @NonNls
    public static final String HELPER_SUFFIX = "$Trait$FieldHelper.class";
    private static final FileBasedIndex.InputFilter FILTER = new DefaultFileTypeSpecificInputFilter(new FileType[]{JavaClassFileType.INSTANCE}){

        public boolean acceptInput(@NotNull VirtualFile file) {
            return StringUtil.endsWith((CharSequence)file.getNameSequence(), (CharSequence)GroovyTraitFieldsFileIndex.HELPER_SUFFIX);
        }
    };
    private static final SingleEntryIndexer<Collection<TraitFieldDescriptor>> INDEXER = new SingleEntryIndexer<Collection<TraitFieldDescriptor>>(true){

        protected Collection<TraitFieldDescriptor> computeValue(@NotNull FileContent inputData) {
            return GroovyTraitFieldsFileIndex.index(inputData.getContent());
        }
    };
    private static final String INSTANCE_PREFIX = "$ins";
    private static final String STATIC_PREFIX = "$static";
    private static final String PRIVATE_PREFIX = "$0";
    private static final String PUBLIC_PREFIX = "$1";
    private static final String DELIMITER = "__";

    @NotNull
    public ID<Integer, Collection<TraitFieldDescriptor>> getName() {
        return INDEX_ID;
    }

    @NotNull
    public SingleEntryIndexer<Collection<TraitFieldDescriptor>> getIndexer() {
        return INDEXER;
    }

    @NotNull
    public DataExternalizer<Collection<TraitFieldDescriptor>> getValueExternalizer() {
        return this;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return FILTER;
    }

    public int getVersion() {
        return 5;
    }

    public static Collection<TraitFieldDescriptor> index(byte[] fileContents) {
        final ArrayList<TraitFieldDescriptor> values = new ArrayList<TraitFieldDescriptor>();
        new ClassReader(fileContents).accept(new ClassVisitor(589824){

            public FieldVisitor visitField(final int access, final String name, final String desc, final String signature, Object value) {
                return new FieldVisitor(589824){
                    private final List<String> annotations;
                    {
                        super(arg0);
                        this.annotations = new SmartList();
                    }

                    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                        return StubBuildingVisitor.getAnnotationTextCollector((String)descriptor, this.annotations::add);
                    }

                    public void visitEnd() {
                        this.processField(access, name, desc, signature, this.annotations);
                    }
                };
            }

            private void processField(int access, String name, String desc, String signature, List<String> annotations2) {
                if ((access & 0x1000) == 0) {
                    return;
                }
                Pair<Boolean, String> p = this.parse(GroovyTraitFieldsFileIndex.STATIC_PREFIX, GroovyTraitFieldsFileIndex.INSTANCE_PREFIX, name);
                if (p.first == null) {
                    return;
                }
                boolean isStatic = (Boolean)p.first;
                name = (String)p.second;
                p = this.parse(GroovyTraitFieldsFileIndex.PUBLIC_PREFIX, GroovyTraitFieldsFileIndex.PRIVATE_PREFIX, name);
                if (p.first == null) {
                    return;
                }
                boolean isPublic = (Boolean)p.first;
                name = (String)p.second;
                String typeString = this.fieldType(desc, signature);
                if (typeString == null) {
                    return;
                }
                int delimiter = name.indexOf(GroovyTraitFieldsFileIndex.DELIMITER);
                if (delimiter > -1) {
                    name = name.substring(delimiter + GroovyTraitFieldsFileIndex.DELIMITER.length());
                }
                byte flags = (byte)((isPublic ? 1 : 0) | (isStatic ? 2 : 0));
                values.add(new TraitFieldDescriptor(flags, typeString, name, annotations2));
            }

            private Pair<Boolean, String> parse(String prefix, String prefix2, String input) {
                if (input.startsWith(prefix)) {
                    return Pair.create((Object)true, (Object)input.substring(prefix.length()));
                }
                if (input.startsWith(prefix2)) {
                    return Pair.create((Object)false, (Object)input.substring(prefix2.length()));
                }
                return Pair.create(null, (Object)input);
            }

            private String fieldType(String desc, String signature) {
                if (signature != null) {
                    try {
                        return SignatureParsing.parseTypeString((CharacterIterator)new StringCharacterIterator(signature), (Function)StubBuildingVisitor.GUESSING_MAPPER);
                    }
                    catch (ClsFormatException clsFormatException) {
                        // empty catch block
                    }
                }
                String raw = Type.getType((String)desc).getClassName();
                return (String)StubBuildingVisitor.GUESSING_MAPPER.fun((Object)raw);
            }
        }, ClsFileImpl.EMPTY_ATTRIBUTES, 1);
        return values;
    }

    public void save(@NotNull DataOutput out, Collection<TraitFieldDescriptor> values) throws IOException {
        GroovyTraitFieldsFileIndex.saveTraitFields(out, values);
    }

    public static void saveTraitFields(@NotNull DataOutput out, Collection<TraitFieldDescriptor> values) throws IOException {
        DataInputOutputUtilRt.writeSeq((DataOutput)out, values, descriptor -> {
            out.writeByte(descriptor.flags);
            IOUtil.writeUTF((DataOutput)out, (String)descriptor.typeString);
            IOUtil.writeUTF((DataOutput)out, (String)descriptor.name);
            DataInputOutputUtilRt.writeSeq((DataOutput)out, descriptor.annotations, it -> IOUtil.writeUTF((DataOutput)out, (String)it));
        });
    }

    public Collection<TraitFieldDescriptor> read(@NotNull DataInput in) throws IOException {
        return DataInputOutputUtilRt.readSeq((DataInput)in, () -> new TraitFieldDescriptor(in.readByte(), IOUtil.readUTF((DataInput)in), IOUtil.readUTF((DataInput)in), DataInputOutputUtilRt.readSeq((DataInput)in, () -> IOUtil.readUTF((DataInput)in))));
    }

    public static Collection<TraitFieldDescriptor> readTraitFields(@NotNull DataInput in) throws IOException {
        return DataInputOutputUtilRt.readSeq((DataInput)in, () -> new TraitFieldDescriptor(in.readByte(), IOUtil.readUTF((DataInput)in), IOUtil.readUTF((DataInput)in), DataInputOutputUtilRt.readSeq((DataInput)in, () -> IOUtil.readUTF((DataInput)in))));
    }

    public static final class TraitFieldDescriptor {
        public static final byte PUBLIC = 1;
        public static final byte STATIC = 2;
        public final byte flags;
        public final String typeString;
        public final String name;
        public final List<String> annotations;

        private TraitFieldDescriptor(byte flags, @NotNull String typeString, @NotNull String name, @NotNull List<String> annotations2) {
            this.flags = flags;
            this.typeString = typeString;
            this.name = name;
            this.annotations = annotations2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TraitFieldDescriptor that = (TraitFieldDescriptor)o;
            if (this.flags != that.flags) {
                return false;
            }
            if (!this.typeString.equals(that.typeString)) {
                return false;
            }
            return this.name.equals(that.name);
        }

        public int hashCode() {
            int result2 = this.flags;
            result2 = 31 * result2 + this.typeString.hashCode();
            result2 = 31 * result2 + this.name.hashCode();
            return result2;
        }
    }
}

