/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H&J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H&R\u0014\u0010\u0003\u001a\u00020\u00048WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/groovy/lang/psi/util/StringKind;", "", "(Ljava/lang/String;I)V", "lineBreaker", "", "getLineBreaker", "()Ljava/lang/String;", "escape", "unescaped", "unescape", "escaped", "SINGLE_QUOTED", "TRIPLE_SINGLE_QUOTED", "DOUBLE_QUOTED", "TRIPLE_DOUBLE_QUOTED", "SLASHY", "DOLLAR_SLASHY", "TestsOnly", "intellij.groovy.psi"})
public abstract class StringKind
extends Enum<StringKind> {
    public static final /* enum */ StringKind SINGLE_QUOTED;
    public static final /* enum */ StringKind TRIPLE_SINGLE_QUOTED;
    public static final /* enum */ StringKind DOUBLE_QUOTED;
    public static final /* enum */ StringKind TRIPLE_DOUBLE_QUOTED;
    public static final /* enum */ StringKind SLASHY;
    public static final /* enum */ StringKind DOLLAR_SLASHY;
    private static final /* synthetic */ StringKind[] $VALUES;

    static {
        StringKind[] stringKindArray = new StringKind[6];
        StringKind[] stringKindArray2 = stringKindArray;
        stringKindArray[0] = SINGLE_QUOTED = new SINGLE_QUOTED("SINGLE_QUOTED", 0);
        stringKindArray[1] = TRIPLE_SINGLE_QUOTED = new TRIPLE_SINGLE_QUOTED("TRIPLE_SINGLE_QUOTED", 1);
        stringKindArray[2] = DOUBLE_QUOTED = new DOUBLE_QUOTED("DOUBLE_QUOTED", 2);
        stringKindArray[3] = TRIPLE_DOUBLE_QUOTED = new TRIPLE_DOUBLE_QUOTED("TRIPLE_DOUBLE_QUOTED", 3);
        stringKindArray[4] = SLASHY = new SLASHY("SLASHY", 4);
        stringKindArray[5] = DOLLAR_SLASHY = new DOLLAR_SLASHY("DOLLAR_SLASHY", 5);
        $VALUES = stringKindArray;
    }

    @NonNls
    @NotNull
    public String getLineBreaker() {
        return "\n";
    }

    @NotNull
    public abstract String escape(@NotNull String var1);

    @NotNull
    public abstract String unescape(@NotNull String var1);

    private StringKind() {
    }

    public /* synthetic */ StringKind(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static StringKind[] values() {
        return (StringKind[])$VALUES.clone();
    }

    public static StringKind valueOf(String string) {
        return Enum.valueOf(StringKind.class, string);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/groovy/lang/psi/util/StringKind$SINGLE_QUOTED;", "Lorg/jetbrains/plugins/groovy/lang/psi/util/StringKind;", "lineBreaker", "", "getLineBreaker", "()Ljava/lang/String;", "escape", "unescaped", "unescape", "escaped", "intellij.groovy.psi"})
    static final class SINGLE_QUOTED
    extends StringKind {
        @Override
        @NotNull
        public String getLineBreaker() {
            return "\\n' +\n'";
        }

        @Override
        @NotNull
        public String escape(@NotNull String unescaped) {
            return GrStringUtil.escapeSymbolsForString(unescaped, true, false);
        }

        @Override
        @NotNull
        public String unescape(@NotNull String escaped) {
            return GrStringUtil.unescapeString(escaped);
        }

        /*
         * WARNING - void declaration
         */
        SINGLE_QUOTED() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/groovy/lang/psi/util/StringKind$TRIPLE_SINGLE_QUOTED;", "Lorg/jetbrains/plugins/groovy/lang/psi/util/StringKind;", "escape", "", "unescaped", "unescape", "escaped", "intellij.groovy.psi"})
    static final class TRIPLE_SINGLE_QUOTED
    extends StringKind {
        @Override
        @NotNull
        public String escape(@NotNull String unescaped) {
            return GrStringUtil.escapeSymbolsForString(unescaped, false, false);
        }

        @Override
        @NotNull
        public String unescape(@NotNull String escaped) {
            return GrStringUtil.unescapeString(escaped);
        }

        /*
         * WARNING - void declaration
         */
        TRIPLE_SINGLE_QUOTED() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/groovy/lang/psi/util/StringKind$DOUBLE_QUOTED;", "Lorg/jetbrains/plugins/groovy/lang/psi/util/StringKind;", "lineBreaker", "", "getLineBreaker", "()Ljava/lang/String;", "escape", "unescaped", "unescape", "escaped", "intellij.groovy.psi"})
    static final class DOUBLE_QUOTED
    extends StringKind {
        @Override
        @NotNull
        public String getLineBreaker() {
            return "\\n\" +\n\"";
        }

        @Override
        @NotNull
        public String escape(@NotNull String unescaped) {
            return GrStringUtil.escapeSymbolsForGString(unescaped, true, false);
        }

        @Override
        @NotNull
        public String unescape(@NotNull String escaped) {
            return GrStringUtil.unescapeString(escaped);
        }

        /*
         * WARNING - void declaration
         */
        DOUBLE_QUOTED() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/groovy/lang/psi/util/StringKind$TRIPLE_DOUBLE_QUOTED;", "Lorg/jetbrains/plugins/groovy/lang/psi/util/StringKind;", "escape", "", "unescaped", "unescape", "escaped", "intellij.groovy.psi"})
    static final class TRIPLE_DOUBLE_QUOTED
    extends StringKind {
        @Override
        @NotNull
        public String escape(@NotNull String unescaped) {
            return GrStringUtil.escapeSymbolsForGString(unescaped, false, false);
        }

        @Override
        @NotNull
        public String unescape(@NotNull String escaped) {
            return GrStringUtil.unescapeString(escaped);
        }

        /*
         * WARNING - void declaration
         */
        TRIPLE_DOUBLE_QUOTED() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/groovy/lang/psi/util/StringKind$SLASHY;", "Lorg/jetbrains/plugins/groovy/lang/psi/util/StringKind;", "escape", "", "unescaped", "unescape", "escaped", "intellij.groovy.psi"})
    static final class SLASHY
    extends StringKind {
        @Override
        @NotNull
        public String escape(@NotNull String unescaped) {
            return GrStringUtil.escapeSymbolsForSlashyStrings(unescaped);
        }

        @Override
        @NotNull
        public String unescape(@NotNull String escaped) {
            return GrStringUtil.unescapeSlashyString(escaped);
        }

        /*
         * WARNING - void declaration
         */
        SLASHY() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/groovy/lang/psi/util/StringKind$DOLLAR_SLASHY;", "Lorg/jetbrains/plugins/groovy/lang/psi/util/StringKind;", "escape", "", "unescaped", "unescape", "escaped", "intellij.groovy.psi"})
    static final class DOLLAR_SLASHY
    extends StringKind {
        @Override
        @NotNull
        public String escape(@NotNull String unescaped) {
            return GrStringUtil.escapeSymbolsForDollarSlashyStrings(unescaped);
        }

        @Override
        @NotNull
        public String unescape(@NotNull String escaped) {
            return GrStringUtil.unescapeDollarSlashyString(escaped);
        }

        /*
         * WARNING - void declaration
         */
        DOLLAR_SLASHY() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/groovy/lang/psi/util/StringKind$TestsOnly;", "", "()V", "DOLLAR_SLASHY", "Lorg/jetbrains/plugins/groovy/lang/psi/util/StringKind;", "DOUBLE_QUOTED", "SINGLE_QUOTED", "SLASHY", "TRIPLE_DOUBLE_QUOTED", "TRIPLE_SINGLE_QUOTED", "intellij.groovy.psi"})
    @ApiStatus.Internal
    @TestOnly
    public static final class TestsOnly {
        @JvmField
        @NotNull
        public static final StringKind SINGLE_QUOTED;
        @JvmField
        @NotNull
        public static final StringKind TRIPLE_SINGLE_QUOTED;
        @JvmField
        @NotNull
        public static final StringKind DOUBLE_QUOTED;
        @JvmField
        @NotNull
        public static final StringKind TRIPLE_DOUBLE_QUOTED;
        @JvmField
        @NotNull
        public static final StringKind SLASHY;
        @JvmField
        @NotNull
        public static final StringKind DOLLAR_SLASHY;
        @NotNull
        public static final TestsOnly INSTANCE;

        private TestsOnly() {
        }

        static {
            TestsOnly testsOnly;
            INSTANCE = testsOnly = new TestsOnly();
            SINGLE_QUOTED = SINGLE_QUOTED;
            TRIPLE_SINGLE_QUOTED = TRIPLE_SINGLE_QUOTED;
            DOUBLE_QUOTED = DOUBLE_QUOTED;
            TRIPLE_DOUBLE_QUOTED = TRIPLE_DOUBLE_QUOTED;
            SLASHY = SLASHY;
            DOLLAR_SLASHY = DOLLAR_SLASHY;
        }
    }
}

