/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyImportHelper;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyUnusedImportUtil;

public final class GroovyImportUtil {
    public static void processFile(final @NotNull GroovyFile file, final @NotNull Set<? super String> importedClasses, final @NotNull Set<? super String> staticallyImportedMembers, final @NotNull Set<? super GrImportStatement> usedImports, @NotNull Set<? super GrImportStatement> unresolvedOnDemandImports, final @NotNull Set<? super String> implicitlyImported, final @NotNull Set<? super String> innerClasses, final @NotNull Map<String, String> aliased, final @NotNull Map<String, String> annotations2) {
        final LinkedHashSet unresolvedReferenceNames = new LinkedHashSet();
        file.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (!(element instanceof GrImportStatement) && !(element instanceof GrPackageDefinition)) {
                    super.visitElement(element);
                }
                if (element instanceof GrReferenceElement) {
                    this.visitRefElement((GrReferenceElement)element);
                }
            }

            private void visitRefElement(GrReferenceElement refElement) {
                if (refElement.isQualified()) {
                    return;
                }
                String refName = refElement.getReferenceName();
                if ("super".equals(refName)) {
                    return;
                }
                GroovyResolveResult[] resolveResults = refElement.multiResolve(false);
                if (resolveResults.length == 0 && refName != null && PsiTreeUtil.getParentOfType((PsiElement)refElement, GrImportStatement.class) == null) {
                    unresolvedReferenceNames.add(refName);
                }
                for (GroovyResolveResult resolveResult2 : resolveResults) {
                    PsiElement context = resolveResult2.getCurrentFileResolveContext();
                    PsiElement resolved = resolveResult2.getElement();
                    if (resolved == null) {
                        return;
                    }
                    if (context instanceof GrImportStatement) {
                        GrImportStatement importStatement = (GrImportStatement)context;
                        usedImports.add(importStatement);
                        if (GroovyImportHelper.isImplicitlyImported(resolved, refName, file)) {
                            this.addImplicitClass(resolved);
                        }
                        if (importStatement.isAliasedImport() || GroovyImportUtil.isAnnotatedImport(importStatement)) continue;
                        Object importedName = null;
                        if (importStatement.isOnDemand()) {
                            if (importStatement.isStatic()) {
                                String name;
                                String classQName;
                                PsiMember member;
                                PsiClass clazz;
                                if (resolved instanceof PsiMember && (clazz = (member = (PsiMember)resolved).getContainingClass()) != null && (classQName = clazz.getQualifiedName()) != null && (name = member.getName()) != null) {
                                    importedName = classQName + "." + name;
                                }
                            } else {
                                importedName = GroovyImportUtil.getTargetQualifiedName(resolved);
                            }
                        } else {
                            importedName = importStatement.getImportFqn();
                        }
                        if (importedName == null) {
                            return;
                        }
                        String importRef = importStatement.getImportFqn();
                        if (importStatement.isAliasedImport()) {
                            aliased.put(importRef, importedName);
                            return;
                        }
                        if (importStatement.isStatic()) {
                            staticallyImportedMembers.add(importedName);
                            continue;
                        }
                        importedClasses.add(importedName);
                        if (!(resolved instanceof PsiClass) || ((PsiClass)resolved).getContainingClass() == null) continue;
                        innerClasses.add(importedName);
                        continue;
                    }
                    if (context != null || refElement.getParent() instanceof GrImportStatement || refElement.getQualifier() != null || resolved instanceof PsiClass && ((PsiClass)resolved).getContainingClass() != null) continue;
                    this.addImplicitClass(resolved);
                }
            }

            private void addImplicitClass(PsiElement element) {
                String qname = GroovyImportUtil.getTargetQualifiedName(element);
                if (qname != null) {
                    implicitlyImported.add(qname);
                    importedClasses.add(qname);
                }
            }
        });
        LinkedHashSet<GrImportStatement> importsToCheck = new LinkedHashSet<GrImportStatement>(PsiUtil.getValidImportStatements(file));
        for (GrImportStatement anImport : importsToCheck) {
            if (usedImports.contains(anImport)) continue;
            GrCodeReferenceElement ref = anImport.getImportReference();
            assert (ref != null) : "invalid import!";
            if (ref.resolve() != null) continue;
            if (anImport.isOnDemand()) {
                usedImports.add(anImport);
                unresolvedOnDemandImports.add(anImport);
                continue;
            }
            String importedName = anImport.getImportedName();
            if (importedName == null || !unresolvedReferenceNames.contains(importedName)) continue;
            usedImports.add(anImport);
            String symbolName = anImport.getImportFqn();
            if (anImport.isAliasedImport()) {
                aliased.put(symbolName, importedName);
                continue;
            }
            if (anImport.isStatic()) {
                staticallyImportedMembers.add(symbolName);
                continue;
            }
            if (GroovyImportUtil.isAnnotatedImport(anImport)) continue;
            importedClasses.add(symbolName);
        }
        file.acceptChildren(new GroovyElementVisitor(){

            @Override
            public void visitImportStatement(@NotNull GrImportStatement importStatement) {
                String annotationText = importStatement.getAnnotationList().getText();
                if (!StringUtil.isEmptyOrSpaces((String)annotationText)) {
                    String importRef = importStatement.getImportFqn();
                    annotations2.put(importRef, annotationText);
                }
            }
        });
        usedImports.removeAll(GroovyUnusedImportUtil.unusedImports(file));
    }

    @Nullable
    private static String getTargetQualifiedName(PsiElement element) {
        PsiClass aClass;
        if (element instanceof PsiClass) {
            return ((PsiClass)element).getQualifiedName();
        }
        if (element instanceof PsiMethod && ((PsiMethod)element).isConstructor() && (aClass = ((PsiMethod)element).getContainingClass()) != null) {
            return aClass.getQualifiedName();
        }
        return null;
    }

    public static boolean isAnnotatedImport(GrImportStatement anImport) {
        return !StringUtil.isEmptyOrSpaces((String)anImport.getAnnotationList().getText());
    }
}

