/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;
import org.jetbrains.plugins.groovy.lang.psi.util.CompileStaticUtil;

public class GrGenericTypeConverter
extends GrTypeConverter {
    @Override
    public boolean isApplicableTo(@NotNull GrTypeConverter.Position position) {
        switch (position) {
            case METHOD_PARAMETER: 
            case GENERIC_PARAMETER: 
            case ASSIGNMENT: 
            case RETURN_VALUE: {
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public ConversionResult isConvertible(@NotNull PsiType ltype, @NotNull PsiType rtype, @NotNull GrTypeConverter.Position position, @NotNull GroovyPsiElement context) {
        if (!(ltype instanceof PsiClassType) || !(rtype instanceof PsiClassType)) {
            return null;
        }
        if (CompileStaticUtil.isCompileStatic(context)) {
            return null;
        }
        PsiClassType.ClassResolveResult lResult = ((PsiClassType)ltype).resolveGenerics();
        PsiClass lClass = lResult.getElement();
        if (lClass == null) {
            return null;
        }
        if (lClass.getTypeParameters().length == 0) {
            return null;
        }
        PsiClassType.ClassResolveResult rResult = ((PsiClassType)rtype).resolveGenerics();
        PsiClass rClass = rResult.getElement();
        if (rClass == null) {
            return null;
        }
        if (!InheritanceUtil.isInheritorOrSelf((PsiClass)rClass, (PsiClass)lClass, (boolean)true)) {
            return null;
        }
        if (!((PsiClassType)ltype).hasParameters()) {
            return ConversionResult.OK;
        }
        if (GrGenericTypeConverter.typeParametersAgree(lClass, rClass, lResult.getSubstitutor(), rResult.getSubstitutor(), context)) {
            return ConversionResult.OK;
        }
        return null;
    }

    public static boolean typeParametersAgree(@NotNull PsiClass leftClass, @NotNull PsiClass rightClass, @NotNull PsiSubstitutor leftSubstitutor, @NotNull PsiSubstitutor rightSubstitutor, @NotNull PsiElement context) {
        if (!leftClass.hasTypeParameters()) {
            return true;
        }
        if (!leftClass.getManager().areElementsEquivalent((PsiElement)leftClass, (PsiElement)rightClass)) {
            rightSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)leftClass, (PsiClass)rightClass, (PsiSubstitutor)rightSubstitutor);
            rightClass = leftClass;
        } else if (!rightClass.hasTypeParameters()) {
            return true;
        }
        Iterator li = PsiUtil.typeParametersIterator((PsiTypeParameterListOwner)leftClass);
        Iterator ri = PsiUtil.typeParametersIterator((PsiTypeParameterListOwner)rightClass);
        while (li.hasNext()) {
            if (!ri.hasNext()) {
                return false;
            }
            PsiTypeParameter lp = (PsiTypeParameter)li.next();
            PsiTypeParameter rp = (PsiTypeParameter)ri.next();
            PsiType typeLeft = leftSubstitutor.substitute(lp);
            if (typeLeft == null) continue;
            PsiType typeRight = rightSubstitutor.substituteWithBoundsPromotion(rp);
            if (typeRight == null) {
                return true;
            }
            if (!(typeLeft instanceof PsiClassType && typeRight instanceof PsiClassType ? !TypesUtil.isAssignableByMethodCallConversion(typeLeft, typeRight, context) : !TypeConversionUtil.typesAgree((PsiType)typeLeft, (PsiType)typeRight, (boolean)true))) continue;
            return false;
        }
        return true;
    }
}

