/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;
import org.jetbrains.plugins.groovy.lang.psi.util.CompileStaticUtil;
import org.jetbrains.plugins.groovy.lang.typing.EmptyListLiteralType;

public class GrContainerTypeConverter
extends GrTypeConverter {
    @Override
    @Nullable
    public ConversionResult isConvertible(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull GrTypeConverter.Position position, @NotNull GroovyPsiElement context) {
        if (position == GrTypeConverter.Position.ASSIGNMENT && TypesUtil.resolvesTo(targetType, "java.util.Set") && actualType instanceof EmptyListLiteralType) {
            return ConversionResult.OK;
        }
        if (CompileStaticUtil.isCompileStatic(context)) {
            return GrContainerTypeConverter.isCSConvertible(targetType, actualType, context);
        }
        if (!GrContainerTypeConverter.isCollectionOrArray(targetType) || !GrContainerTypeConverter.isCollectionOrArray(actualType)) {
            return null;
        }
        PsiType lComponentType = GrContainerTypeConverter.extractComponentType(targetType);
        PsiType rComponentType = GrContainerTypeConverter.extractComponentType(actualType);
        if (lComponentType == null || rComponentType == null) {
            return ConversionResult.OK;
        }
        if (TypesUtil.isAssignableByParameter(lComponentType, rComponentType, context)) {
            return ConversionResult.OK;
        }
        return null;
    }

    @Nullable
    private static ConversionResult isCSConvertible(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull GroovyPsiElement context) {
        if (targetType instanceof PsiArrayType && actualType instanceof PsiArrayType) {
            return TypesUtil.isAssignableByParameter(((PsiArrayType)targetType).getComponentType(), ((PsiArrayType)actualType).getComponentType(), context) ? ConversionResult.OK : ConversionResult.ERROR;
        }
        return null;
    }

    @Override
    public boolean isApplicableTo(@NotNull GrTypeConverter.Position position) {
        return position != GrTypeConverter.Position.METHOD_PARAMETER;
    }

    @Nullable
    private static PsiType extractComponentType(PsiType type2) {
        if (type2 instanceof PsiArrayType) {
            return ((PsiArrayType)type2).getComponentType();
        }
        return PsiUtil.substituteTypeParameter((PsiType)type2, (String)"java.util.Collection", (int)0, (boolean)false);
    }

    private static boolean isCollectionOrArray(PsiType type2) {
        return type2 instanceof PsiArrayType || InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Collection");
    }
}

