/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs.elements;

import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.params.GrParameterImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrParameterStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrStubUtils;
import org.jetbrains.plugins.groovy.lang.psi.stubs.elements.GrStubElementType;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnnotatedMemberIndex;

public class GrParameterElementType
extends GrStubElementType<GrParameterStub, GrParameter> {
    public GrParameterElementType(String debugName) {
        super(debugName);
    }

    public GrParameter createPsi(@NotNull GrParameterStub stub) {
        return new GrParameterImpl(stub);
    }

    @NotNull
    public GrParameterStub createStub(@NotNull GrParameter psi, StubElement parentStub) {
        return new GrParameterStub(parentStub, StringRef.fromString((String)psi.getName()), GrStubUtils.getAnnotationNames((PsiModifierListOwner)psi), GrStubUtils.getTypeText(psi.getTypeElementGroovy()), GrParameterStub.encodeFlags(psi.getInitializerGroovy() != null, psi.isVarArgs()));
    }

    public void serialize(@NotNull GrParameterStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getName());
        GrStubUtils.writeStringArray(dataStream, stub.getAnnotations());
        GrStubUtils.writeNullableString(dataStream, stub.getTypeText());
        dataStream.writeVarInt(stub.getFlags());
    }

    @NotNull
    public GrParameterStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef name = dataStream.readName();
        String[] annotations2 = GrStubUtils.readStringArray(dataStream);
        String typeText = GrStubUtils.readNullableString(dataStream);
        int flags = dataStream.readVarInt();
        return new GrParameterStub(parentStub, name, annotations2, typeText, flags);
    }

    @Override
    public void indexStub(@NotNull GrParameterStub stub, @NotNull IndexSink sink) {
        for (String annName : stub.getAnnotations()) {
            if (annName == null) continue;
            sink.occurrence(GrAnnotatedMemberIndex.KEY, (Object)annName);
        }
    }
}

