/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyExpressionPattern;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00002\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006J/\u0010\b\u001a\u00020\u00002\"\u0010\t\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u00060\n\"\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0006\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\r\u001a\u00020\u00002\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006J\u0016\u0010\u000e\u001a\u00020\u00002\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0006J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/groovy/lang/psi/patterns/GroovyMethodCallPattern;", "Lorg/jetbrains/plugins/groovy/lang/psi/patterns/GroovyExpressionPattern;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "()V", "resolvesTo", "methodPattern", "Lcom/intellij/patterns/ElementPattern;", "Lcom/intellij/psi/PsiMethod;", "withArguments", "arguments", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "([Lcom/intellij/patterns/ElementPattern;)Lorg/jetbrains/plugins/groovy/lang/psi/patterns/GroovyMethodCallPattern;", "withMethod", "withMethodName", "methodName", "", "intellij.groovy.psi"})
public final class GroovyMethodCallPattern
extends GroovyExpressionPattern<GrCallExpression, GroovyMethodCallPattern> {
    @NotNull
    public static final GroovyMethodCallPattern INSTANCE;

    @NotNull
    public final GroovyMethodCallPattern withArguments(ElementPattern<? extends GrExpression> ... arguments2) {
        return (GroovyMethodCallPattern)this.with((PatternCondition)new PatternCondition<GrCallExpression>(arguments2, "withArguments"){
            final /* synthetic */ ElementPattern[] $arguments;

            /*
             * WARNING - void declaration
             */
            public boolean accepts(@NotNull GrCallExpression callExpression, @NotNull ProcessingContext context) {
                GrArgumentList grArgumentList = callExpression.getArgumentList();
                if (grArgumentList == null) {
                    return false;
                }
                GrArgumentList argumentList = grArgumentList;
                Object[] actualArguments = argumentList.getExpressionArguments();
                if (this.$arguments.length != actualArguments.length) {
                    return false;
                }
                for (Pair pair : ArraysKt.zip((Object[])actualArguments, (Object[])this.$arguments)) {
                    void argument;
                    GrExpression grExpression = (GrExpression)pair.component1();
                    ElementPattern argumentPattern = (ElementPattern)pair.component2();
                    if (argumentPattern.accepts((Object)argument, context)) continue;
                    return false;
                }
                return true;
            }
            {
                this.$arguments = $captured_local_variable$0;
                super($super_call_param$1);
            }
        });
    }

    @NotNull
    public final GroovyMethodCallPattern withMethodName(@NotNull String methodName) {
        return this.withMethodName((ElementPattern<? extends String>)((ElementPattern)StandardPatterns.string().equalTo((Object)methodName)));
    }

    @NotNull
    public final GroovyMethodCallPattern withMethodName(@NotNull ElementPattern<? extends String> methodName) {
        return (GroovyMethodCallPattern)this.with((PatternCondition)new PatternCondition<GrCallExpression>(methodName, "withMethodName"){
            final /* synthetic */ ElementPattern $methodName;

            public boolean accepts(@NotNull GrCallExpression callExpression, @NotNull ProcessingContext context) {
                if (!(callExpression instanceof GrMethodCall)) {
                    return false;
                }
                GrExpression grExpression = ((GrMethodCall)callExpression).getInvokedExpression();
                if (!(grExpression instanceof GrReferenceExpression)) {
                    grExpression = null;
                }
                GrReferenceExpression grReferenceExpression = (GrReferenceExpression)grExpression;
                if (grReferenceExpression == null) {
                    return false;
                }
                GrReferenceExpression expression = grReferenceExpression;
                return this.$methodName.accepts((Object)expression.getReferenceName(), context);
            }
            {
                this.$methodName = $captured_local_variable$0;
                super($super_call_param$1);
            }
        });
    }

    @NotNull
    public final GroovyMethodCallPattern withMethod(@NotNull ElementPattern<? extends PsiMethod> methodPattern) {
        return (GroovyMethodCallPattern)this.with((PatternCondition)new PatternCondition<GrCallExpression>(methodPattern, "methodCall"){
            final /* synthetic */ ElementPattern $methodPattern;

            public boolean accepts(@NotNull GrCallExpression callExpression, @NotNull ProcessingContext context) {
                for (GroovyResolveResult result2 : callExpression.getCallVariants(null)) {
                    if (!this.$methodPattern.accepts((Object)result2.getElement(), context)) continue;
                    return true;
                }
                return false;
            }
            {
                this.$methodPattern = $captured_local_variable$0;
                super($super_call_param$1);
            }
        });
    }

    @NotNull
    public final GroovyMethodCallPattern resolvesTo(@NotNull ElementPattern<? extends PsiMethod> methodPattern) {
        return (GroovyMethodCallPattern)this.with((PatternCondition)new PatternCondition<GrCallExpression>(methodPattern, "resolvesTo"){
            final /* synthetic */ ElementPattern $methodPattern;

            public boolean accepts(@NotNull GrCallExpression t, @Nullable ProcessingContext context) {
                PsiElement psiElement = t.advancedResolve().getElement();
                if (!(psiElement instanceof PsiMethod)) {
                    psiElement = null;
                }
                PsiMethod psiMethod = (PsiMethod)psiElement;
                if (psiMethod == null) {
                    return false;
                }
                PsiMethod result2 = psiMethod;
                return this.$methodPattern.accepts((Object)result2, context);
            }
            {
                this.$methodPattern = $captured_local_variable$0;
                super($super_call_param$1);
            }
        });
    }

    private GroovyMethodCallPattern() {
        super(GrCallExpression.class);
    }

    static {
        GroovyMethodCallPattern groovyMethodCallPattern;
        INSTANCE = groovyMethodCallPattern = new GroovyMethodCallPattern();
    }
}

