/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.types;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrDisjunctionTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrDisjunctionTypeElementImpl
extends GroovyPsiElementImpl
implements GrDisjunctionTypeElement {
    private volatile PsiType myCachedType;

    public GrDisjunctionTypeElementImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public GrTypeElement @NotNull [] getTypeElements() {
        return (GrTypeElement[])this.findChildrenByClass(GrTypeElement.class);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitDisjunctionTypeElement(this);
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiType cachedType = this.myCachedType;
        if (cachedType != null) {
            return this.myCachedType;
        }
        GrTypeElement[] typeElements = this.getTypeElements();
        ArrayList<PsiType> types = new ArrayList<PsiType>();
        for (GrTypeElement typeElement : typeElements) {
            types.add(typeElement.getType());
        }
        this.myCachedType = cachedType = new PsiDisjunctionType(types, (PsiManager)this.getManager());
        return cachedType;
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.myCachedType = null;
    }

    public String toString() {
        return "disjunction type element";
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        PsiElement psi = child.getPsi();
        if (psi instanceof GrTypeElement) {
            PsiElement next = PsiUtil.skipWhitespacesAndComments(psi.getNextSibling(), true);
            if (next != null) {
                if (next.getNode().getElementType() == GroovyTokenTypes.mBOR) {
                    super.deleteChildInternal(next.getNode());
                }
            } else {
                PsiElement prev = PsiUtil.skipWhitespacesAndComments(psi.getPrevSibling(), false);
                if (prev != null && prev.getNode().getElementType() == GroovyTokenTypes.mBOR) {
                    super.deleteChildInternal(prev.getNode());
                }
            }
        }
        super.deleteChildInternal(child);
    }

    @Override
    public GrAnnotation @NotNull [] getAnnotations() {
        return (GrAnnotation[])this.findChildrenByType((IElementType)GroovyStubElementTypes.ANNOTATION, GrAnnotation.class);
    }
}

