/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.types;

import com.intellij.lang.ASTNode;
import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.types.CodeReferenceKind;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrReferenceElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.util.PropertyUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.GrCodeReferenceResolver;

public class GrCodeReferenceElementImpl
extends GrReferenceElementImpl<GrCodeReferenceElement>
implements GrCodeReferenceElement {
    private static final Logger LOG = Logger.getInstance(GrCodeReferenceElementImpl.class);
    private volatile String myCachedTextSkipWhiteSpaceAndComments;

    public GrCodeReferenceElementImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void subtreeChanged() {
        this.myCachedTextSkipWhiteSpaceAndComments = null;
        super.subtreeChanged();
    }

    private String getTextSkipWhiteSpaceAndComments() {
        String whiteSpaceAndComments = this.myCachedTextSkipWhiteSpaceAndComments;
        if (whiteSpaceAndComments == null) {
            this.myCachedTextSkipWhiteSpaceAndComments = whiteSpaceAndComments = PsiImplUtil.getTextSkipWhiteSpaceAndComments(this.getNode());
        }
        return whiteSpaceAndComments;
    }

    public PsiReference getReference() {
        return this;
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (StringUtil.isJavaIdentifier((String)newElementName)) {
            return super.handleElementRename(newElementName);
        }
        throw new IncorrectOperationException("Cannot rename reference to '" + newElementName + "'");
    }

    @Override
    @NotNull
    protected GrReferenceElement<GrCodeReferenceElement> createQualifiedRef(@NotNull String qName) {
        return GroovyPsiElementFactory.getInstance(this.getProject()).createCodeReference(qName);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitCodeReferenceElement(this);
    }

    public String toString() {
        return "Reference element";
    }

    @Override
    public GrCodeReferenceElement getQualifier() {
        return (GrCodeReferenceElement)this.findChildByType(GroovyElementTypes.REFERENCE_ELEMENT);
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return this.findChildByType(TokenSets.CODE_REFERENCE_ELEMENT_NAME_TOKENS);
    }

    @NotNull
    public String getCanonicalText() {
        switch (this.getKind()) {
            case PACKAGE_REFERENCE: 
            case IMPORT_REFERENCE: {
                return this.getTextSkipWhiteSpaceAndComments();
            }
            case REFERENCE: {
                PsiElement target = this.resolve();
                if (target instanceof PsiTypeParameter) {
                    return StringUtil.notNullize((String)((PsiTypeParameter)target).getName());
                }
                if (target instanceof PsiClass) {
                    PsiClass aClass = (PsiClass)target;
                    String name = aClass.getQualifiedName();
                    if (name == null) {
                        return "";
                    }
                    PsiType[] types = this.getTypeArguments();
                    if (types.length == 0) {
                        return name;
                    }
                    StringBuilder buf = new StringBuilder();
                    buf.append(name);
                    buf.append('<');
                    for (int i = 0; i < types.length; ++i) {
                        if (i > 0) {
                            buf.append(',');
                        }
                        buf.append(types[i].getCanonicalText());
                    }
                    buf.append('>');
                    return buf.toString();
                }
                if (target instanceof PsiPackage) {
                    return ((PsiPackage)target).getQualifiedName();
                }
                LOG.assertTrue(target == null);
                return this.getTextSkipWhiteSpaceAndComments();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    protected boolean bindsCorrectly(PsiElement element) {
        PsiMethod method;
        PsiElement resolved;
        if (super.bindsCorrectly(element)) {
            return true;
        }
        return element instanceof PsiClass && (resolved = this.resolve()) instanceof PsiMethod && (method = (PsiMethod)resolved).isConstructor() && this.getManager().areElementsEquivalent(element, (PsiElement)method.getContainingClass());
    }

    @Override
    public boolean isFullyQualified() {
        PsiElement resolved = this.resolve();
        if (resolved instanceof PsiPackage) {
            return true;
        }
        if (resolved instanceof PsiClass) {
            String qualifiedReferenceName = this.getQualifiedReferenceName();
            if (qualifiedReferenceName == null) {
                return false;
            }
            String classFqn = ((PsiClass)resolved).getQualifiedName();
            if (classFqn == null) {
                return false;
            }
            return qualifiedReferenceName.equals(classFqn);
        }
        return false;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        switch (this.getKind()) {
            case PACKAGE_REFERENCE: {
                return this.referencesPackage(element);
            }
            case REFERENCE: {
                return this.referencesPackage(element) || element instanceof PsiClass && this.resolvesTo(element);
            }
            case IMPORT_REFERENCE: {
                return (element instanceof PsiClass || element instanceof PsiField) && this.checkName((PsiNamedElement)element) && this.resolvesTo(element) || element instanceof PsiMethod && this.checkPropertyName((PsiNamedElement)element) && this.multiResolvesTo(element) || element instanceof PsiPackage && this.referencesPackage(element);
            }
        }
        throw new IllegalStateException();
    }

    private boolean referencesPackage(@NotNull PsiElement element) {
        return element instanceof PsiPackage && this.checkName((PsiNamedElement)element) && this.resolvesTo(element);
    }

    private boolean checkName(@NotNull PsiNamedElement namedElement) {
        String referenceName = this.getReferenceName();
        if (referenceName == null) {
            return false;
        }
        String name = namedElement.getName();
        return referenceName.equals(name);
    }

    private boolean checkPropertyName(@NotNull PsiNamedElement namedElement) {
        String referenceName = this.getReferenceName();
        if (referenceName == null) {
            return false;
        }
        String name = namedElement.getName();
        if (name == null) {
            return false;
        }
        return referenceName.equals(name) || ContainerUtil.or((Object[])PropertyKind.values(), kind -> PropertyUtilKt.getAccessorName(kind, referenceName).equals(name));
    }

    private boolean resolvesTo(@NotNull PsiElement element) {
        return this.getManager().areElementsEquivalent(element, this.resolve());
    }

    private boolean multiResolvesTo(@NotNull PsiElement element) {
        PsiManagerEx manager = this.getManager();
        return this.resolve(false).stream().map(it -> it.getElement()).anyMatch(arg_0 -> GrCodeReferenceElementImpl.lambda$multiResolvesTo$2((PsiManager)manager, element, arg_0));
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    @NotNull
    public Collection<? extends GroovyResolveResult> resolve(boolean incomplete) {
        return TypeInferenceHelper.getTopContext().resolve(this, incomplete, GrCodeReferenceResolver.INSTANCE);
    }

    @Override
    public PsiType @NotNull [] getTypeArguments() {
        if (PsiImplUtilKt.shouldInferTypeArguments(this)) {
            return PsiImplUtilKt.getDiamondTypes(this);
        }
        return super.getTypeArguments();
    }

    @Override
    @NotNull
    public CodeReferenceKind getKind() {
        return PsiImplUtilKt.doGetKind(this);
    }

    @Override
    public GrAnnotation @NotNull [] getAnnotations() {
        return (GrAnnotation[])this.findChildrenByType((IElementType)GroovyStubElementTypes.ANNOTATION, GrAnnotation.class);
    }

    private static /* synthetic */ boolean lambda$multiResolvesTo$2(PsiManager manager, PsiElement element, PsiElement it) {
        return manager.areElementsEquivalent(it, element);
    }
}

