/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.impl.light.LightReferenceListBuilder;
import com.intellij.psi.impl.light.LightTypeParameterListBuilder;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifier;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrModifierListUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightModifierList;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameterListBuilder;
import org.jetbrains.plugins.groovy.lang.psi.util.GrInnerClassConstructorUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrReflectedMethodImpl
extends LightMethodBuilder
implements GrReflectedMethod {
    private static final Logger LOG = Logger.getInstance(GrReflectedMethodImpl.class);
    @NonNls
    public static final String CATEGORY_PARAMETER_NAME = "self";
    private final GrMethod myBaseMethod;
    private GrParameter[] mySkippedParameters = null;

    public GrReflectedMethodImpl(GrMethod baseMethod, GrParameter[] parameters2, int optionalParams, PsiClassType categoryType) {
        super(baseMethod.getManager(), baseMethod.getLanguage(), baseMethod.getName(), (PsiParameterList)new GrLightParameterListBuilder(baseMethod.getManager(), baseMethod.getLanguage()), (PsiModifierList)new GrLightModifierList(baseMethod), (PsiReferenceList)new LightReferenceListBuilder(baseMethod.getManager(), baseMethod.getLanguage(), null), (PsiTypeParameterList)new LightTypeParameterListBuilder(baseMethod.getManager(), baseMethod.getLanguage()));
        this.initParameterList(parameters2, optionalParams, categoryType);
        this.initTypeParameterList(baseMethod);
        this.initModifiers(baseMethod, categoryType != null);
        this.initThrowsList(baseMethod);
        this.setContainingClass(baseMethod.getContainingClass());
        this.setMethodReturnType(baseMethod.getReturnType());
        this.setConstructor(baseMethod.isConstructor());
        this.myBaseMethod = baseMethod;
    }

    private void initTypeParameterList(GrMethod method) {
        for (PsiTypeParameter parameter : method.getTypeParameters()) {
            this.addTypeParameter(parameter);
        }
    }

    private void initThrowsList(GrMethod baseMethod) {
        for (PsiClassType exception : baseMethod.getThrowsList().getReferencedTypes()) {
            this.addException(exception);
        }
    }

    private void initModifiers(GrMethod baseMethod, boolean isCategoryMethod) {
        GrLightModifierList myModifierList2 = (GrLightModifierList)this.getModifierList();
        for (String modifier : GrModifier.GROOVY_MODIFIERS) {
            if (!baseMethod.getModifierList().hasExplicitModifier(modifier)) continue;
            myModifierList2.addModifier(modifier);
        }
        for (GrAnnotation annotation : baseMethod.getModifierList().getRawAnnotations()) {
            String qualifiedName = annotation.getQualifiedName();
            if (qualifiedName != null) {
                myModifierList2.addAnnotation(qualifiedName);
                continue;
            }
            myModifierList2.addAnnotation(annotation.getShortName());
        }
        if (isCategoryMethod) {
            myModifierList2.addModifier("static");
        }
        if (this.mySkippedParameters.length != 0) {
            myModifierList2.removeModifier(1024);
        }
    }

    private void initParameterList(GrParameter[] parameters2, int optionalParams, PsiClassType categoryType) {
        GrLightParameterListBuilder parameterList = (GrLightParameterListBuilder)this.getParameterList();
        ArrayList<GrParameter> skipped = new ArrayList<GrParameter>();
        if (categoryType != null) {
            parameterList.addParameter(new GrLightParameter(CATEGORY_PARAMETER_NAME, (PsiType)categoryType, this));
        }
        for (GrParameter parameter : parameters2) {
            if (parameter.isOptional()) {
                if (optionalParams < 1) {
                    skipped.add(parameter);
                    continue;
                }
                --optionalParams;
            }
            parameterList.addParameter(this.createLightParameter(parameter));
        }
        LOG.assertTrue(optionalParams == 0);
        this.mySkippedParameters = skipped.toArray(GrParameter.EMPTY_ARRAY);
    }

    private GrLightParameter createLightParameter(GrParameter parameter) {
        GrLightParameter lightParameter = new GrLightParameter(parameter.getName(), parameter.getDeclaredType(), this);
        lightParameter.setModifierList(parameter.getModifierList());
        return lightParameter;
    }

    @Override
    @NotNull
    public GrMethod getBaseMethod() {
        return this.myBaseMethod;
    }

    @Override
    public GrParameter @NotNull [] getSkippedParameters() {
        return this.mySkippedParameters;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        return this.myBaseMethod.getNavigationElement();
    }

    @Override
    public GrOpenBlock getBlock() {
        return this.myBaseMethod.getBlock();
    }

    @Override
    public void setBlock(GrCodeBlock newBlock) {
        throw new UnsupportedOperationException("synthetic method!");
    }

    @Override
    public GrTypeElement getReturnTypeElementGroovy() {
        return this.myBaseMethod.getReturnTypeElementGroovy();
    }

    @Override
    public PsiType getInferredReturnType() {
        return this.myBaseMethod.getInferredReturnType();
    }

    @Override
    public GrTypeElement setReturnType(@Nullable PsiType newReturnType) {
        throw new UnsupportedOperationException("synthetic method!");
    }

    @Override
    @NotNull
    public Map<String, NamedArgumentDescriptor> getNamedParameters() {
        return this.myBaseMethod.getNamedParameters();
    }

    @Override
    public GrReflectedMethod @NotNull [] getReflectedMethods() {
        return GrReflectedMethod.EMPTY_ARRAY;
    }

    @Override
    public GrMember[] getMembers() {
        return this.myBaseMethod.getMembers();
    }

    @Override
    @NotNull
    public PsiElement getNameIdentifierGroovy() {
        return this.myBaseMethod.getNameIdentifierGroovy();
    }

    @Override
    public GrParameter @NotNull [] getParameters() {
        return this.getParameterList().getParameters();
    }

    @Override
    @NotNull
    public GrParameterList getParameterList() {
        return (GrParameterList)super.getParameterList();
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitMethod(this);
    }

    @Override
    public void acceptChildren(@NotNull GroovyElementVisitor visitor2) {
    }

    @Override
    public GrDocComment getDocComment() {
        return this.myBaseMethod.getDocComment();
    }

    public String toString() {
        return this.getName() + " (" + StringUtil.join((Object[])this.getParameters(), f -> f.getType().getPresentableText() + " " + f.getName(), (String)", ") + ")";
    }

    @Override
    @NotNull
    public GrModifierList getModifierList() {
        return (GrModifierList)super.getModifierList();
    }

    public Icon getIcon(int flags) {
        return this.myBaseMethod.getIcon(flags);
    }

    public PsiIdentifier getNameIdentifier() {
        return PsiUtil.getJavaNameIdentifier(this.myBaseMethod);
    }

    public boolean isPhysical() {
        return this.myBaseMethod.isPhysical();
    }

    public static GrReflectedMethod @NotNull [] createReflectedMethods(GrMethod method) {
        return (GrReflectedMethod[])CachedValuesManager.getCachedValue((PsiElement)method, () -> CachedValueProvider.Result.create((Object)GrReflectedMethodImpl.doCreateReflectedMethods(method, null, method.getParameters()), (Object[])new Object[]{method}));
    }

    public static GrReflectedMethod @NotNull [] doCreateReflectedMethods(@NotNull GrMethod targetMethod, @Nullable PsiClassType categoryType, GrParameter @NotNull [] parameters2) {
        int count = 0;
        for (GrParameter parameter : parameters2) {
            if (!parameter.isOptional()) continue;
            ++count;
        }
        if (count == 0 && categoryType == null) {
            return GrReflectedMethod.EMPTY_ARRAY;
        }
        GrReflectedMethod[] methods = new GrReflectedMethod[count + 1];
        for (int i = 0; i <= count; ++i) {
            methods[i] = new GrReflectedMethodImpl(targetMethod, parameters2, count - i, categoryType);
        }
        return methods;
    }

    public static GrReflectedMethod[] createReflectedConstructors(GrMethod method) {
        assert (method.isConstructor());
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return GrReflectedMethod.EMPTY_ARRAY;
        }
        PsiClass enclosingClass = aClass.getContainingClass();
        if (enclosingClass != null && !GrModifierListUtil.hasCodeModifierProperty((PsiModifierListOwner)aClass, "static")) {
            GrParameter[] parameters2 = GrInnerClassConstructorUtil.addEnclosingInstanceParam(method, enclosingClass, method.getParameterList().getParameters(), false);
            GrReflectedMethod[] reflectedMethods = GrReflectedMethodImpl.doCreateReflectedMethods(method, null, parameters2);
            if (reflectedMethods.length > 0) {
                return reflectedMethods;
            }
            return new GrReflectedMethod[]{new GrReflectedMethodImpl(method, parameters2, 0, null)};
        }
        return GrReflectedMethodImpl.doCreateReflectedMethods(method, null, method.getParameters());
    }

    @NotNull
    public PsiElement getPrototype() {
        return this.getBaseMethod();
    }

    @Override
    public boolean hasBlock() {
        return this.getBaseMethod().hasBlock();
    }
}

