/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifier;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrModifierListImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrModifierListUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightAnnotation;

public final class GrLightModifierList
extends LightElement
implements GrModifierList {
    private int myModifiers;
    private final List<GrAnnotation> myAnnotations = new ArrayList<GrAnnotation>();
    private final PsiElement myParent;

    public GrLightModifierList(@NotNull PsiElement parent2) {
        super(parent2.getManager(), parent2.getLanguage());
        this.myParent = parent2;
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    public PsiFile getContainingFile() {
        return this.getParent().getContainingFile();
    }

    public void addModifier(String modifier) {
        int code = GrModifierListImpl.NAME_TO_MODIFIER_FLAG_MAP.getInt((Object)modifier);
        assert (code != 0);
        this.myModifiers |= code;
    }

    public void addModifier(int modifier) {
        this.myModifiers |= modifier;
    }

    public void removeModifier(int modifier) {
        this.myModifiers &= ~modifier;
    }

    public void setModifiers(int modifiers) {
        this.myModifiers = modifiers;
    }

    public void setModifiers(String ... modifiers) {
        this.myModifiers = 0;
        for (String modifier : modifiers) {
            this.addModifier(modifier);
        }
    }

    @Override
    public int getModifierFlags() {
        return this.myModifiers;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        return GrModifierListUtil.hasModifierProperty(this, name);
    }

    @Override
    public boolean hasExplicitModifier(@NotNull String name) {
        return GrModifierListUtil.hasExplicitModifier(this, name);
    }

    @Override
    public void setModifierProperty(@NotNull String name, boolean value) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public GrAnnotation @NotNull [] getRawAnnotations() {
        return this.getAnnotations();
    }

    public void checkSetModifierProperty(@NotNull String name, boolean value) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public GrAnnotation @NotNull [] getAnnotations() {
        return this.myAnnotations.toArray(GrAnnotation.EMPTY_ARRAY);
    }

    public PsiAnnotation @NotNull [] getApplicableAnnotations() {
        return this.getAnnotations();
    }

    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        for (GrAnnotation annotation : this.myAnnotations) {
            if (!annotation.hasQualifiedName(qualifiedName)) continue;
            return annotation;
        }
        return null;
    }

    @NotNull
    public GrLightAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        GrLightAnnotation annotation = new GrLightAnnotation(this.getManager(), this.getLanguage(), qualifiedName, this);
        this.myAnnotations.add(annotation);
        return annotation;
    }

    public void addAnnotation(@NotNull GrAnnotation annotation) {
        this.myAnnotations.add(annotation);
    }

    public void copyAnnotations(@Nullable GrModifierList other) {
        if (other == null) {
            return;
        }
        ContainerUtil.addAll(this.myAnnotations, (Object[])other.getAnnotations());
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitModifierList((PsiModifierList)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "GrModifierList";
    }

    public String getText() {
        StringBuilder buffer = new StringBuilder();
        for (GrAnnotation annotation : this.myAnnotations) {
            buffer.append(annotation.getText());
            buffer.append(' ');
        }
        for (String modifier : GrModifier.GROOVY_MODIFIERS) {
            if (!this.hasExplicitModifier(modifier)) continue;
            buffer.append(modifier);
            buffer.append(' ');
        }
        if (buffer.length() > 0) {
            buffer.delete(buffer.length() - 1, buffer.length());
        }
        return buffer.toString();
    }

    @Override
    public PsiElement @NotNull [] getModifiers() {
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    @Nullable
    public PsiElement getModifier(@GrModifier.GrModifierConstant @NotNull @NonNls String name) {
        return null;
    }

    @Override
    public boolean hasExplicitVisibilityModifiers() {
        return GrModifierListUtil.hasExplicitVisibilityModifiers(this);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitModifierList(this);
    }

    @Override
    public void acceptChildren(@NotNull GroovyElementVisitor visitor2) {
    }

    public void copyModifiers(@NotNull PsiModifierListOwner modifierOwner) {
        int mod = 0;
        PsiModifierList modifierList = modifierOwner.getModifierList();
        if (modifierList instanceof GrModifierList) {
            mod = ((GrModifierList)modifierList).getModifierFlags();
        } else if (modifierList != null) {
            for (String modifier : PsiModifier.MODIFIERS) {
                if (!modifierList.hasExplicitModifier(modifier)) continue;
                mod |= GrModifierListImpl.NAME_TO_MODIFIER_FLAG_MAP.getInt((Object)modifier);
            }
        }
        this.setModifiers(mod);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrLightModifierList list = (GrLightModifierList)o;
        return this.myModifiers == list.myModifiers && Objects.equals(this.myAnnotations, list.myAnnotations);
    }

    public int hashCode() {
        return Objects.hash(this.myModifiers, this.myAnnotations);
    }
}

