/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.types.CodeReferenceKind;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.resolve.ElementResolveResult;

public class GrLightClassReferenceElement
extends LightElement
implements GrCodeReferenceElement {
    @NotNull
    private final String myClassName;
    private final String myText;
    private final PsiElement myContext;

    public GrLightClassReferenceElement(@NotNull String className, @NotNull String text, PsiElement context) {
        super(context.getManager(), (Language)GroovyLanguage.INSTANCE);
        this.myClassName = className;
        this.myText = text;
        this.myContext = context;
    }

    public GrLightClassReferenceElement(PsiClass aClass, PsiElement context) {
        this(aClass.getQualifiedName() != null ? aClass.getQualifiedName() : aClass.getName(), aClass.getName(), context);
    }

    @Override
    public String getReferenceName() {
        return this.myClassName;
    }

    @Override
    @Nullable
    public String getQualifiedReferenceName() {
        return this.myClassName;
    }

    @Override
    @NotNull
    public Collection<? extends GroovyResolveResult> resolve(boolean incomplete) {
        PsiClass clazz = JavaPsiFacade.getInstance((Project)this.getProject()).findClass(this.myClassName, this.myContext.getResolveScope());
        return clazz == null ? Collections.emptyList() : Collections.singletonList(new ElementResolveResult<PsiClass>(clazz));
    }

    @Override
    public PsiType @NotNull [] getTypeArguments() {
        return PsiType.EMPTY_ARRAY;
    }

    @Override
    public GrTypeArgumentList getTypeArgumentList() {
        return null;
    }

    @Override
    public GrCodeReferenceElement getQualifier() {
        return null;
    }

    @Override
    public void setQualifier(@Nullable GrCodeReferenceElement grCodeReferenceElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return null;
    }

    @Override
    public boolean isQualified() {
        return false;
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
    }

    @Override
    public void acceptChildren(@NotNull GroovyElementVisitor visitor2) {
    }

    public String toString() {
        return "light reference element";
    }

    @NotNull
    public PsiElement getElement() {
        return this;
    }

    @NotNull
    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    @NotNull
    public String getCanonicalText() {
        PsiElement resolved = this.resolve();
        if (resolved instanceof PsiClass) {
            return ((PsiClass)resolved).getQualifiedName();
        }
        return this.myClassName;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        return this.myManager.areElementsEquivalent(element, this.resolve());
    }

    public boolean isSoft() {
        return false;
    }

    public String getText() {
        return this.myText;
    }

    @Override
    @NotNull
    public CodeReferenceKind getKind() {
        return CodeReferenceKind.REFERENCE;
    }

    @Override
    public GrAnnotation @NotNull [] getAnnotations() {
        return GrAnnotation.EMPTY_ARRAY;
    }
}

