/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrRegex;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrStringImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class GrRegexImpl
extends GrStringImpl
implements GrRegex {
    public GrRegexImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public String toString() {
        return "Compound regular expression";
    }

    @Override
    public boolean isPlainString() {
        return false;
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitRegexExpression(this);
    }

    @Override
    public Object getValue() {
        if (this.getInjections().length > 0) {
            return null;
        }
        PsiElement child = this.getFirstChild();
        if (child == null) {
            return null;
        }
        if ((child = child.getNextSibling()) == null || child.getNode().getElementType() != GroovyTokenTypes.mREGEX_CONTENT && child.getNode().getElementType() != GroovyTokenTypes.mDOLLAR_SLASH_REGEX_CONTENT) {
            return null;
        }
        StringBuilder chars2 = new StringBuilder();
        boolean isDollarSlash = child.getNode().getElementType() == GroovyTokenTypes.mREGEX_CONTENT;
        GrStringUtil.parseRegexCharacters(child.getText(), chars2, null, isDollarSlash);
        return chars2.toString();
    }

    @Override
    public String[] getTextParts() {
        List parts = this.findChildrenByType(GroovyTokenTypes.mREGEX_CONTENT);
        String[] result2 = new String[parts.size()];
        int i = 0;
        for (PsiElement part : parts) {
            result2[i++] = part.getText();
        }
        return result2;
    }
}

