/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyTokenSets;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyReference;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrReferenceElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyTargetElementEvaluator;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrLValueExpressionReference;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrRValueExpressionReference;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrReferenceTypeEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.util.CompileStaticUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyLValueUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.DependentResolver;
import org.jetbrains.plugins.groovy.lang.resolve.GroovyResolver;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyProperty;
import org.jetbrains.plugins.groovy.lang.resolve.impl.IncompleteKt;
import org.jetbrains.plugins.groovy.lang.resolve.references.GrStaticExpressionReference;
import org.jetbrains.plugins.groovy.lang.typing.DefaultMethodCallTypeCalculatorKt;
import org.jetbrains.plugins.groovy.lang.typing.GrTypeCalculator;
import org.jetbrains.plugins.groovy.transformations.inline.GroovyInlineTransformationUtilKt;

public class GrReferenceExpressionImpl
extends GrReferenceElementImpl<GrExpression>
implements GrReferenceExpression {
    private static final Logger LOG = Logger.getInstance(GrReferenceExpressionImpl.class);
    private final GroovyReference myStaticReference = new GrStaticExpressionReference(this);
    private final GroovyReference myRValueReference = new GrRValueExpressionReference(this);
    private final GroovyReference myLValueReference = new GrLValueExpressionReference(this);
    private static final GroovyResolver<GrReferenceExpressionImpl> RESOLVER = new DependentResolver<GrReferenceExpressionImpl>(){

        @Override
        @Nullable
        public Collection<PsiPolyVariantReference> collectDependencies(@NotNull GrReferenceExpressionImpl expression) {
            GrExpression qualifier = expression.getQualifier();
            if (qualifier == null) {
                return null;
            }
            SmartList result2 = new SmartList();
            qualifier.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor((List)result2){
                final /* synthetic */ List val$result;
                {
                    this.val$result = list;
                }

                public void visitElement(@NotNull PsiElement element) {
                    GrExpression operand;
                    if (element instanceof GrReferenceExpression) {
                        super.visitElement(element);
                    } else if (element instanceof GrMethodCall) {
                        super.visitElement((PsiElement)((GrMethodCall)element).getInvokedExpression());
                    } else if (element instanceof GrParenthesizedExpression && (operand = ((GrParenthesizedExpression)element).getOperand()) != null) {
                        super.visitElement((PsiElement)operand);
                    }
                }

                protected void elementFinished(PsiElement element) {
                    if (element instanceof GrReferenceExpression) {
                        this.val$result.add((GrReferenceExpression)element);
                    }
                }
            });
            return result2;
        }

        @Override
        @NotNull
        public GroovyResolveResult[] doResolve(@NotNull GrReferenceExpressionImpl ref, boolean incomplete) {
            if (incomplete) {
                return IncompleteKt.resolveIncomplete(ref).toArray(GroovyResolveResult.EMPTY_ARRAY);
            }
            GroovyReference rValueRef = ref.getRValueReference();
            GroovyReference lValueRef = ref.getLValueReference();
            if (rValueRef != null && lValueRef != null) {
                HashMap<PsiElement, GroovyResolveResult> results = new HashMap<PsiElement, GroovyResolveResult>();
                for (GroovyResolveResult groovyResolveResult : rValueRef.resolve(false)) {
                    results.putIfAbsent(groovyResolveResult.getElement(), groovyResolveResult);
                }
                for (GroovyResolveResult groovyResolveResult : lValueRef.resolve(false)) {
                    results.putIfAbsent(groovyResolveResult.getElement(), groovyResolveResult);
                }
                return results.values().toArray(GroovyResolveResult.EMPTY_ARRAY);
            }
            if (rValueRef != null) {
                return rValueRef.resolve(false).toArray(GroovyResolveResult.EMPTY_ARRAY);
            }
            if (lValueRef != null) {
                return lValueRef.resolve(false).toArray(GroovyResolveResult.EMPTY_ARRAY);
            }
            LOG.error("Reference expression has no references");
            return GroovyResolveResult.EMPTY_ARRAY;
        }
    };

    public GrReferenceExpressionImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitReferenceExpression(this);
    }

    @Override
    @Nullable
    public PsiElement getReferenceNameElement() {
        return this.findChildByType(TokenSets.REFERENCE_NAMES);
    }

    @Override
    @Nullable
    public GrExpression getQualifier() {
        return this.getQualifierExpression();
    }

    @Override
    @Nullable
    public String getReferenceName() {
        PsiElement nameElement = this.getReferenceNameElement();
        if (nameElement != null) {
            Object value;
            IElementType nodeType = nameElement.getNode().getElementType();
            if (TokenSets.STRING_LITERAL_SET.contains(nodeType) && (value = GrLiteralImpl.getLiteralValue(nameElement)) instanceof String) {
                return (String)value;
            }
            return nameElement.getText();
        }
        return null;
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        String name;
        if (!PsiUtil.isValidReferenceName(newElementName)) {
            PsiElement old = this.getReferenceNameElement();
            if (old == null) {
                throw new IncorrectOperationException("ref has no name element");
            }
            PsiElement element = GroovyPsiElementFactory.getInstance(this.getProject()).createStringLiteralForReference(newElementName);
            old.replace(element);
            return this;
        }
        if (PsiUtil.isThisOrSuperRef(this)) {
            return this;
        }
        GroovyResolveResult result2 = this.advancedResolve();
        if (result2.isInvokedOnProperty() && (name = GroovyPropertyUtils.getPropertyNameByAccessorName(newElementName)) != null) {
            newElementName = name;
        }
        return super.handleElementRename(newElementName);
    }

    @Override
    @NotNull
    protected GrReferenceElement<GrExpression> createQualifiedRef(@NotNull String qName) {
        return GroovyPsiElementFactory.getInstance(this.getProject()).createReferenceExpressionFromText(qName);
    }

    @Override
    public boolean isFullyQualified() {
        if (!this.hasMemberPointer() && !ResolveUtil.canResolveToMethod(this) && this.resolve() instanceof PsiPackage) {
            return true;
        }
        GrExpression qualifier = this.getQualifier();
        if (!(qualifier instanceof GrReferenceExpressionImpl)) {
            return false;
        }
        return ((GrReferenceExpressionImpl)qualifier).isFullyQualified();
    }

    public String toString() {
        return "Reference expression";
    }

    @Override
    @Nullable
    public PsiType getNominalType() {
        return this.getNominalType(false);
    }

    @Nullable
    private PsiType getNominalType(boolean rValue) {
        GroovyResolveResult resolveResult2 = PsiImplUtil.extractUniqueResult(this.lrResolve(rValue));
        PsiElement resolved = resolveResult2.getElement();
        for (GrReferenceTypeEnhancer enhancer : (GrReferenceTypeEnhancer[])GrReferenceTypeEnhancer.EP_NAME.getExtensions()) {
            PsiType type2 = enhancer.getReferenceType(this, resolved);
            if (type2 == null) continue;
            return type2;
        }
        PsiType result2 = this.getNominalTypeInner(resolveResult2);
        if (result2 == null) {
            return null;
        }
        result2 = TypesUtil.substituteAndNormalizeType(result2, resolveResult2.getSubstitutor(), resolveResult2.getSpreadState(), this);
        return result2;
    }

    @Nullable
    private PsiType getNominalTypeInner(GroovyResolveResult result2) {
        PsiElement resolved = result2.getElement();
        if (resolved instanceof GroovyProperty) {
            return ((GroovyProperty)resolved).getPropertyType();
        }
        if (resolved == null && !"class".equals(this.getReferenceName())) {
            resolved = this.resolve();
        }
        if (resolved instanceof PsiClass) {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
            if (PsiUtil.isInstanceThisRef(this)) {
                PsiClassType categoryType = GdkMethodUtil.getCategoryType((PsiClass)resolved);
                if (categoryType != null) {
                    return categoryType;
                }
                return factory.createType((PsiClass)resolved);
            }
            if (PsiUtil.isSuperReference(this)) {
                PsiClass contextClass = PsiUtil.getContextClass(this);
                if (GrTraitUtil.isTrait(contextClass)) {
                    Object[] extendsTypes = contextClass.getExtendsListTypes();
                    Object[] implementsTypes = contextClass.getImplementsListTypes();
                    Object[] superTypes = (PsiClassType[])ArrayUtil.mergeArrays((Object[])implementsTypes, (Object[])extendsTypes, (ArrayFactory)PsiClassType.ARRAY_FACTORY);
                    if (superTypes.length > 0) {
                        return PsiIntersectionType.createIntersection((PsiType[])((PsiType[])ArrayUtil.reverseArray((Object[])superTypes)));
                    }
                }
                return factory.createType((PsiClass)resolved);
            }
            return TypesUtil.createJavaLangClassType((PsiType)factory.createType((PsiClass)resolved), this);
        }
        if (resolved instanceof GrVariable) {
            return ((GrVariable)resolved).getDeclaredType();
        }
        if (resolved instanceof PsiVariable) {
            return ((PsiVariable)resolved).getType();
        }
        if (resolved instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)resolved;
            if (PropertyUtilBase.isSimplePropertySetter((PsiMethod)method) && !method.getName().equals(this.getReferenceName())) {
                return method.getParameterList().getParameters()[0].getType();
            }
            if (result2 instanceof GroovyMethodResult) {
                return DefaultMethodCallTypeCalculatorKt.getTypeFromCandidate((GroovyMethodResult)result2, this);
            }
            return PsiUtil.getSmartReturnType(method);
        }
        if (resolved == null) {
            PsiType fromClassRef;
            if ("class".equals(this.getReferenceName()) && (fromClassRef = this.getTypeFromClassRef()) != null) {
                return fromClassRef;
            }
            PsiType fromSpreadOperator = GrReferenceExpressionImpl.getTypeFromSpreadOperator(this);
            if (fromSpreadOperator != null) {
                return fromSpreadOperator;
            }
        }
        return null;
    }

    @Nullable
    private static PsiType getTypeFromSpreadOperator(@NotNull GrReferenceExpressionImpl ref) {
        if (ref.getDotTokenType() == GroovyTokenTypes.mSPREAD_DOT) {
            return TypesUtil.createType("java.util.List", ref);
        }
        return null;
    }

    @Nullable
    private PsiType getTypeFromClassRef() {
        PsiType qualifierType = PsiImplUtil.getQualifierType(this);
        if (qualifierType == null && !CompileStaticUtil.isCompileStatic(this)) {
            return null;
        }
        return TypesUtil.createJavaLangClassType(qualifierType, this);
    }

    @Nullable
    private static PsiType calculateType(@NotNull GrReferenceExpressionImpl refExpr) {
        PsiType macroType = GroovyInlineTransformationUtilKt.getTypeFromInlineTransformation(refExpr);
        if (macroType != null) {
            return macroType;
        }
        Collection<? extends GroovyResolveResult> results = refExpr.lrResolve(true);
        GroovyResolveResult result2 = PsiImplUtil.extractUniqueResult(results);
        PsiElement resolved = result2.getElement();
        PsiType typeFromCalculators = GrTypeCalculator.getTypeFromCalculators(refExpr);
        if (typeFromCalculators != null) {
            return typeFromCalculators;
        }
        if (ResolveUtil.isClassReference(refExpr)) {
            GrExpression qualifier = refExpr.getQualifier();
            LOG.assertTrue(qualifier != null);
            return qualifier.getType();
        }
        PsiType nominal = refExpr.getNominalType(true);
        PsiType inferred = GrReferenceExpressionImpl.getInferredTypes(refExpr, resolved);
        if (inferred == null) {
            return nominal == null ? GrReferenceExpressionImpl.getDefaultType(refExpr, result2) : nominal;
        }
        if (nominal == null) {
            if (inferred.equals(PsiType.NULL) && CompileStaticUtil.isCompileStatic(refExpr)) {
                return TypesUtil.getJavaLangObject(refExpr);
            }
            return inferred;
        }
        if (!TypeConversionUtil.isAssignable((PsiType)TypeConversionUtil.erasure((PsiType)nominal), (PsiType)inferred, (boolean)false) && (resolved instanceof GrVariable ? ((GrVariable)resolved).getTypeElementGroovy() != null : resolved instanceof PsiVariable)) {
            return nominal;
        }
        return inferred;
    }

    @Nullable
    private static PsiType getInferredTypes(@NotNull GrReferenceExpressionImpl refExpr, @Nullable PsiElement resolved) {
        GrExpression qualifier = refExpr.getQualifier();
        if (qualifier != null || resolved instanceof PsiClass || resolved instanceof PsiPackage || resolved instanceof PsiEnumConstant) {
            return null;
        }
        return TypeInferenceHelper.getCurrentContext().getVariableType(refExpr);
    }

    @Nullable
    private static PsiType getDefaultType(@NotNull GrReferenceExpression refExpr, @NotNull GroovyResolveResult result2) {
        PsiElement resolved = result2.getElement();
        if (resolved instanceof GrField) {
            PsiUtilCore.ensureValid((PsiElement)resolved);
            if (CompileStaticUtil.isCompileStatic(refExpr)) {
                return TypesUtil.getJavaLangObject(refExpr);
            }
            return SpreadState.apply(((GrVariable)resolved).getTypeGroovy(), result2.getSpreadState(), refExpr.getProject());
        }
        if (resolved instanceof GrVariable) {
            PsiUtilCore.ensureValid((PsiElement)resolved);
            PsiType typeGroovy = SpreadState.apply(((GrVariable)resolved).getTypeGroovy(), result2.getSpreadState(), refExpr.getProject());
            if (typeGroovy == null && CompileStaticUtil.isCompileStatic(refExpr)) {
                return TypesUtil.getJavaLangObject(refExpr);
            }
            return typeGroovy;
        }
        return null;
    }

    @Override
    @Nullable
    public PsiType getType() {
        return TypeInferenceHelper.getCurrentContext().getExpressionType(this, e -> GrReferenceExpressionImpl.calculateType(e));
    }

    @Override
    public GrExpression replaceWithExpression(@NotNull GrExpression newExpr, boolean removeUnnecessaryParentheses) {
        return PsiImplUtil.replaceExpression(this, newExpr, removeUnnecessaryParentheses);
    }

    @NotNull
    public String getCanonicalText() {
        return this.getRangeInElement().substring(this.getElement().getText());
    }

    @Override
    public boolean hasAt() {
        return false;
    }

    @Override
    public boolean hasMemberPointer() {
        return false;
    }

    @Override
    @NotNull
    public GroovyReference getStaticReference() {
        return this.myStaticReference;
    }

    @Nullable
    private GroovyReference getCallReference() {
        PsiElement parent2 = this.getParent();
        return parent2 instanceof GrMethodCall ? ((GrMethodCall)parent2).getExplicitCallReference() : null;
    }

    @Override
    @Nullable
    public GroovyReference getRValueReference() {
        return GroovyLValueUtil.isRValue(this) ? this.myRValueReference : null;
    }

    @Override
    @Nullable
    public GroovyReference getLValueReference() {
        return GroovyLValueUtil.isLValue(this) ? this.myLValueReference : null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        GroovyResolveResult[] results;
        for (GroovyResolveResult result2 : results = this.multiResolve(false)) {
            PsiMethod[] superMethods;
            PsiElement baseTarget = result2.getElement();
            if (baseTarget == null) continue;
            if (this.getManager().areElementsEquivalent(element, baseTarget)) {
                return true;
            }
            PsiElement target = GroovyTargetElementEvaluator.correctSearchTargets(baseTarget);
            if (target != baseTarget && this.getManager().areElementsEquivalent(element, target)) {
                return true;
            }
            if (!(element instanceof PsiMethod) || !(target instanceof PsiMethod) || !Arrays.asList(superMethods = ((PsiMethod)target).findSuperMethods(false)).contains(element)) continue;
            return true;
        }
        return false;
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    @Nullable
    public GrExpression getQualifierExpression() {
        return GrReferenceExpressionImpl.findExpressionChild(this);
    }

    @Override
    @Nullable
    public PsiElement getDotToken() {
        return this.findChildByType(GroovyTokenSets.REFERENCE_DOTS);
    }

    @Override
    public void replaceDotToken(PsiElement newDot) {
        if (newDot == null) {
            return;
        }
        if (!TokenSets.DOTS.contains(newDot.getNode().getElementType())) {
            return;
        }
        PsiElement oldDot = this.getDotToken();
        if (oldDot == null) {
            return;
        }
        this.getNode().replaceChild(oldDot.getNode(), newDot.getNode());
    }

    @Override
    @Nullable
    public IElementType getDotTokenType() {
        PsiElement dot = this.getDotToken();
        return dot == null ? null : dot.getNode().getElementType();
    }

    public PsiReference getReference() {
        return this;
    }

    @Override
    @NotNull
    public Collection<? extends GroovyResolveResult> resolve(boolean incomplete) {
        PsiElement parent2 = this.getParent();
        if (parent2 instanceof GrConstructorInvocation) {
            return ((GrConstructorInvocation)parent2).getConstructorReference().resolve(incomplete);
        }
        Collection<? extends GroovyResolveResult> staticResults = this.getStaticReference().resolve(false);
        if (!staticResults.isEmpty()) {
            return staticResults;
        }
        GroovyReference callReference = this.getCallReference();
        if (callReference != null) {
            return callReference.resolve(incomplete);
        }
        return TypeInferenceHelper.getCurrentContext().resolve(this, incomplete, RESOLVER);
    }

    @NotNull
    protected Collection<? extends GroovyResolveResult> lrResolve(boolean rValue) {
        Collection<? extends GroovyResolveResult> staticResults = this.getStaticReference().resolve(false);
        if (!staticResults.isEmpty()) {
            return staticResults;
        }
        GroovyReference callReference = this.getCallReference();
        if (callReference != null) {
            return callReference.resolve(false);
        }
        GroovyReference ref = rValue ? this.getRValueReference() : this.getLValueReference();
        return ref == null ? Collections.emptyList() : ref.resolve(false);
    }

    @Override
    public GrReferenceExpression bindToElementViaStaticImport(@NotNull PsiMember member) {
        if (this.getQualifier() != null) {
            throw new IncorrectOperationException("Reference has qualifier");
        }
        if (StringUtil.isEmpty((String)this.getReferenceName())) {
            throw new IncorrectOperationException("Reference has empty name");
        }
        PsiClass containingClass = member.getContainingClass();
        if (containingClass == null) {
            throw new IncorrectOperationException("Member has no containing class");
        }
        PsiFile file = this.getContainingFile();
        if (file instanceof GroovyFile) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
            String text = "import static " + containingClass.getQualifiedName() + "." + member.getName();
            GrImportStatement statement = factory.createImportStatementFromText(text);
            ((GroovyFile)file).addImport(statement);
        }
        return this;
    }

    @Override
    public boolean isImplicitCallReceiver() {
        return this.hasAt() || this.hasMemberPointer() || this.myStaticReference.resolve() instanceof GrVariable;
    }
}

