/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.arguments;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.GroovyNamedArgumentProvider;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentUtilKt;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.EmptyGroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ElementResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyConstructorReference;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyPropertyWriteReference;
import org.jetbrains.plugins.groovy.lang.resolve.references.GrMapConstructorPropertyReference;

public class GrArgumentLabelImpl
extends GroovyPsiElementImpl
implements GrArgumentLabel {
    private final GrMapConstructorPropertyReference myConstructorPropertyReference = new GrMapConstructorPropertyReference(this);

    public GrArgumentLabelImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitArgumentLabel(this);
    }

    public String toString() {
        return "Argument label";
    }

    @Nullable
    private PsiPolyVariantReference getReferenceFromNamedArgumentProviders() {
        PsiPolyVariantReference res;
        NamedArgumentDescriptor descr;
        PsiElement namedArgument = this.getParent();
        if (!(namedArgument instanceof GrNamedArgument)) {
            return null;
        }
        PsiElement nameElement = this.getNameElement();
        if (!(nameElement instanceof LeafPsiElement)) {
            return null;
        }
        IElementType elementType = ((LeafPsiElement)nameElement).getElementType();
        if (elementType != GroovyTokenTypes.mIDENT && !"java.lang.String".equals(TypesUtil.getBoxedTypeName(elementType))) {
            return null;
        }
        GrCall call = PsiUtil.getCallByNamedParameter((GrNamedArgument)namedArgument);
        if (call == null) {
            return NamedArgumentUtilKt.getReferenceFromDescriptor(this);
        }
        String labelName = this.getName();
        Map<String, NamedArgumentDescriptor> providers = GroovyNamedArgumentProvider.getNamedArgumentsFromAllProviders(call, labelName, false);
        if (providers != null && (descr = providers.get(labelName)) != null && (res = descr.createReference(this)) != null) {
            return res;
        }
        return null;
    }

    @NotNull
    private PsiPolyVariantReference getRealReference() {
        PsiReference[] otherReferences = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this, (PsiReferenceService.Hints)PsiReferenceService.Hints.NO_HINTS);
        PsiPolyVariantReference reference = this.getReferenceFromNamedArgumentProviders();
        if (otherReferences.length == 0) {
            if (reference != null) {
                return reference;
            }
            return new PsiPolyVariantReferenceBase<PsiElement>((PsiElement)this){

                public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
                    return ResolveResult.EMPTY_ARRAY;
                }
            };
        }
        if (reference != null) {
            PsiReference[] refs = new PsiReference[otherReferences.length + 1];
            refs[0] = reference;
            for (int i = 0; i < otherReferences.length; ++i) {
                refs[i + 1] = otherReferences[i];
            }
            otherReferences = refs;
        }
        return new PsiMultiReference(otherReferences, (PsiElement)this);
    }

    public PsiReference getReference() {
        GroovyPropertyWriteReference constructorPropertyReference = this.getConstructorPropertyReference();
        if (constructorPropertyReference != null) {
            return constructorPropertyReference;
        }
        PsiElement name = this.getNameElement();
        return name instanceof GrLiteral || name instanceof LeafPsiElement ? this : null;
    }

    @Override
    @Nullable
    public String getName() {
        Object value;
        PsiElement expression = PsiUtil.skipParentheses(this.getNameElement(), false);
        if (expression instanceof GrLiteral && (value = ((GrLiteral)expression).getValue()) instanceof String) {
            return (String)value;
        }
        PsiElement element = this.getNameElement();
        IElementType elemType = element.getNode().getElementType();
        if (GroovyTokenTypes.mIDENT == elemType || TokenSets.KEYWORDS.contains(elemType)) {
            return element.getText();
        }
        return GrArgumentLabelImpl.convertToString(GrLiteralImpl.getLiteralValue(element));
    }

    private static String convertToString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Number) {
            return value.toString();
        }
        return null;
    }

    @NotNull
    public PsiElement getElement() {
        return this;
    }

    @NotNull
    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    @Override
    public GroovyResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        ResolveResult[] results = this.getRealReference().multiResolve(incompleteCode);
        if (results instanceof GroovyResolveResult[]) {
            return (GroovyResolveResult[])results;
        }
        GroovyResolveResult[] results1 = new GroovyResolveResult[results.length];
        for (int i = 0; i < results.length; ++i) {
            ResolveResult result2 = results[i];
            PsiElement element = result2.getElement();
            results1[i] = element == null ? EmptyGroovyResolveResult.INSTANCE : new ElementResolveResult<PsiElement>(element);
        }
        return results1;
    }

    @NotNull
    public String getCanonicalText() {
        String qName;
        PsiClass clazz;
        PsiElement resolved = this.resolve();
        if (resolved instanceof PsiMember && resolved instanceof PsiNamedElement && (clazz = ((PsiMember)resolved).getContainingClass()) != null && (qName = clazz.getQualifiedName()) != null) {
            return qName + "." + ((PsiNamedElement)resolved).getName();
        }
        return this.getText();
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        return this.getRealReference().handleElementRename(newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        return this.getRealReference().bindToElement(element);
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        return this.getRealReference().isReferenceTo(element);
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    @NotNull
    public PsiElement getNameElement() {
        PsiElement element = this.getFirstChild();
        assert (element != null);
        return element;
    }

    @Override
    public GrExpression getExpression() {
        PsiElement nameElement = this.getNameElement();
        if (nameElement instanceof GrParenthesizedExpression) {
            return ((GrParenthesizedExpression)nameElement).getOperand();
        }
        if (nameElement instanceof GrExpression) {
            return (GrExpression)nameElement;
        }
        return null;
    }

    @Override
    @Nullable
    public PsiType getExpectedArgumentType() {
        return null;
    }

    @Override
    public GrNamedArgument getNamedArgument() {
        PsiElement parent2 = this.getParent();
        assert (parent2 instanceof GrNamedArgument);
        return (GrNamedArgument)parent2;
    }

    @Override
    public PsiElement setName(@NotNull String newName) {
        PsiImplUtil.setName(newName, this.getNameElement());
        return this;
    }

    @Override
    @Nullable
    public GroovyPropertyWriteReference getConstructorPropertyReference() {
        return this.hasConstructorPropertyReference() ? this.myConstructorPropertyReference : null;
    }

    private boolean hasConstructorPropertyReference() {
        if (this.getName() == null) {
            return false;
        }
        PsiElement parent2 = this.getParent();
        if (!(parent2 instanceof GrNamedArgument)) {
            return false;
        }
        return GrArgumentLabelImpl.hasConstructorPropertyReference((GrNamedArgument)parent2);
    }

    private static boolean hasConstructorPropertyReference(@NotNull GrNamedArgument argument) {
        GroovyConstructorReference constructorReference = GrMapConstructorPropertyReference.getConstructorReference(argument);
        if (constructorReference == null) {
            return false;
        }
        GroovyResolveResult result2 = constructorReference.advancedResolve();
        return PsiUtil.isTrustedMapConstructorResult(result2);
    }
}

