/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.signatures;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;

public class GrImmediateClosureParameterImpl
implements GrClosureParameter {
    private static final Logger LOG = Logger.getInstance(GrImmediateClosureParameterImpl.class);
    private final PsiType myType;
    private final String myName;
    private final boolean myOptional;
    private final GrExpression myDefaultInitializer;

    public GrImmediateClosureParameterImpl(@Nullable PsiType type2, @Nullable String name, boolean optional, @Nullable GrExpression defaultInitializer) {
        LOG.assertTrue(type2 == null || type2.isValid());
        LOG.assertTrue(defaultInitializer == null || defaultInitializer.isValid());
        this.myType = type2;
        this.myName = name;
        this.myOptional = optional;
        this.myDefaultInitializer = optional ? defaultInitializer : null;
    }

    public GrImmediateClosureParameterImpl(@NotNull PsiParameter parameter, @NotNull PsiSubstitutor substitutor2) {
        this(substitutor2.substitute(GrImmediateClosureParameterImpl.getParameterType(parameter)), GrImmediateClosureParameterImpl.getParameterName(parameter), GrImmediateClosureParameterImpl.isParameterOptional(parameter), GrImmediateClosureParameterImpl.getDefaultInitializer(parameter));
    }

    @Nullable
    private static PsiType getParameterType(@NotNull PsiParameter parameter) {
        return parameter instanceof GrParameter ? ((GrParameter)parameter).getDeclaredType() : parameter.getType();
    }

    @Nullable
    public static GrExpression getDefaultInitializer(PsiParameter parameter) {
        return parameter instanceof GrParameter ? ((GrParameter)parameter).getInitializerGroovy() : null;
    }

    public static boolean isParameterOptional(PsiParameter parameter) {
        return parameter instanceof GrParameter && ((GrParameter)parameter).isOptional();
    }

    @Nullable
    public static String getParameterName(@NotNull PsiParameter param) {
        if (param instanceof PsiCompiledElement) {
            return null;
        }
        return param.getName();
    }

    @Override
    @Nullable
    public PsiType getType() {
        return this.myType;
    }

    @Override
    public boolean isOptional() {
        return this.myOptional;
    }

    @Override
    @Nullable
    public GrExpression getDefaultInitializer() {
        return this.myDefaultInitializer;
    }

    @Override
    public boolean isValid() {
        return !(this.myType != null && !this.myType.isValid() || this.myDefaultInitializer != null && !this.myDefaultInitializer.isValid());
    }

    @Override
    @Nullable
    public String getName() {
        return this.myName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GrClosureParameter) {
            return Comparing.equal((Object)this.myType, (Object)((GrClosureParameter)obj).getType()) && Comparing.equal((Object)this.myOptional, (Object)((GrClosureParameter)obj).isOptional()) && Comparing.equal((Object)this.myDefaultInitializer, (Object)((GrClosureParameter)obj).getDefaultInitializer());
        }
        return super.equals(obj);
    }
}

