/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.signatures;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;

class GrClosureParameterImpl
implements GrClosureParameter {
    private final PsiParameter myParameter;
    private final PsiSubstitutor mySubstitutor;
    private final boolean myEraseType;
    private final PsiElement myContext;

    GrClosureParameterImpl(@NotNull PsiParameter parameter, @NotNull PsiElement context) {
        this(parameter, PsiSubstitutor.EMPTY, false, context);
    }

    GrClosureParameterImpl(@NotNull PsiParameter parameter, @NotNull PsiSubstitutor substitutor2, boolean eraseType, @NotNull PsiElement context) {
        this.myParameter = parameter;
        this.mySubstitutor = substitutor2;
        this.myEraseType = eraseType;
        this.myContext = context;
    }

    @Override
    @Nullable
    public PsiType getType() {
        PsiType correctType = PsiClassImplUtil.correctType((PsiType)this.myParameter.getType(), (GlobalSearchScope)this.myContext.getResolveScope());
        PsiType type2 = this.mySubstitutor.substitute(correctType);
        return this.myEraseType ? TypeConversionUtil.erasure((PsiType)type2, (PsiSubstitutor)this.mySubstitutor) : type2;
    }

    @Override
    public boolean isOptional() {
        return this.myParameter instanceof GrParameter && ((GrParameter)this.myParameter).isOptional();
    }

    @Override
    @Nullable
    public GrExpression getDefaultInitializer() {
        return this.myParameter instanceof GrParameter ? ((GrParameter)this.myParameter).getInitializerGroovy() : null;
    }

    @Override
    public boolean isValid() {
        return this.myContext.isValid() && this.myParameter.isValid();
    }

    @Override
    @NotNull
    public String getName() {
        return this.myParameter.getName();
    }
}

