/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.annotation;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyReference;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrAnnotationCollector;
import org.jetbrains.plugins.groovy.lang.resolve.ElementResolveResult;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0006H\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J&\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u001a2\u0006\u0010\u001b\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationMethodReference;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyReference;", "element", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/modifiers/annotation/GrAnnotationNameValuePair;", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/modifiers/annotation/GrAnnotationNameValuePair;)V", "bindToElement", "Lcom/intellij/psi/PsiElement;", "getCanonicalText", "", "getElement", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "handleElementRename", "newElementName", "isReferenceTo", "", "isSoft", "multiResolveFromAlias", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "alias", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/modifiers/annotation/GrAnnotation;", "name", "annotationCollector", "Lcom/intellij/psi/PsiAnnotation;", "resolve", "", "incomplete", "intellij.groovy.psi"})
public final class GrAnnotationMethodReference
implements GroovyReference {
    private final GrAnnotationNameValuePair element;

    @NotNull
    public PsiElement getElement() {
        return this.element;
    }

    @NotNull
    public TextRange getRangeInElement() {
        PsiElement psiElement = this.element.getNameIdentifierGroovy();
        Intrinsics.checkNotNull((Object)psiElement);
        PsiElement nameId = psiElement;
        return nameId.getTextRange().shiftLeft(this.element.getTextRange().getStartOffset());
    }

    @NotNull
    public String getCanonicalText() {
        return this.getRangeInElement().substring(this.element.getText());
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        return element instanceof PsiMethod && element.getManager().areElementsEquivalent(element, this.resolve());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<GroovyResolveResult> resolve(boolean incomplete) {
        GrAnnotation grAnnotation = PsiImplUtil.getAnnotation(this.element);
        if (grAnnotation == null) {
            return CollectionsKt.emptyList();
        }
        GrAnnotation annotation = grAnnotation;
        GrCodeReferenceElement ref = annotation.getClassReference();
        PsiElement psiElement = ref.resolve();
        if (!(psiElement instanceof PsiClass)) {
            psiElement = null;
        }
        PsiClass psiClass = (PsiClass)psiElement;
        if (psiClass == null) {
            return CollectionsKt.emptyList();
        }
        PsiClass resolved = psiClass;
        String string = this.element.getName();
        if (string == null) {
            string = "value";
        }
        String name = string;
        PsiAnnotation collector = GrAnnotationCollector.findAnnotationCollector(resolved);
        if (collector != null) {
            return this.multiResolveFromAlias(annotation, name, collector);
        }
        if (resolved.isAnnotationType()) {
            void $this$mapTo$iv$iv;
            PsiMethod[] $this$map$iv = resolved.findMethodsByName(name, false);
            boolean $i$f$map = false;
            PsiMethod[] psiMethodArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void p1;
                void item$iv$iv;
                void var15_15 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                ElementResolveResult<PsiElement> elementResolveResult = new ElementResolveResult<PsiElement>((PsiElement)p1);
                collection.add(elementResolveResult);
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private final List<GroovyResolveResult> multiResolveFromAlias(GrAnnotation alias, String name, PsiAnnotation annotationCollector) {
        List annotations2 = new ArrayList();
        GrAnnotationCollector.collectAnnotations(annotations2, alias, annotationCollector);
        List result2 = new ArrayList();
        for (GrAnnotation annotation : annotations2) {
            PsiClass clazz;
            PsiElement psiElement = annotation.getClassReference().resolve();
            if (!(psiElement instanceof PsiClass)) {
                psiElement = null;
            }
            if ((PsiClass)psiElement == null) {
                continue;
            }
            if (!clazz.isAnnotationType() || Intrinsics.areEqual((Object)clazz.getQualifiedName(), (Object)"groovy.transform.AnnotationCollector")) continue;
            PsiMethod[] $this$mapTo$iv = clazz.findMethodsByName(name, false);
            boolean $i$f$mapTo = false;
            int n = $this$mapTo$iv.length;
            for (int i = 0; i < n; ++i) {
                void p1;
                PsiMethod item$iv;
                PsiMethod psiMethod = item$iv = $this$mapTo$iv[i];
                Collection collection = result2;
                boolean bl = false;
                ElementResolveResult<PsiElement> elementResolveResult = new ElementResolveResult<PsiElement>((PsiElement)p1);
                collection.add(elementResolveResult);
            }
        }
        return result2;
    }

    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) {
        PsiElement nameElement = this.element.getNameIdentifierGroovy();
        ASTNode aSTNode = GroovyPsiElementFactory.getInstance(this.element.getProject()).createReferenceNameFromText(newElementName).getNode();
        Intrinsics.checkNotNull((Object)aSTNode);
        ASTNode newNameNode = aSTNode;
        if (nameElement != null) {
            ASTNode node = nameElement.getNode();
            this.element.getNode().replaceChild(node, newNameNode);
        } else {
            PsiElement psiElement = this.element.getFirstChild();
            ASTNode anchorBefore = psiElement != null ? psiElement.getNode() : null;
            this.element.getNode().addLeaf(GroovyTokenTypes.mASSIGN, (CharSequence)"=", anchorBefore);
            this.element.getNode().addChild(newNameNode, anchorBefore);
        }
        return this.element;
    }

    @NotNull
    public PsiElement bindToElement(@NotNull PsiElement element) {
        throw (Throwable)new IncorrectOperationException("NYI");
    }

    public boolean isSoft() {
        return false;
    }

    public GrAnnotationMethodReference(@NotNull GrAnnotationNameValuePair element) {
        this.element = element;
    }
}

