/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiSubstitutor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.EmptyGroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;

public class GroovyResolveResultImpl
implements GroovyResolveResult {
    @NotNull
    private final PsiElement myElement;
    private final boolean myIsAccessible;
    private final boolean myIsStaticsOK;
    private final boolean myIsApplicable;
    @NotNull
    private final PsiSubstitutor mySubstitutor;
    private final boolean myIsInvokedOnProperty;
    @Nullable
    private final PsiElement myCurrentFileResolveContext;
    @Nullable
    private final SpreadState mySpreadState;

    public GroovyResolveResultImpl(@NotNull PsiElement element, boolean isAccessible) {
        this(element, null, null, PsiSubstitutor.EMPTY, isAccessible, true, false, true);
    }

    public GroovyResolveResultImpl(@NotNull PsiElement element, @Nullable PsiElement resolveContext, @Nullable SpreadState spreadState, @NotNull PsiSubstitutor substitutor2, boolean isAccessible, boolean staticsOK) {
        this(element, resolveContext, spreadState, substitutor2, isAccessible, staticsOK, false, true);
    }

    public GroovyResolveResultImpl(@NotNull PsiElement element, @Nullable PsiElement resolveContext, @Nullable SpreadState spreadState, @NotNull PsiSubstitutor substitutor2, boolean isAccessible, boolean staticsOK, boolean isInvokedOnProperty, boolean isApplicable) {
        this.myCurrentFileResolveContext = resolveContext;
        this.myElement = element;
        this.myIsAccessible = isAccessible;
        this.mySubstitutor = substitutor2;
        this.myIsStaticsOK = staticsOK;
        this.myIsInvokedOnProperty = isInvokedOnProperty;
        this.mySpreadState = spreadState;
        this.myIsApplicable = isApplicable;
    }

    @Override
    @NotNull
    public PsiSubstitutor getContextSubstitutor() {
        return this.mySubstitutor;
    }

    @Override
    @NotNull
    public PsiSubstitutor getSubstitutor() {
        return this.mySubstitutor;
    }

    @Override
    public boolean isAccessible() {
        return this.myIsAccessible;
    }

    @Override
    public boolean isStaticsOK() {
        return this.myIsStaticsOK;
    }

    @Override
    public boolean isApplicable() {
        return this.myIsApplicable;
    }

    @NotNull
    public PsiElement getElement() {
        return this.myElement;
    }

    public boolean isValidResult() {
        return this.isAccessible() && this.isApplicable() && this.isStaticsOK();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroovyResolveResultImpl that = (GroovyResolveResultImpl)o;
        return this.myIsAccessible == that.myIsAccessible && this.myElement.getManager().areElementsEquivalent(this.myElement, that.myElement);
    }

    public int hashCode() {
        String name;
        int result2 = 0;
        if (this.myElement instanceof PsiNamedElement && (name = ((PsiNamedElement)this.myElement).getName()) != null) {
            result2 = name.hashCode();
        }
        result2 = 31 * result2 + (this.myIsAccessible ? 1 : 0);
        return result2;
    }

    @Override
    @Nullable
    public PsiElement getCurrentFileResolveContext() {
        return this.myCurrentFileResolveContext;
    }

    @Override
    public boolean isInvokedOnProperty() {
        return this.myIsInvokedOnProperty;
    }

    @Override
    @Nullable
    public SpreadState getSpreadState() {
        return this.mySpreadState;
    }

    @NonNls
    public String toString() {
        return "GroovyResolveResultImpl{myElement=" + this.myElement + ", mySubstitutor=" + this.mySubstitutor + "}";
    }

    @NotNull
    public static GroovyResolveResult from(@NotNull PsiClassType.ClassResolveResult classResolveResult) {
        if (classResolveResult.getElement() == null) {
            return EmptyGroovyResolveResult.INSTANCE;
        }
        return new GroovyResolveResultImpl((PsiElement)classResolveResult.getElement(), null, null, classResolveResult.getSubstitutor(), classResolveResult.isAccessible(), classResolveResult.isStaticsScopeCorrect(), false, classResolveResult.isValidResult());
    }
}

