/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public final class GroovyPsiManager {
    private static final Logger LOG = Logger.getInstance(GroovyPsiManager.class);
    private static final Set<String> ourPopularClasses = ContainerUtil.newHashSet((Object[])new String[]{"groovy.lang.Closure", "groovy.lang.GroovyObject", "groovy.lang.GroovyObjectSupport", "groovy.lang.Script", "java.util.List", "java.util.Collection", "java.lang.String"});
    @NotNull
    private final Project myProject;
    private final Map<String, GrTypeDefinition> myArrayClass = new HashMap<String, GrTypeDefinition>();
    private static final RecursionGuard<PsiElement> ourGuard = RecursionManager.createGuard((String)"groovyPsiManager");

    public GroovyPsiManager(@NotNull Project project) {
        this.myProject = project;
    }

    public static GroovyPsiManager getInstance(Project project) {
        return (GroovyPsiManager)project.getService(GroovyPsiManager.class);
    }

    @NotNull
    public PsiClassType createTypeByFQClassName(@NotNull String fqName, @NotNull GlobalSearchScope resolveScope) {
        PsiClass result2;
        if (ourPopularClasses.contains(fqName) && (result2 = JavaPsiFacade.getInstance((Project)this.myProject).findClass(fqName, resolveScope)) != null) {
            return JavaPsiFacade.getElementFactory((Project)this.myProject).createType(result2);
        }
        return JavaPsiFacade.getElementFactory((Project)this.myProject).createTypeByFQClassName(fqName, resolveScope);
    }

    @Nullable
    public GrTypeDefinition getArrayClass(@NotNull PsiType type2) {
        String typeText = type2.getCanonicalText();
        GrTypeDefinition definition = this.myArrayClass.get(typeText);
        if (definition == null) {
            try {
                definition = GroovyPsiElementFactory.getInstance(this.myProject).createTypeDefinition("class __ARRAY__ { public int length; public " + typeText + "[] clone(){} }");
                this.myArrayClass.put(typeText, definition);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }
        return definition;
    }

    @Nullable
    public static PsiType inferType(@NotNull PsiElement element, @NotNull Computable<? extends PsiType> computable) {
        List stack = ourGuard.currentStack();
        if (stack.size() > 7) {
            ourGuard.prohibitResultCaching((Object)((PsiElement)stack.get(0)));
            return null;
        }
        return (PsiType)ourGuard.doPreventingRecursion((Object)element, true, computable);
    }
}

