/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public abstract class GroovyPsiElementImpl
extends ASTWrapperPsiElement
implements GroovyPsiElement {
    public GroovyPsiElementImpl(@NotNull ASTNode node) {
        super(node);
    }

    public void delete() throws IncorrectOperationException {
        if (this.getParent() instanceof ASTDelegatePsiElement) {
            CheckUtil.checkWritable((PsiElement)this);
            ((ASTDelegatePsiElement)this.getParent()).deleteChildInternal(this.getNode());
        } else {
            this.getParent().deleteChildRange((PsiElement)this, (PsiElement)this);
        }
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitElement(this);
    }

    @Override
    public void acceptChildren(@NotNull GroovyElementVisitor visitor2) {
        GroovyPsiElementImpl.acceptGroovyChildren(this, visitor2);
    }

    @Nullable
    public static GrExpression findExpressionChild(PsiElement element) {
        for (PsiElement cur = element.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!(cur instanceof GrExpression)) continue;
            return (GrExpression)cur;
        }
        return null;
    }

    public static void acceptGroovyChildren(PsiElement parent2, GroovyElementVisitor visitor2) {
        for (PsiElement child = parent2.getFirstChild(); child != null; child = child.getNextSibling()) {
            ProgressManager.checkCanceled();
            if (!(child instanceof GroovyPsiElement)) continue;
            ((GroovyPsiElement)child).accept(visitor2);
        }
    }

    public void removeElements(PsiElement[] elements) throws IncorrectOperationException {
        GroovyPsiElementImpl.removeElements(this, elements);
    }

    public static void removeElements(PsiElement from, PsiElement[] elements) {
        ASTNode parentNode = from.getNode();
        for (PsiElement element : elements) {
            if (!element.isValid()) continue;
            ASTNode node = element.getNode();
            if (node == null || node.getTreeParent() != parentNode) {
                throw new IncorrectOperationException();
            }
            parentNode.removeChild(node);
        }
    }

    public void removeStatement() throws IncorrectOperationException {
        GroovyPsiElementImpl.removeStatement(this);
    }

    public static void removeStatement(GroovyPsiElement element) {
        if (element.getParent() == null || element.getParent().getNode() == null) {
            throw new IncorrectOperationException();
        }
        ASTNode parentNode = element.getParent().getNode();
        ASTNode prevNode = element.getNode().getTreePrev();
        parentNode.removeChild(element.getNode());
        if (prevNode != null && TokenSets.SEPARATORS.contains(prevNode.getElementType())) {
            parentNode.removeChild(prevNode);
        }
    }

    public <T extends GrStatement> T replaceWithStatement(@NotNull T newStmt) {
        return GroovyPsiElementImpl.replaceWithStatement(this, newStmt);
    }

    public static <T extends GrStatement> T replaceWithStatement(GroovyPsiElement element, @NotNull T newStmt) {
        PsiElement parent2 = element.getParent();
        if (parent2 == null) {
            throw new PsiInvalidElementAccessException((PsiElement)element);
        }
        return (T)((GrStatement)element.replace(newStmt));
    }
}

