/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ControlFlowBuilder;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.GroovyControlFlow;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyCodeStyleManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.resolve.AnnotationHint;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.caches.DeclarationHolder;
import org.jetbrains.plugins.groovy.lang.resolve.caches.FileCacheBuilderProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyFileImports;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MultiProcessor;

public abstract class GroovyFileBaseImpl
extends PsiFileBase
implements GroovyFileBase,
GrControlFlowOwner {
    private final CachedValue<DeclarationHolder> myAnnotationsCache;
    private final CachedValue<DeclarationHolder> myDeclarationsCache;
    private final DeclarationHolder myAllCachedDeclarations;
    private volatile SoftReference<GroovyControlFlow> myControlFlow;

    protected GroovyFileBaseImpl(FileViewProvider viewProvider, @NotNull Language language) {
        super(viewProvider, language);
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)viewProvider.getManager().getProject());
        this.myAnnotationsCache = cachedValuesManager.createCachedValue(() -> CachedValueProvider.Result.create((Object)this.buildCache(true), (Object[])new Object[]{this, PsiModificationTracker.MODIFICATION_COUNT}), false);
        this.myDeclarationsCache = cachedValuesManager.createCachedValue(() -> CachedValueProvider.Result.create((Object)this.buildCache(false), (Object[])new Object[]{this, PsiModificationTracker.MODIFICATION_COUNT}), false);
        this.myAllCachedDeclarations = (processor, state, place) -> ((DeclarationHolder)this.myAnnotationsCache.getValue()).processDeclarations(processor, state, place) && ((DeclarationHolder)this.myDeclarationsCache.getValue()).processDeclarations(processor, state, place);
    }

    public GroovyFileBaseImpl(IFileElementType root, IFileElementType root1, FileViewProvider provider2) {
        this(provider2, root.getLanguage());
        this.init((IElementType)root, (IElementType)root1);
    }

    @NotNull
    public FileType getFileType() {
        return GroovyFileType.GROOVY_FILE_TYPE;
    }

    public String toString() {
        return "Groovy script";
    }

    @Override
    public GrTypeDefinition @NotNull [] getTypeDefinitions() {
        StubElement stub = this.getGreenStub();
        if (stub != null) {
            return (GrTypeDefinition[])stub.getChildrenByType(TokenSets.TYPE_DEFINITIONS, GrTypeDefinition.ARRAY_FACTORY);
        }
        return (GrTypeDefinition[])this.calcTreeElement().getChildrenAsPsiElements(TokenSets.TYPE_DEFINITIONS, GrTypeDefinition.ARRAY_FACTORY);
    }

    @Override
    public GrMethod @NotNull [] getMethods() {
        StubElement stub = this.getGreenStub();
        if (stub != null) {
            return (GrMethod[])stub.getChildrenByType((IElementType)GroovyStubElementTypes.METHOD, GrMethod.ARRAY_FACTORY);
        }
        return (GrMethod[])this.calcTreeElement().getChildrenAsPsiElements((IElementType)GroovyStubElementTypes.METHOD, GrMethod.ARRAY_FACTORY);
    }

    @Override
    public GrTopStatement @NotNull [] getTopStatements() {
        return (GrTopStatement[])this.findChildrenByClass(GrTopStatement.class);
    }

    public boolean importClass(@NotNull PsiClass aClass) {
        return this.addImportForClass(aClass) != null;
    }

    @Override
    public void removeImport(@NotNull GrImportStatement importStatement) throws IncorrectOperationException {
        GroovyCodeStyleManager.getInstance(this.getProject()).removeImport(this, importStatement);
    }

    @Override
    public void removeElements(PsiElement[] elements) throws IncorrectOperationException {
        for (PsiElement element : elements) {
            if (!element.isValid()) continue;
            if (element.getParent() != this) {
                throw new IncorrectOperationException();
            }
            this.deleteChildRange(element, element);
        }
    }

    @Override
    public GrStatement @NotNull [] getStatements() {
        return (GrStatement[])this.findChildrenByClass(GrStatement.class);
    }

    @Override
    @NotNull
    public GrStatement addStatementBefore(@NotNull GrStatement statement, @Nullable GrStatement anchor) throws IncorrectOperationException {
        PsiElement result2 = this.addBefore(statement, anchor);
        if (anchor != null) {
            this.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", anchor.getNode());
        } else {
            this.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", result2.getNode());
        }
        return (GrStatement)result2;
    }

    @Override
    public void removeVariable(GrVariable variable) {
        PsiImplUtil.removeVariable(variable);
    }

    @Override
    public GrVariableDeclaration addVariableDeclarationBefore(GrVariableDeclaration declaration, GrStatement anchor) throws IncorrectOperationException {
        GrStatement statement = this.addStatementBefore(declaration, anchor);
        assert (statement instanceof GrVariableDeclaration);
        return (GrVariableDeclaration)statement;
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitFile(this);
    }

    @Override
    public void acceptChildren(@NotNull GroovyElementVisitor visitor2) {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof GroovyPsiElement)) continue;
            ((GroovyPsiElement)child).accept(visitor2);
        }
    }

    public PsiClass @NotNull [] getClasses() {
        return this.getTypeDefinitions();
    }

    public void clearCaches() {
        super.clearCaches();
        this.myControlFlow = null;
    }

    @Override
    public Instruction[] getControlFlow() {
        return this.getGroovyControlFlow().getFlow();
    }

    public GroovyControlFlow getGroovyControlFlow() {
        assert (this.isValid());
        GroovyControlFlow result2 = (GroovyControlFlow)SoftReference.dereference(this.myControlFlow);
        if (result2 == null) {
            result2 = ControlFlowBuilder.buildControlFlow(this);
            this.myControlFlow = new SoftReference((Object)result2);
        }
        return result2;
    }

    @Override
    public boolean isTopControlFlowOwner() {
        return false;
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        if (last instanceof GrTopStatement) {
            PsiImplUtil.deleteStatementTail(this, last);
        }
        super.deleteChildRange(first, last);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        for (PsiScopeProcessor psiScopeProcessor : MultiProcessor.allProcessors(processor)) {
            if (!ResolveUtilKt.shouldProcessMembers(psiScopeProcessor) || this.getAppropriateHolder(ResolveUtilKt.getAnnotationHint(processor)).processDeclarations(psiScopeProcessor, state, place)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private DeclarationHolder getAppropriateHolder(@Nullable AnnotationHint hint) {
        boolean mayUseCache = this.useCache();
        if (hint == null) {
            if (mayUseCache || this.myAnnotationsCache.hasUpToDateValue() && this.myDeclarationsCache.hasUpToDateValue()) {
                return this.myAllCachedDeclarations;
            }
        } else if (hint.isAnnotationResolve()) {
            if (mayUseCache || this.myAnnotationsCache.hasUpToDateValue()) {
                return (DeclarationHolder)this.myAnnotationsCache.getValue();
            }
        } else if (mayUseCache || this.myDeclarationsCache.hasUpToDateValue()) {
            return (DeclarationHolder)this.myDeclarationsCache.getValue();
        }
        return this::processDeclarationsNoCache;
    }

    private boolean useCache() {
        if (!this.isPhysical()) {
            return false;
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return false;
        }
        return this.getUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING) == Boolean.TRUE;
    }

    @NotNull
    private DeclarationHolder buildCache(boolean annotationCache) {
        FileCacheBuilderProcessor processor = new FileCacheBuilderProcessor(annotationCache);
        this.processDeclarationsNoCache(processor, ResolveState.initial(), this);
        return processor.buildCache();
    }

    private boolean processDeclarationsNoCache(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        if (!ResolveUtilKt.processClassesInFile(this, processor, state)) {
            return false;
        }
        GroovyFileImports imports2 = this.getImports();
        if (!imports2.processAllNamedImports(processor, state, place)) {
            return false;
        }
        if (!ResolveUtilKt.processClassesInPackage(this, processor, state, place)) {
            return false;
        }
        if (!imports2.processAllStarImports(processor, state, place)) {
            return false;
        }
        return imports2.processDefaultImports(processor, state, place);
    }
}

