/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public final class GrMapTypeFromNamedArgs
extends GrMapType {
    @NotNull
    private final LinkedHashMap<String, GrExpression> myStringEntries = new LinkedHashMap();
    @NotNull
    private final List<Couple<GrExpression>> myOtherEntries = new ArrayList<Couple<GrExpression>>();
    private final NotNullLazyValue<List<Couple<PsiType>>> myTypesOfOtherEntries;
    private final NotNullLazyValue<LinkedHashMap<String, PsiType>> myTypesOfStringEntries;

    public GrMapTypeFromNamedArgs(@NotNull PsiElement context, GrNamedArgument @NotNull [] namedArgs) {
        this(JavaPsiFacade.getInstance((Project)context.getProject()), context.getResolveScope(), namedArgs);
    }

    public GrMapTypeFromNamedArgs(@NotNull JavaPsiFacade facade, @NotNull GlobalSearchScope scope, GrNamedArgument @NotNull [] namedArgs) {
        super(facade, scope);
        for (GrNamedArgument namedArg : namedArgs) {
            GrArgumentLabel label = namedArg.getLabel();
            GrExpression expression = namedArg.getExpression();
            if (label == null || expression == null) continue;
            String name = label.getName();
            if (name != null) {
                this.myStringEntries.put(name, expression);
                continue;
            }
            GrExpression labelExpression = label.getExpression();
            if (labelExpression == null) continue;
            this.myOtherEntries.add((Couple<GrExpression>)Couple.of((Object)labelExpression, (Object)expression));
        }
        this.myTypesOfOtherEntries = NotNullLazyValue.volatileLazy(() -> ContainerUtil.map(this.myOtherEntries, pair -> Couple.of((Object)this.inferTypePreventingRecursion((GrExpression)pair.first), (Object)this.inferTypePreventingRecursion((GrExpression)pair.second))));
        this.myTypesOfStringEntries = NotNullLazyValue.volatileLazy(() -> {
            LinkedHashMap<String, PsiType> result2 = new LinkedHashMap<String, PsiType>();
            for (Map.Entry<String, GrExpression> entry : this.myStringEntries.entrySet()) {
                result2.put(entry.getKey(), this.inferTypePreventingRecursion(entry.getValue()));
            }
            return result2;
        });
    }

    @Override
    @Nullable
    public PsiType getTypeByStringKey(String key) {
        GrExpression expression = this.myStringEntries.get(key);
        return expression != null ? this.inferTypePreventingRecursion(expression) : null;
    }

    @Override
    @NotNull
    public Set<String> getStringKeys() {
        return this.myStringEntries.keySet();
    }

    @Override
    public boolean isEmpty() {
        return this.myStringEntries.isEmpty() && this.myOtherEntries.isEmpty();
    }

    @Nullable
    private PsiType inferTypePreventingRecursion(GrExpression expression) {
        return (PsiType)RecursionManager.doPreventingRecursion((Object)expression, (boolean)false, () -> TypesUtil.boxPrimitiveType(expression.getType(), expression.getManager(), this.myScope));
    }

    @Override
    @NotNull
    protected List<Couple<PsiType>> getOtherEntries() {
        return (List)this.myTypesOfOtherEntries.getValue();
    }

    @Override
    @NotNull
    protected LinkedHashMap<String, PsiType> getStringEntries() {
        return (LinkedHashMap)this.myTypesOfStringEntries.getValue();
    }

    public boolean isValid() {
        for (GrExpression grExpression : this.myStringEntries.values()) {
            if (grExpression.isValid()) continue;
            return false;
        }
        for (Couple couple : this.myOtherEntries) {
            if (!((GrExpression)couple.first).isValid()) {
                return false;
            }
            if (((GrExpression)couple.second).isValid()) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GrMapTypeFromNamedArgs args = (GrMapTypeFromNamedArgs)((Object)o);
        if (!this.myStringEntries.equals(args.myStringEntries)) {
            return false;
        }
        return this.myOtherEntries.equals(args.myOtherEntries);
    }

    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.myStringEntries.hashCode();
        result2 = 31 * result2 + this.myOtherEntries.hashCode();
        return result2;
    }
}

