/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.expectedTypes;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public final class SubtypeConstraint
extends TypeConstraint {
    private final PsiType myDefaultType;

    SubtypeConstraint(@NotNull PsiType type2, @NotNull PsiType defaultType) {
        super(type2);
        this.myDefaultType = defaultType;
    }

    @Override
    public boolean satisfied(PsiType type2, @NotNull PsiElement context) {
        return TypesUtil.isAssignableByMethodCallConversion(this.getType(), type2, context);
    }

    @Override
    @NotNull
    public PsiType getDefaultType() {
        return this.myDefaultType;
    }

    public static SubtypeConstraint create(@NotNull PsiType type2) {
        return new SubtypeConstraint(type2, type2);
    }

    public static SubtypeConstraint create(String fqName, PsiElement context) {
        PsiClassType type2 = TypesUtil.createType(fqName, context);
        return new SubtypeConstraint((PsiType)type2, (PsiType)type2);
    }
}

