/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.expectedTypes;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrParameterListOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrAssertStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrTraditionalForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConstructorCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrInstanceOfExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAnnotationMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesContributor;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SubtypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SupertypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCallReference;
import org.jetbrains.plugins.groovy.lang.resolve.api.JustTypeArgument;
import org.jetbrains.plugins.groovy.lang.resolve.impl.CallReferenceImplKt;

public final class GroovyExpectedTypesProvider {
    private static final ExtensionPointName<GroovyExpectedTypesContributor> EP_NAME = new ExtensionPointName("org.intellij.groovy.expectedTypesContributor");

    public static TypeConstraint[] calculateTypeConstraints(@NotNull GrExpression expression) {
        return TypeInferenceHelper.getCurrentContext().getCachedValue(expression, GroovyExpectedTypesProvider::doCalculateTypeConstraints);
    }

    private static TypeConstraint[] doCalculateTypeConstraints(@NotNull GrExpression expression) {
        MyCalculator calculator = new MyCalculator(expression);
        PsiElement parent2 = expression.getParent();
        if (parent2 instanceof GroovyPsiElement) {
            ((GroovyPsiElement)parent2).accept(calculator);
        } else {
            parent2.accept((PsiElementVisitor)new GroovyPsiElementVisitor(calculator));
        }
        TypeConstraint[] result2 = calculator.getResult();
        ArrayList<TypeConstraint> custom = new ArrayList<TypeConstraint>();
        for (GroovyExpectedTypesContributor contributor : EP_NAME.getExtensionList()) {
            custom.addAll(contributor.calculateTypeConstraints(expression));
        }
        if (!custom.isEmpty()) {
            custom.addAll(0, Arrays.asList(result2));
            return custom.toArray(TypeConstraint.EMPTY_ARRAY);
        }
        return result2;
    }

    public static List<PsiType> getDefaultExpectedTypes(@NotNull GrExpression element) {
        Object[] constraints = GroovyExpectedTypesProvider.calculateTypeConstraints(element);
        return ContainerUtil.map((Object[])constraints, constraint -> constraint.getDefaultType());
    }

    private static class MyCalculator
    extends GroovyElementVisitor {
        private TypeConstraint[] myResult;
        private final GrExpression myExpression;

        MyCalculator(GrExpression expression) {
            this.myExpression = (GrExpression)PsiUtil.skipParentheses(expression, true);
            this.myResult = TypeConstraint.EMPTY_ARRAY;
        }

        @Override
        public void visitReturnStatement(@NotNull GrReturnStatement returnStatement) {
            GrTypeElement typeElement;
            GrParameterListOwner parent2 = (GrParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)returnStatement, GrParameterListOwner.class);
            if (parent2 instanceof GrMethod && (typeElement = ((GrMethod)parent2).getReturnTypeElementGroovy()) != null) {
                PsiType type2 = typeElement.getType();
                this.myResult = new TypeConstraint[]{SubtypeConstraint.create(type2)};
            }
        }

        @Override
        public void visitVariable(@NotNull GrVariable variable) {
            if (this.myExpression.equals(variable.getInitializerGroovy())) {
                PsiType type2 = variable.getType();
                this.myResult = MyCalculator.createSimpleSubTypeResult(type2);
            }
        }

        @Override
        public void visitNamedArgument(@NotNull GrNamedArgument argument) {
            PsiElement pparent;
            GrArgumentLabel label = argument.getLabel();
            if (label != null && (pparent = argument.getParent().getParent()) instanceof GrCall && MyCalculator.resolvesToDefaultConstructor((GrCall)pparent)) {
                GroovyResolveResult resolveResult2 = label.advancedResolve();
                PsiElement resolved = resolveResult2.getElement();
                PsiType type2 = resolved instanceof PsiField ? ((PsiField)resolved).getType() : (resolved instanceof PsiMethod && GroovyPropertyUtils.isSimplePropertySetter((PsiMethod)resolved) ? ((PsiMethod)resolved).getParameterList().getParameters()[0].getType() : null);
                PsiType substituted = resolveResult2.getSubstitutor().substitute(type2);
                if (substituted != null) {
                    this.myResult = MyCalculator.createSimpleSubTypeResult(substituted);
                }
            }
        }

        private static boolean resolvesToDefaultConstructor(GrCall call) {
            PsiElement resolved;
            PsiMethod method = call.resolveMethod();
            if (method != null && method.isConstructor() && method.getParameterList().isEmpty()) {
                return true;
            }
            return call instanceof GrConstructorCall && (resolved = PsiImplUtil.extractUniqueResult(((GrConstructorCall)call).multiResolveClass()).getElement()) instanceof PsiClass;
        }

        @Override
        public void visitMethodCallExpression(@NotNull GrMethodCallExpression methodCall) {
            GrExpression invokedExpression = methodCall.getInvokedExpression();
            if (this.myExpression.equals(invokedExpression)) {
                this.myResult = new TypeConstraint[]{SubtypeConstraint.create("groovy.lang.Closure", methodCall)};
                return;
            }
            GrClosableBlock[] closureArgs = methodCall.getClosureArguments();
            if (ArrayUtil.contains((Object)this.myExpression, (Object[])closureArgs)) {
                GrArgumentList argumentList = methodCall.getArgumentList();
                GrNamedArgument[] namedArgs = argumentList.getNamedArguments();
                GrExpression[] expressionArgs = argumentList.getExpressionArguments();
                GroovyResolveResult[] callVariants = ResolveUtil.getCallVariants(this.myExpression);
                this.processCallVariants(methodCall, callVariants, namedArgs, expressionArgs, closureArgs);
            }
        }

        @Override
        public void visitOpenBlock(@NotNull GrOpenBlock block) {
            GrStatement[] statements2 = block.getStatements();
            if (statements2.length > 0 && this.myExpression.equals(statements2[statements2.length - 1])) {
                this.checkExitPoint();
            }
        }

        @Override
        public void visitCastExpression(@NotNull GrTypeCastExpression typeCastExpression) {
            this.myResult = MyCalculator.createSimpleSubTypeResult((PsiType)TypesUtil.getJavaLangObject(typeCastExpression));
        }

        @Override
        public void visitAssertStatement(@NotNull GrAssertStatement assertStatement) {
            if (this.myExpression.equals(assertStatement.getAssertion())) {
                this.myResult = MyCalculator.createSimpleSubTypeResult((PsiType)PsiType.BOOLEAN);
            }
            if (this.myExpression.equals(assertStatement.getErrorMessage())) {
                this.myResult = MyCalculator.createSimpleSubTypeResult((PsiType)TypesUtil.createType("java.lang.String", assertStatement));
            }
        }

        @Override
        public void visitIfStatement(@NotNull GrIfStatement ifStatement) {
            if (this.myExpression.equals(ifStatement.getCondition())) {
                this.myResult = new TypeConstraint[]{new SubtypeConstraint((PsiType)TypesUtil.getJavaLangObject(ifStatement), (PsiType)PsiType.BOOLEAN)};
            } else if (this.myExpression.equals(ifStatement.getThenBranch()) || this.myExpression.equals(ifStatement.getElseBranch())) {
                this.checkExitPoint();
            }
        }

        @Override
        public void visitAnnotationMethod(@NotNull GrAnnotationMethod method) {
            PsiType type2 = method.getReturnType();
            if (type2 != null && MyCalculator.isAcceptableAnnotationValueType(type2)) {
                this.myResult = MyCalculator.createSimpleSubTypeResult(type2);
            }
        }

        @Override
        public void visitAnnotationArrayInitializer(@NotNull GrAnnotationArrayInitializer arrayInitializer) {
            GrAnnotationNameValuePair nameValuePair = (GrAnnotationNameValuePair)PsiTreeUtil.getParentOfType((PsiElement)arrayInitializer, GrAnnotationNameValuePair.class, (boolean)true, (Class[])new Class[]{GrAnnotationMethod.class});
            if (nameValuePair != null) {
                PsiClass annot = ResolveUtil.resolveAnnotation(arrayInitializer);
                if (annot == null) {
                    return;
                }
                String name = nameValuePair.getName();
                if (name == null) {
                    return;
                }
                this.createResultFromAttrName(annot, name);
            } else {
                GrAnnotationMethod method = (GrAnnotationMethod)PsiTreeUtil.getParentOfType((PsiElement)arrayInitializer, GrAnnotationMethod.class);
                assert (method != null);
                PsiType type2 = method.getReturnType();
                int count = 1;
                PsiElement parent2 = arrayInitializer.getParent();
                while (parent2 instanceof GrAnnotationArrayInitializer) {
                    ++count;
                    parent2 = parent2.getParent();
                }
                while (type2 instanceof PsiArrayType && count > 0) {
                    type2 = ((PsiArrayType)type2).getComponentType();
                    --count;
                }
                if (type2 != null && MyCalculator.isAcceptableAnnotationValueType(type2)) {
                    this.myResult = MyCalculator.createSimpleSubTypeResult(type2);
                }
            }
        }

        @Override
        public void visitAnnotationNameValuePair(@NotNull GrAnnotationNameValuePair nameValuePair) {
            PsiClass annot;
            if (this.myExpression.equals(nameValuePair.getValue()) && (annot = ResolveUtil.resolveAnnotation(nameValuePair.getParent())) != null) {
                String name = nameValuePair.getName();
                if (name != null) {
                    this.createResultFromAttrName(annot, name);
                } else {
                    PsiMethod[] valueAttr = annot.findMethodsByName("value", false);
                    if (valueAttr.length > 0) {
                        boolean canHaveSimpleExpr;
                        boolean bl = canHaveSimpleExpr = ContainerUtil.find((Object[])annot.getMethods(), method -> !"value".equals(method.getName()) && (!(method instanceof PsiAnnotationMethod) || ((PsiAnnotationMethod)method).getDefaultValue() == null)) == null;
                        if (canHaveSimpleExpr) {
                            this.createResultFromAnnotationAttribute(valueAttr[0]);
                        }
                    }
                }
            }
        }

        private void createResultFromAttrName(PsiClass annotation, String attrName) {
            PsiMethod[] attrs = annotation.findMethodsByName(attrName, false);
            if (attrs.length > 0) {
                this.createResultFromAnnotationAttribute(attrs[0]);
            }
        }

        private void createResultFromAnnotationAttribute(PsiMethod attr) {
            PsiType type2 = attr.getReturnType();
            while (type2 instanceof PsiArrayType) {
                type2 = ((PsiArrayType)type2).getComponentType();
            }
            if (type2 != null && MyCalculator.isAcceptableAnnotationValueType(type2)) {
                this.myResult = MyCalculator.createSimpleSubTypeResult(type2);
            }
        }

        private static boolean isAcceptableAnnotationValueType(PsiType type2) {
            return type2 instanceof PsiPrimitiveType || type2.equalsToText("java.lang.String") || type2.equalsToText("java.lang.Class") || type2 instanceof PsiClassType && ((PsiClassType)type2).resolve() != null && ((PsiClassType)type2).resolve().isEnum();
        }

        private static TypeConstraint @NotNull [] createSimpleSubTypeResult(@NotNull PsiType type2) {
            return new TypeConstraint[]{new SubtypeConstraint(type2, type2)};
        }

        private void checkExitPoint() {
            PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)this.myExpression, (Class[])new Class[]{PsiMethod.class, GrClosableBlock.class});
            if (element instanceof GrMethod) {
                final GrMethod method = (GrMethod)element;
                ControlFlowUtils.visitAllExitPoints(method.getBlock(), new ControlFlowUtils.ExitPointVisitor(){

                    @Override
                    public boolean visitExitPoint(Instruction instruction, @Nullable GrExpression returnValue) {
                        if (returnValue == myExpression) {
                            PsiType returnType2 = method.getReturnType();
                            if (returnType2 != null) {
                                myResult = MyCalculator.createSimpleSubTypeResult(returnType2);
                            }
                            return false;
                        }
                        return true;
                    }
                });
            }
        }

        @Override
        public void visitWhileStatement(@NotNull GrWhileStatement whileStatement) {
            if (this.myExpression.equals(whileStatement.getCondition())) {
                this.myResult = new TypeConstraint[]{new SubtypeConstraint((PsiType)TypesUtil.getJavaLangObject(whileStatement), (PsiType)PsiType.BOOLEAN)};
            }
        }

        @Override
        public void visitTraditionalForClause(@NotNull GrTraditionalForClause forClause) {
            if (this.myExpression.equals(forClause.getCondition())) {
                this.myResult = new TypeConstraint[]{new SubtypeConstraint((PsiType)TypesUtil.getJavaLangObject(forClause), (PsiType)PsiType.BOOLEAN)};
            }
        }

        @Override
        public void visitArgumentList(@NotNull GrArgumentList list) {
            this.processCallVariants(list, ResolveUtil.getCallVariants(list), list.getNamedArguments(), list.getExpressionArguments(), GrClosableBlock.EMPTY_ARRAY);
        }

        private void processCallVariants(@NotNull PsiElement place, GroovyResolveResult @NotNull [] variants, GrNamedArgument @NotNull [] namedArguments, GrExpression @NotNull [] expressionArguments, GrClosableBlock @NotNull [] closureArguments) {
            List<Pair<PsiParameter, PsiType>> expectedParams = ResolveUtil.collectExpectedParamsByArg(place, variants, namedArguments, expressionArguments, closureArguments, this.myExpression);
            this.collectExpectedTypeFromPossibleParams(expectedParams);
        }

        private void collectExpectedTypeFromPossibleParams(List<Pair<PsiParameter, PsiType>> expectedParams) {
            ArrayList<SubtypeConstraint> constraints = new ArrayList<SubtypeConstraint>();
            for (Pair<PsiParameter, PsiType> pair : expectedParams) {
                PsiType type2 = (PsiType)pair.second;
                if (type2 == null) continue;
                constraints.add(SubtypeConstraint.create(type2));
                if (!(type2 instanceof PsiArrayType) || !((PsiParameter)pair.first).isVarArgs()) continue;
                constraints.add(SubtypeConstraint.create(((PsiArrayType)type2).getComponentType()));
            }
            if (!constraints.isEmpty()) {
                this.myResult = constraints.toArray(TypeConstraint.EMPTY_ARRAY);
            }
        }

        @Override
        public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
            PsiType otherType;
            IElementType type2 = expression.getOperationTokenType();
            GrExpression left = expression.getLeftOperand();
            GrExpression right = expression.getRightOperand();
            GrExpression other = this.myExpression == left ? right : left;
            PsiType psiType = otherType = other != null ? other.getType() : null;
            if (otherType == null) {
                return;
            }
            GroovyResolveResult[] callVariants = PsiUtilKt.multiResolve(expression);
            if (this.myExpression == left || callVariants.length == 0) {
                if (type2 == GroovyTokenTypes.mPLUS && otherType.equalsToText("java.lang.String")) {
                    PsiClassType obj = TypesUtil.getJavaLangObject(expression);
                    this.myResult = MyCalculator.createSimpleSubTypeResult((PsiType)obj);
                } else if (type2 == GroovyTokenTypes.mREGEX_FIND || type2 == GroovyTokenTypes.mREGEX_MATCH) {
                    PsiClassType string = TypesUtil.createType("java.lang.String", expression);
                    this.myResult = MyCalculator.createSimpleSubTypeResult((PsiType)string);
                } else {
                    this.myResult = MyCalculator.createSimpleSubTypeResult(otherType);
                }
            } else {
                this.processCallVariants(expression, callVariants, GrNamedArgument.EMPTY_ARRAY, new GrExpression[]{this.myExpression}, GrClosableBlock.EMPTY_ARRAY);
            }
        }

        @Override
        public void visitInstanceofExpression(@NotNull GrInstanceOfExpression expression) {
            GrExpression operand = expression.getOperand();
            GrTypeElement typeElement = expression.getTypeElement();
            if (typeElement == null) {
                return;
            }
            if (this.myExpression == operand) {
                PsiType type2 = typeElement.getType();
                this.myResult = new TypeConstraint[]{new SupertypeConstraint(type2, type2)};
            }
        }

        @Override
        public void visitAssignmentExpression(@NotNull GrAssignmentExpression expression) {
            PsiType rType;
            GrExpression rValue = expression.getRValue();
            GrExpression lValue = expression.getLValue();
            if (this.myExpression.equals(rValue)) {
                PsiType type2;
                GroovyResolveResult result2;
                PsiElement resolved;
                PsiType lType = lValue.getNominalType();
                if (lType != null) {
                    this.myResult = new TypeConstraint[]{SubtypeConstraint.create(lType)};
                } else if (lValue instanceof GrReferenceExpression && (resolved = (result2 = ((GrReferenceExpression)lValue).advancedResolve()).getElement()) instanceof GrVariable && (type2 = ((GrVariable)resolved).getTypeGroovy()) != null) {
                    this.myResult = new TypeConstraint[]{SubtypeConstraint.create(result2.getSubstitutor().substitute(type2))};
                }
            } else if (this.myExpression.equals(lValue) && rValue != null && (rType = rValue.getType()) != null) {
                this.myResult = new TypeConstraint[]{SupertypeConstraint.create(rType)};
            }
        }

        @Override
        public void visitThrowStatement(@NotNull GrThrowStatement throwStatement) {
            PsiClassType throwable = PsiType.getJavaLangThrowable((PsiManager)this.myExpression.getManager(), (GlobalSearchScope)throwStatement.getResolveScope());
            this.myResult = new TypeConstraint[]{SubtypeConstraint.create((PsiType)throwable)};
        }

        @Override
        public void visitUnaryExpression(final @NotNull GrUnaryExpression expression) {
            TypeConstraint constraint = new TypeConstraint((PsiType)PsiType.INT){

                @Override
                public boolean satisfied(PsiType type2, @NotNull PsiElement context) {
                    GroovyMethodCallReference reference;
                    PsiType boxed = TypesUtil.boxPrimitiveType(type2, context.getManager(), context.getResolveScope());
                    return !CallReferenceImplKt.resolveWithArguments(new JustTypeArgument(boxed), (reference = expression.getReference()).getMethodName(), reference.getArguments(), reference.getElement()).isEmpty();
                }

                @Override
                @NotNull
                public PsiType getDefaultType() {
                    return PsiType.INT;
                }
            };
            this.myResult = new TypeConstraint[]{constraint};
        }

        @Override
        public void visitParenthesizedExpression(@NotNull GrParenthesizedExpression expression) {
            PsiElement parent2 = expression.getParent();
            if (parent2 instanceof GroovyPsiElement) {
                ((GroovyPsiElement)parent2).accept(this);
            } else {
                parent2.accept((PsiElementVisitor)new GroovyPsiElementVisitor(this));
            }
        }

        @Override
        public void visitListOrMap(@NotNull GrListOrMap listOrMap) {
            if (listOrMap.isMap()) {
                return;
            }
            TypeConstraint[] constraints = GroovyExpectedTypesProvider.calculateTypeConstraints(listOrMap);
            ArrayList<PsiType> result2 = new ArrayList<PsiType>(constraints.length);
            for (TypeConstraint constraint : constraints) {
                PsiType type2;
                PsiType iterable;
                if (!(constraint instanceof SubtypeConstraint) || (iterable = com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)(type2 = constraint.getType()), (boolean)true)) == null) continue;
                result2.add(iterable);
            }
            if (result2.isEmpty()) {
                this.myResult = TypeConstraint.EMPTY_ARRAY;
            } else {
                this.myResult = new TypeConstraint[result2.size()];
                for (int i = 0; i < result2.size(); ++i) {
                    PsiType type3 = (PsiType)result2.get(i);
                    if (type3 == null) continue;
                    this.myResult[i] = SubtypeConstraint.create(type3);
                }
            }
        }

        @Override
        public void visitSwitchStatement(@NotNull GrSwitchStatement switchStatement) {
            GrCaseSection[] sections = switchStatement.getCaseSections();
            ArrayList<PsiType> types = new ArrayList<PsiType>(sections.length);
            for (GrCaseSection section : sections) {
                for (GrExpression value : section.getExpressions()) {
                    PsiType type2;
                    if (value == null || (type2 = value.getType()) == null) continue;
                    types.add(type2);
                }
            }
            PsiType upperBoundNullable = TypesUtil.getLeastUpperBoundNullable(types, switchStatement.getManager());
            if (upperBoundNullable == null) {
                return;
            }
            this.myResult = new TypeConstraint[]{SubtypeConstraint.create(upperBoundNullable)};
        }

        public TypeConstraint[] getResult() {
            return this.myResult;
        }
    }
}

