/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.types;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.FList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.BitSet;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAType;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.ClosureFrame;

class TypeDfaState {
    private static final Logger LOG = Logger.getInstance(TypeDfaState.class);
    static final TypeDfaState EMPTY_STATE = new TypeDfaState((Int2ObjectMap<DFAType>)new Int2ObjectOpenHashMap(), new BitSet(), null);
    private final Int2ObjectMap<DFAType> myVarTypes;
    @Nullable
    private final FList<ClosureFrame> myPreviousClosureState;
    private final BitSet myProhibitedCachingVars;

    private TypeDfaState(Int2ObjectMap<DFAType> varTypes, BitSet prohibitedCachingVars, @Nullable FList<ClosureFrame> frame) {
        this.myVarTypes = varTypes;
        this.myProhibitedCachingVars = prohibitedCachingVars;
        this.myPreviousClosureState = frame;
    }

    @Contract(pure=true)
    @NotNull
    public static TypeDfaState merge(@NotNull TypeDfaState left, @NotNull TypeDfaState right, PsiManager manager) {
        if (left == right) {
            return left;
        }
        Int2ObjectMap<DFAType> dominantMap = TypeDfaState.guessDominantMap(left.myVarTypes, right.myVarTypes);
        if (TypeDfaState.dominates(left, right, dominantMap)) {
            return left;
        }
        if (TypeDfaState.dominates(right, left, dominantMap)) {
            return right;
        }
        BitSet resultSet = TypeDfaState.mergeProhibitedVariables(left.myProhibitedCachingVars, right.myProhibitedCachingVars);
        Int2ObjectMap<DFAType> resultMap = dominantMap != null ? dominantMap : TypeDfaState.mergeTypeMaps(left.myVarTypes, right.myVarTypes, manager, resultSet);
        FList<ClosureFrame> frame = left.myPreviousClosureState == null ? right.myPreviousClosureState : left.myPreviousClosureState;
        return new TypeDfaState(resultMap, resultSet, frame);
    }

    @Contract(pure=true)
    @NotNull
    public TypeDfaState withNewType(int variableIndex, @NotNull DFAType type2) {
        Int2ObjectOpenHashMap newTypes;
        BitSet newSet;
        if (variableIndex == 0 || !this.myProhibitedCachingVars.get(variableIndex)) {
            newSet = this.myProhibitedCachingVars;
        } else {
            newSet = (BitSet)this.myProhibitedCachingVars.clone();
            newSet.set(variableIndex, false);
        }
        if (this.myVarTypes.get(variableIndex) == type2) {
            newTypes = this.myVarTypes;
        } else {
            newTypes = new Int2ObjectOpenHashMap(this.myVarTypes);
            newTypes.put(variableIndex, (Object)type2);
        }
        if (newSet == this.myProhibitedCachingVars && newTypes == this.myVarTypes) {
            return this;
        }
        return new TypeDfaState((Int2ObjectMap<DFAType>)newTypes, newSet, this.myPreviousClosureState);
    }

    @Contract(pure=true)
    @NotNull
    public TypeDfaState withRemovedBinding(int variableIndex) {
        if (variableIndex == 0 || this.myProhibitedCachingVars.get(variableIndex)) {
            return this;
        }
        BitSet newProhibitedVars = (BitSet)this.myProhibitedCachingVars.clone();
        newProhibitedVars.set(variableIndex, true);
        return new TypeDfaState(this.myVarTypes, newProhibitedVars, this.myPreviousClosureState);
    }

    @Contract(pure=true)
    @NotNull
    public TypeDfaState withNewClosureState(@NotNull ClosureFrame frame) {
        if (this.myPreviousClosureState != null && frame == this.myPreviousClosureState.getHead()) {
            return this;
        }
        FList<ClosureFrame> frames = this.myPreviousClosureState == null ? FList.emptyList() : this.myPreviousClosureState;
        return new TypeDfaState(this.myVarTypes, this.myProhibitedCachingVars, (FList<ClosureFrame>)frames.prepend((Object)frame));
    }

    @Contract(pure=true)
    @NotNull
    public TypeDfaState withoutTopClosureState() {
        if (ApplicationManager.getApplication().isInternal() && (this.myPreviousClosureState == null || this.myPreviousClosureState.isEmpty())) {
            LOG.error("Reached closure end without closure start");
        }
        if (this.myPreviousClosureState == null || this.myPreviousClosureState.isEmpty()) {
            return this;
        }
        FList tail = this.myPreviousClosureState.getTail();
        return new TypeDfaState(this.myVarTypes, this.myProhibitedCachingVars, (FList<ClosureFrame>)(tail.isEmpty() ? null : tail));
    }

    @Contract(pure=true)
    @NotNull
    public TypeDfaState withNewMap(@NotNull Int2ObjectMap<DFAType> types) {
        if (Objects.equals(types, this.myVarTypes)) {
            return this;
        }
        return new TypeDfaState(types, this.myProhibitedCachingVars, this.myPreviousClosureState);
    }

    @Contract(pure=true)
    @NotNull
    public TypeDfaState withRemovedBindings(BitSet newBindings) {
        if (this.myProhibitedCachingVars.equals(newBindings)) {
            return this;
        }
        return new TypeDfaState(this.myVarTypes, newBindings, this.myPreviousClosureState);
    }

    boolean contentsEqual(TypeDfaState another) {
        return this.myVarTypes.equals(another.myVarTypes) && this.myProhibitedCachingVars.equals(another.myProhibitedCachingVars) && another.myPreviousClosureState == this.myPreviousClosureState;
    }

    @Nullable
    DFAType getVariableType(int descriptor) {
        return descriptor != 0 && !this.myProhibitedCachingVars.get(descriptor) ? (DFAType)this.myVarTypes.get(descriptor) : null;
    }

    public BitSet getRemovedBindings() {
        return this.myProhibitedCachingVars;
    }

    Int2ObjectMap<DFAType> getRawVarTypes() {
        return this.myVarTypes;
    }

    @Contract(pure=true)
    @NotNull
    DFAType getNotNullDFAType(int descriptor) {
        DFAType result2 = this.getVariableType(descriptor);
        return result2 == null ? DFAType.NULL_DFA_TYPE : result2;
    }

    @Nullable
    ClosureFrame getTopClosureFrame() {
        if (ApplicationManager.getApplication().isInternal()) {
            LOG.assertTrue(this.myPreviousClosureState != null && !this.myPreviousClosureState.isEmpty(), (Object)"Reached closure end without closure start");
        }
        if (this.myPreviousClosureState == null || this.myPreviousClosureState.isEmpty()) {
            return null;
        }
        return (ClosureFrame)this.myPreviousClosureState.getHead();
    }

    @NonNls
    public String toString() {
        String evicted = this.myProhibitedCachingVars.isEmpty() ? "" : ", (caching prohibited: " + this.myProhibitedCachingVars + ")";
        String frame = this.myPreviousClosureState == null || this.myPreviousClosureState.isEmpty() ? "" : ", frame size: " + this.myPreviousClosureState.size();
        return this.myVarTypes.toString() + evicted + frame;
    }

    public boolean containsVariable(int varIndex) {
        return this.myVarTypes.containsKey(varIndex);
    }

    boolean isProhibited(int index) {
        return index == 0 || this.myProhibitedCachingVars.get(index);
    }

    private static BitSet mergeProhibitedVariables(BitSet leftSet, BitSet rightSet) {
        if (leftSet.equals(rightSet)) {
            return leftSet;
        }
        BitSet prohibited = (BitSet)leftSet.clone();
        prohibited.or(rightSet);
        return prohibited;
    }

    @NotNull
    private static Int2ObjectMap<DFAType> mergeTypeMaps(Int2ObjectMap<DFAType> leftMap, Int2ObjectMap<DFAType> rightMap, PsiManager manager, BitSet prohibited) {
        Int2ObjectOpenHashMap newFMap = new Int2ObjectOpenHashMap();
        Stream.concat(rightMap.int2ObjectEntrySet().stream(), leftMap.int2ObjectEntrySet().stream()).forEach(arg_0 -> TypeDfaState.lambda$mergeTypeMaps$0(prohibited, (Int2ObjectMap)newFMap, manager, arg_0));
        return newFMap;
    }

    @Nullable
    private static Int2ObjectMap<DFAType> guessDominantMap(Int2ObjectMap<DFAType> left, Int2ObjectMap<DFAType> right) {
        if (left.size() == right.size() && TypeDfaState.dominatesAll(left, right)) {
            return left;
        }
        if (left.size() > right.size() && TypeDfaState.dominatesAll(left, right)) {
            return left;
        }
        if (left.size() < right.size() && TypeDfaState.dominatesAll(right, left)) {
            return right;
        }
        return null;
    }

    private static boolean dominatesAll(Int2ObjectMap<DFAType> dominator, Int2ObjectMap<DFAType> dominated) {
        for (Int2ObjectMap.Entry dominatedEntry : dominated.int2ObjectEntrySet()) {
            DFAType dominatingType = (DFAType)dominator.get(dominatedEntry.getIntKey());
            if (dominatingType != null && DFAType.dominates(dominatingType, (DFAType)dominatedEntry.getValue())) continue;
            return false;
        }
        return true;
    }

    private static boolean dominates(TypeDfaState dominator, TypeDfaState dominated, Int2ObjectMap<DFAType> dominantMap) {
        boolean dominateByTypes;
        boolean bl = dominateByTypes = dominated.myVarTypes.isEmpty() || dominantMap == dominator.myVarTypes;
        if (!dominateByTypes) {
            return false;
        }
        boolean dominateByMask = dominator.myProhibitedCachingVars.equals(dominated.myProhibitedCachingVars);
        if (!dominateByMask) {
            return false;
        }
        return dominator.myPreviousClosureState == dominated.myPreviousClosureState || dominated.myPreviousClosureState == null || dominated.myPreviousClosureState.isEmpty();
    }

    private static /* synthetic */ void lambda$mergeTypeMaps$0(BitSet prohibited, Int2ObjectMap newFMap, PsiManager manager, Int2ObjectMap.Entry entry) {
        int descriptorId = entry.getIntKey();
        if (descriptorId == 0 || prohibited.get(descriptorId)) {
            return;
        }
        DFAType candidate = (DFAType)entry.getValue();
        DFAType existing = (DFAType)newFMap.get(descriptorId);
        if (existing == null) {
            newFMap.put(descriptorId, (Object)candidate);
        } else if (candidate != existing) {
            newFMap.put(descriptorId, (Object)DFAType.merge(candidate, existing, manager));
        }
    }
}

