/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.NegatingGotoInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ConditionInstruction;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public final class DFAType {
    public static final DFAType NULL_DFA_TYPE = new DFAType(null);
    @Nullable
    private final PsiType primary;
    private final List<Mixin> mixins = new ArrayList<Mixin>();

    private DFAType(@Nullable PsiType primary) {
        this.primary = primary;
    }

    @Contract(pure=true)
    @NotNull
    public DFAType withNewMixin(@Nullable PsiType mixin, @Nullable ConditionInstruction instruction) {
        if (mixin == null) {
            return this;
        }
        Mixin newMixin = new Mixin(mixin, instruction, instruction != null && instruction.isNegated());
        for (Mixin existingMixin : this.mixins) {
            if (!Objects.equals(existingMixin, newMixin)) continue;
            return this;
        }
        DFAType newDfaType = new DFAType(this.primary);
        newDfaType.mixins.addAll(this.mixins);
        newDfaType.mixins.add(newMixin);
        return newDfaType;
    }

    @Contract(pure=true)
    @NotNull
    public DFAType withNegated(@NotNull NegatingGotoInstruction negation) {
        if (this.mixins.isEmpty()) {
            return this;
        }
        Set<ConditionInstruction> conditionsToNegate = negation.getCondition().getDependentConditions();
        if (ContainerUtil.and(this.mixins, mixin -> !conditionsToNegate.contains(mixin.myCondition))) {
            return this;
        }
        DFAType result2 = this.copy();
        ListIterator<Mixin> iterator2 = result2.mixins.listIterator();
        while (iterator2.hasNext()) {
            Mixin mixin2 = iterator2.next();
            if (!conditionsToNegate.contains(mixin2.myCondition)) continue;
            iterator2.set(mixin2.negate());
        }
        return result2;
    }

    @Contract(pure=true)
    @NotNull
    public static DFAType merge(DFAType t1, DFAType t2, PsiManager manager) {
        if (t1.equals(t2)) {
            return t1;
        }
        if (DFAType.dominates(t1, t2)) {
            return t1;
        }
        if (DFAType.dominates(t2, t1)) {
            return t2;
        }
        PsiType primary = TypesUtil.getLeastUpperBoundNullable(t1.primary, t2.primary, manager);
        PsiType type1 = DFAType.reduce(t1.mixins);
        PsiType type2 = DFAType.reduce(t2.mixins);
        if (type1 != null && type2 != null) {
            return DFAType.create(primary).withNewMixin(GenericsUtil.getLeastUpperBound((PsiType)type1, (PsiType)type2, (PsiManager)manager), null);
        }
        return DFAType.create(primary);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DFAType)) {
            return false;
        }
        DFAType other = (DFAType)obj;
        if (!DFAType.eq(this.primary, other.primary)) {
            return false;
        }
        if (this.mixins.size() != other.mixins.size()) {
            return false;
        }
        for (Mixin mixin1 : this.mixins) {
            boolean contains = false;
            for (Mixin mixin2 : other.mixins) {
                if (!mixin1.equals(mixin2)) continue;
                contains = mixin1.myNegated == mixin2.myNegated;
                break;
            }
            if (contains) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public PsiType getResultType() {
        if (this.mixins.isEmpty()) {
            return this.primary;
        }
        ArrayList<PsiType> types = new ArrayList<PsiType>();
        if (this.primary != null) {
            types.add(this.primary);
        }
        for (Mixin mixin : this.mixins) {
            if (mixin.myNegated || mixin.myType.equals(PsiType.NULL)) continue;
            types.add(mixin.myType);
        }
        if (types.isEmpty()) {
            return null;
        }
        return PsiIntersectionType.createIntersection((PsiType[])types.toArray(PsiType.createArray((int)types.size())));
    }

    @NotNull
    public static DFAType create(@Nullable PsiType type2) {
        return type2 == null ? NULL_DFA_TYPE : new DFAType(type2);
    }

    private static boolean eq(PsiType t1, PsiType t2) {
        return t1 == t2 || Comparing.equal((Object)TypeConversionUtil.erasure((PsiType)t1), (Object)TypeConversionUtil.erasure((PsiType)t2));
    }

    public static boolean dominates(DFAType dominating, DFAType dominated) {
        boolean primaryDominating;
        boolean bl = primaryDominating = dominated.primary == null || dominated.primary == PsiType.NULL || dominated.primary == dominating.primary;
        if (!primaryDominating) {
            return false;
        }
        return dominating.mixins.isEmpty() || dominated.mixins == dominating.mixins;
    }

    private static PsiType reduce(List<Mixin> mixins) {
        List types = mixins.stream().filter(it -> !it.myNegated).map(it -> it.myType).collect(Collectors.toList());
        return types.isEmpty() ? null : PsiIntersectionType.createIntersection(types);
    }

    @Contract(value="-> new")
    @NotNull
    private DFAType copy() {
        DFAType type2 = new DFAType(this.primary);
        type2.mixins.addAll(this.mixins);
        return type2;
    }

    public String toString() {
        return "{" + this.primary + " : " + this.mixins + "}";
    }

    private static final class Mixin {
        @NotNull
        private final PsiType myType;
        @Nullable
        private final ConditionInstruction myCondition;
        private final boolean myNegated;

        private Mixin(@NotNull PsiType type2, @Nullable ConditionInstruction condition, boolean negated) {
            this.myType = type2;
            this.myCondition = condition;
            this.myNegated = negated;
        }

        private Mixin negate() {
            return new Mixin(this.myType, this.myCondition, !this.myNegated);
        }

        public String toString() {
            return (this.myNegated ? "!" : "") + this.myType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Mixin mixin = (Mixin)o;
            if (!this.myType.equals(mixin.myType)) {
                return false;
            }
            return Objects.equals(this.myCondition, mixin.myCondition);
        }

        public int hashCode() {
            int result2 = this.myType.hashCode();
            result2 = 31 * result2 + (this.myCondition != null ? this.myCondition.hashCode() : 0);
            return result2;
        }
    }
}

