/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl;

import com.intellij.psi.PsiElement;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Collections;
import java.util.Deque;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallEnvironment;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.NegatingGotoInstruction;

public class InstructionImpl
implements Instruction {
    private final Set<Instruction> myPredecessors = new ObjectArraySet(1);
    private final Set<Instruction> mySuccessors = new ObjectArraySet(1);
    private Set<NegatingGotoInstruction> myNegations;
    protected final PsiElement myPsiElement;
    private int myNumber = -1;

    @Override
    @Nullable
    public PsiElement getElement() {
        return this.myPsiElement;
    }

    public InstructionImpl(@Nullable PsiElement element) {
        this.myPsiElement = element;
    }

    @Override
    @NotNull
    public Iterable<Instruction> successors(@NotNull CallEnvironment environment) {
        Deque<CallInstruction> stack = environment.callStack(this);
        for (Instruction instruction : this.mySuccessors) {
            environment.update(stack, instruction);
        }
        return this.mySuccessors;
    }

    @Override
    @NotNull
    public Iterable<Instruction> predecessors(@NotNull CallEnvironment environment) {
        Deque<CallInstruction> stack = environment.callStack(this);
        for (Instruction instruction : this.myPredecessors) {
            environment.update(stack, instruction);
        }
        return this.myPredecessors;
    }

    @Override
    @NotNull
    public Iterable<Instruction> allSuccessors() {
        return this.mySuccessors;
    }

    @Override
    @NotNull
    public Iterable<Instruction> allPredecessors() {
        return this.myPredecessors;
    }

    @NonNls
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.myNumber);
        builder.append("(");
        for (Instruction successor : this.mySuccessors) {
            builder.append(successor.num());
            builder.append(',');
        }
        if (!this.mySuccessors.isEmpty()) {
            builder.delete(builder.length() - 1, builder.length());
        }
        builder.append(") ").append(this.getElementPresentation());
        return builder.toString();
    }

    @NotNull
    @NonNls
    protected String getElementPresentation() {
        return "element: " + this.myPsiElement;
    }

    @Override
    public int num() {
        assert (this.myNumber != -1);
        return this.myNumber;
    }

    @Override
    @NotNull
    public Iterable<? extends NegatingGotoInstruction> getNegatingGotoInstruction() {
        if (this.myNegations == null) {
            return Collections.emptyList();
        }
        return this.myNegations;
    }

    public void addSuccessor(InstructionImpl instruction) {
        this.mySuccessors.add(instruction);
    }

    public void addPredecessor(InstructionImpl instruction) {
        this.myPredecessors.add(instruction);
    }

    void addNegationsFrom(Instruction instruction) {
        if (this.myNegations == null) {
            this.myNegations = new ObjectArraySet(1);
        }
        for (NegatingGotoInstruction negatingGotoInstruction : instruction.getNegatingGotoInstruction()) {
            this.myNegations.add(negatingGotoInstruction);
        }
        if (instruction instanceof NegatingGotoInstruction) {
            this.myNegations.add((NegatingGotoInstruction)instruction);
        }
    }

    final void setNumber(int num) {
        assert (this.myNumber == -1);
        this.myNumber = num;
    }
}

