/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.GrControlFlowPolicy;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtilKt;

public class GrResolverPolicy
implements GrControlFlowPolicy {
    private static final GrResolverPolicy INSTANCE = new GrResolverPolicy();

    @Override
    public boolean isReferenceAccepted(@NotNull GrReferenceExpression ref) {
        return !ref.isQualified() || PsiImplUtilKt.isThisRef(ref.getQualifierExpression());
    }

    @Override
    public boolean isVariableInitialized(@NotNull GrVariable variable) {
        return variable.getInitializerGroovy() != null || GrResolverPolicy.hasTupleInitializer(variable) || variable instanceof GrParameter;
    }

    private static boolean hasTupleInitializer(@NotNull GrVariable variable) {
        PsiElement parent2 = variable.getParent();
        return parent2 instanceof GrVariableDeclaration && ((GrVariableDeclaration)parent2).getTupleInitializer() != null;
    }

    public static GrResolverPolicy getInstance() {
        return INSTANCE;
    }
}

