/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.controlFlow;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrFinallyClause;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallEnvironment;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.InstructionImpl;

public class ReturnInstruction
extends InstructionImpl {
    public ReturnInstruction(GrFinallyClause finallyClause) {
        super(finallyClause);
    }

    @Override
    public String toString() {
        return super.toString() + " RETURN";
    }

    @Override
    @NotNull
    protected String getElementPresentation() {
        return "";
    }

    @Override
    @NotNull
    public Iterable<Instruction> successors(@NotNull CallEnvironment environment) {
        Deque<CallInstruction> callStack = environment.callStack(this);
        if (callStack.isEmpty()) {
            return Collections.emptyList();
        }
        CallInstruction callInstruction = callStack.peek();
        Iterable<Instruction> successors = callInstruction.allSuccessors();
        ArrayDeque<CallInstruction> copy = new ArrayDeque<CallInstruction>(callStack);
        copy.pop();
        for (Instruction instruction : successors) {
            environment.update(copy, instruction);
        }
        return successors;
    }
}

