/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.documentation;

import com.intellij.codeInsight.javadoc.JavaDocInfoGeneratorFactory;
import com.intellij.ide.highlighter.JavaHighlightingColors;
import com.intellij.lang.documentation.DocumentationSettings;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.richcopy.HtmlSyntaxInfoUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.util.ArrayUtilRt;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.highlighter.GroovySyntaxHighlighter;
import org.jetbrains.plugins.groovy.lang.documentation.TypePresentation;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.transformations.impl.namedVariant.NamedParamData;
import org.jetbrains.plugins.groovy.transformations.impl.namedVariant.NamedParamsUtil;

public final class GroovyPresentationUtil {
    private static final int CONSTRAINTS_NUMBER = 2;

    public static void appendParameterPresentation(GrParameter parameter, PsiSubstitutor substitutor2, TypePresentation typePresentation, StringBuilder builder, boolean doHighlighting) {
        if (GroovyPresentationUtil.presentNamedParameters(builder, parameter, doHighlighting)) {
            return;
        }
        for (GrAnnotation annotation : parameter.getModifierList().getAnnotations()) {
            GroovyPresentationUtil.appendStyledSpan(doHighlighting, builder, GroovySyntaxHighlighter.ANNOTATION, annotation.getText());
            builder.append(' ');
        }
        PsiType type2 = parameter.getTypeGroovy();
        type2 = substitutor2.substitute(type2);
        if (typePresentation == TypePresentation.LINK) {
            if (type2 != null) {
                StringBuilder typeBuilder = new StringBuilder();
                JavaDocInfoGeneratorFactory.create((Project)parameter.getProject(), null).generateType(typeBuilder, type2, (PsiElement)parameter);
                if (doHighlighting) {
                    builder.append((CharSequence)typeBuilder);
                } else {
                    builder.append(StringUtil.removeHtmlTags((String)typeBuilder.toString(), (boolean)true));
                }
            } else {
                GroovyPresentationUtil.appendStyledSpan(doHighlighting, builder, GroovySyntaxHighlighter.KEYWORD, "def");
            }
            builder.append(' ');
            GroovyPresentationUtil.appendStyledSpan(doHighlighting, builder, GroovySyntaxHighlighter.PARAMETER, parameter.getName());
            return;
        }
        if (type2 != null) {
            if (typePresentation == TypePresentation.PRESENTABLE) {
                builder.append(type2.getPresentableText()).append(' ').append(parameter.getName());
            } else if (typePresentation == TypePresentation.CANONICAL) {
                builder.append(type2.getCanonicalText()).append(' ').append(parameter.getName());
            }
        } else {
            builder.append(parameter.getName());
            Set structural = Collections.synchronizedSet(new LinkedHashSet());
            ReferencesSearch.search((PsiElement)parameter, (SearchScope)parameter.getUseScope()).forEach(ref -> {
                PsiElement parent2 = ref.getElement().getParent();
                if (parent2 instanceof GrReferenceExpression) {
                    if (structural.size() >= 2) {
                        structural.add("...");
                        return false;
                    }
                    StringBuilder builder1 = new StringBuilder();
                    builder1.append(((GrReferenceElement)parent2).getReferenceName());
                    PsiType[] argTypes = PsiUtil.getArgumentTypes(parent2, true);
                    if (argTypes != null) {
                        builder1.append("(");
                        builder1.append(GroovyBundle.message("parameter.hint.number.of.arguments", argTypes.length));
                        builder1.append(')');
                    }
                    structural.add(builder1.toString());
                }
                return true;
            });
            if (!structural.isEmpty()) {
                builder.append(".");
                String[] array = ArrayUtilRt.toStringArray(structural);
                if (array.length > 1) {
                    builder.append("[");
                }
                for (int i = 0; i < array.length; ++i) {
                    if (i > 0) {
                        builder.append(", ");
                    }
                    builder.append(array[i]);
                }
                if (array.length > 1) {
                    builder.append("]");
                }
            }
        }
    }

    public static String getSignaturePresentation(MethodSignature signature) {
        PsiType[] types;
        StringBuilder builder = new StringBuilder();
        builder.append(signature.getName()).append('(');
        for (PsiType type2 : types = signature.getParameterTypes()) {
            builder.append(type2.getPresentableText()).append(", ");
        }
        if (types.length > 0) {
            builder.delete(builder.length() - 2, builder.length());
        }
        builder.append(")");
        return builder.toString();
    }

    @NotNull
    private static StringBuilder appendStyledSpan(boolean doHighlighting, @NotNull StringBuilder buffer, @NotNull TextAttributesKey attributesKey, @Nullable String value) {
        if (doHighlighting) {
            HtmlSyntaxInfoUtil.appendStyledSpan((StringBuilder)buffer, (TextAttributesKey)attributesKey, (String)value, (float)DocumentationSettings.getHighlightingSaturation((boolean)false));
        } else {
            buffer.append(value);
        }
        return buffer;
    }

    private static boolean presentNamedParameters(@NotNull StringBuilder buffer, @NotNull GrParameter parameter, boolean doHighlighting) {
        List<NamedParamData> pairs = NamedParamsUtil.collectNamedParams(parameter);
        for (int i = 0; i < pairs.size(); ++i) {
            NamedParamData namedParam = pairs.get(i);
            GroovyPresentationUtil.appendStyledSpan(doHighlighting, buffer, GroovySyntaxHighlighter.PARAMETER, namedParam.getName());
            GroovyPresentationUtil.appendStyledSpan(doHighlighting, buffer, JavaHighlightingColors.OPERATION_SIGN, ": ");
            GroovyPresentationUtil.appendStyledSpan(doHighlighting, buffer, GroovySyntaxHighlighter.CLASS_REFERENCE, namedParam.getType().getPresentableText());
            if (i == pairs.size() - 1) continue;
            GroovyPresentationUtil.appendStyledSpan(doHighlighting, buffer, JavaHighlightingColors.COMMA, ", ");
        }
        return !pairs.isEmpty();
    }
}

