/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.documentation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.editorActions.CodeDocumentationUtil;
import com.intellij.codeInsight.javadoc.JavaDocExternalFilter;
import com.intellij.codeInsight.javadoc.JavaDocHighlightingManager;
import com.intellij.codeInsight.javadoc.JavaDocInfoGenerator;
import com.intellij.codeInsight.javadoc.JavaDocInfoGeneratorFactory;
import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.java.JavaBundle;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.documentation.CodeDocumentationProvider;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.DocumentationSettings;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.lang.java.JavaDocumentationProvider;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.richcopy.HtmlSyntaxInfoUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.dsl.GdslNamedParameter;
import org.jetbrains.plugins.groovy.dsl.holders.NonCodeMembersHolder;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.lang.completion.GrPropertyForCompletion;
import org.jetbrains.plugins.groovy.lang.documentation.GroovyDocHighlightingManager;
import org.jetbrains.plugins.groovy.lang.documentation.GroovyDocInfoGenerator;
import org.jetbrains.plugins.groovy.lang.documentation.GroovyPresentationUtil;
import org.jetbrains.plugins.groovy.lang.documentation.TypePresentation;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocCommentUtil;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTraitType;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrImplicitVariable;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightVariable;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMapProperty;

public class GroovyDocumentationProvider
implements CodeDocumentationProvider,
ExternalDocumentationProvider {
    private static final String LINE_SEPARATOR = "\n";
    @NonNls
    private static final String RETURN_TAG = "@return";
    @NonNls
    private static final String THROWS_TAG = "@throws";
    private static final String BODY_HTML = "</body></html>";

    private static void appendStyledSpan(@NotNull StringBuilder buffer, @NotNull TextAttributes attributes, @Nullable String value) {
        if (DocumentationSettings.isHighlightingOfQuickDocSignaturesEnabled()) {
            HtmlSyntaxInfoUtil.appendStyledSpan((StringBuilder)buffer, (TextAttributes)attributes, (String)value, (float)DocumentationSettings.getHighlightingSaturation((boolean)false));
        } else {
            buffer.append(value);
        }
    }

    private static void appendStyledSpan(@NotNull StringBuilder buffer, @Nullable String value, String ... properties) {
        if (DocumentationSettings.isHighlightingOfQuickDocSignaturesEnabled()) {
            HtmlSyntaxInfoUtil.appendStyledSpan((StringBuilder)buffer, (String)value, (String[])properties);
        } else {
            buffer.append(value);
        }
    }

    private static PsiSubstitutor calcSubstitutor(PsiElement originalElement) {
        PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
        if (originalElement instanceof GrReferenceExpression) {
            substitutor2 = ((GrReferenceExpression)originalElement).advancedResolve().getSubstitutor();
        }
        return substitutor2;
    }

    @Nullable
    @Nls
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        if (element instanceof GrVariable || element instanceof GrImplicitVariable) {
            @Nls StringBuilder buffer = new StringBuilder();
            PsiVariable variable = (PsiVariable)element;
            if (originalElement instanceof GrVariableDeclaration && ((GrVariableDeclaration)originalElement).getVariables().length > 1) {
                for (GrVariable var : ((GrVariableDeclaration)originalElement).getVariables()) {
                    GroovyDocumentationProvider.generateVariableInfo(originalElement, buffer, var);
                    buffer.append("\n\n");
                }
            } else {
                GroovyDocumentationProvider.generateVariableInfo(originalElement, buffer, variable);
            }
            return buffer.toString();
        }
        if (element instanceof PsiMethod) {
            @Nls StringBuilder buffer = new StringBuilder();
            PsiMethod method = (PsiMethod)element;
            if (method instanceof GrGdkMethod) {
                GroovyDocumentationProvider.appendStyledSpan(buffer, "[" + GroovyBundle.message("documentation.gdk.label", new Object[0]) + "]", "color: #909090");
            } else {
                String qName;
                PsiClass hisClass = method.getContainingClass();
                if (hisClass != null && (qName = hisClass.getQualifiedName()) != null) {
                    GroovyDocumentationProvider.appendStyledSpan(buffer, GroovyDocHighlightingManager.getInstance().getClassDeclarationAttributes(hisClass), qName);
                    buffer.append(LINE_SEPARATOR);
                }
            }
            PsiSubstitutor substitutor2 = GroovyDocumentationProvider.calcSubstitutor(originalElement);
            if (!method.isConstructor()) {
                PsiType substituted = substitutor2.substitute(PsiUtil.getSmartReturnType(method));
                GroovyDocumentationProvider.appendTypeString(buffer, substituted, originalElement, false);
                buffer.append(" ");
            }
            GroovyDocumentationProvider.appendStyledSpan(buffer, GroovyDocHighlightingManager.getInstance().getMethodDeclarationAttributes(method), method.getName());
            GroovyDocumentationProvider.appendStyledSpan(buffer, GroovyDocHighlightingManager.getInstance().getParenthesesAttributes(), "(");
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            for (int i = 0; i < parameters2.length; ++i) {
                PsiParameter parameter = parameters2[i];
                if (i > 0) {
                    GroovyDocumentationProvider.appendStyledSpan(buffer, GroovyDocHighlightingManager.getInstance().getCommaAttributes(), ", ");
                }
                if (parameter instanceof GrParameter) {
                    GroovyPresentationUtil.appendParameterPresentation((GrParameter)parameter, substitutor2, TypePresentation.LINK, buffer, DocumentationSettings.isHighlightingOfQuickDocSignaturesEnabled());
                    continue;
                }
                PsiType type2 = parameter.getType();
                GroovyDocumentationProvider.appendTypeString(buffer, substitutor2.substitute(type2), originalElement, false);
                buffer.append(" ");
                GroovyDocumentationProvider.appendStyledSpan(buffer, GroovyDocHighlightingManager.getInstance().getParameterAttributes(), parameter.getName());
            }
            GroovyDocumentationProvider.appendStyledSpan(buffer, GroovyDocHighlightingManager.getInstance().getParenthesesAttributes(), ")");
            PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
            if (referencedTypes.length > 0) {
                GroovyDocumentationProvider.appendStyledSpan(buffer, GroovyDocHighlightingManager.getInstance().getKeywordAttributes(), "\nthrows ");
                for (int i = 0; i < referencedTypes.length; ++i) {
                    PsiClassType referencedType = referencedTypes[i];
                    GroovyDocumentationProvider.appendTypeString(buffer, (PsiType)referencedType, originalElement, false);
                    if (i == referencedTypes.length - 1) continue;
                    GroovyDocumentationProvider.appendStyledSpan(buffer, GroovyDocHighlightingManager.getInstance().getCommaAttributes(), ", ");
                }
            }
            return buffer.toString();
        }
        if (element instanceof GrTypeDefinition) {
            return GroovyDocumentationProvider.generateClassInfo((GrTypeDefinition)element);
        }
        if (element instanceof GroovyMapProperty) {
            @Nls StringBuilder buffer = new StringBuilder();
            GroovyMapProperty mapProperty = (GroovyMapProperty)element;
            GroovyDocumentationProvider.appendStyledSpan(buffer, "Map property\n", new String[0]);
            PsiType inferredType = mapProperty.getPropertyType();
            String typeLabel = inferredType != null ? GroovyBundle.message("documentation.inferred.type.label", new Object[0]) : GroovyBundle.message("documentation.cannot.infer.type.label", new Object[0]);
            GroovyDocumentationProvider.appendStyledSpan(buffer, "[" + typeLabel + "]", "color: #909090");
            if (inferredType != null) {
                buffer.append(" ");
                GroovyDocumentationProvider.appendTypeString(buffer, inferredType, originalElement, false);
            }
            buffer.append(" ");
            GroovyDocumentationProvider.appendStyledSpan(buffer, GroovyDocHighlightingManager.getInstance().getClassNameAttributes(), mapProperty.getName());
            return buffer.toString();
        }
        return null;
    }

    private static void generateVariableInfo(PsiElement originalElement, @Nls StringBuilder buffer, PsiVariable variable) {
        if (variable instanceof PsiField) {
            PsiClass parentClass = ((PsiField)variable).getContainingClass();
            if (parentClass != null) {
                GroovyDocumentationProvider.appendElementLink(buffer, (PsiElement)parentClass, JavaDocUtil.getShortestClassName((PsiClass)parentClass, (PsiElement)variable));
                GroovyDocumentationProvider.newLine(buffer);
            }
            GroovyDocumentationProvider.generateModifiers(buffer, (PsiModifierListOwner)variable);
        }
        PsiType type2 = variable instanceof GrVariable ? ((GrVariable)variable).getDeclaredType() : variable.getType();
        GroovyDocumentationProvider.appendTypeString(buffer, GroovyDocumentationProvider.calcSubstitutor(originalElement).substitute(type2), originalElement, false);
        buffer.append(" ");
        TextAttributes varAttributes = variable instanceof PsiField ? GroovyDocHighlightingManager.getInstance().getFieldDeclarationAttributes((PsiField)variable) : GroovyDocHighlightingManager.getInstance().getLocalVariableAttributes();
        GroovyDocumentationProvider.appendStyledSpan(buffer, varAttributes, variable.getName());
        if (variable instanceof GrVariable) {
            PsiReference ref;
            GroovyDocumentationProvider.newLine(buffer);
            while (originalElement != null && ((ref = originalElement.getReference()) == null || ref.resolve() == null)) {
                originalElement = originalElement.getParent();
            }
            if (originalElement != null) {
                GroovyDocumentationProvider.appendInferredType(originalElement, (GrVariable)variable, buffer, false);
            }
        }
    }

    private static void appendInferredType(PsiElement originalElement, GrVariable variable, @Nls StringBuilder buffer, boolean isRendered) {
        PsiType inferredType = null;
        if (PsiImplUtil.isWhiteSpaceOrNls(originalElement)) {
            originalElement = PsiTreeUtil.prevLeaf((PsiElement)originalElement);
        }
        if (originalElement != null && originalElement.getNode().getElementType() == GroovyTokenTypes.mIDENT) {
            originalElement = originalElement.getParent();
        }
        if (originalElement instanceof GrReferenceExpression) {
            inferredType = ((GrReferenceExpression)originalElement).getType();
        } else if (originalElement instanceof GrVariableDeclaration) {
            inferredType = variable.getTypeGroovy();
        } else if (originalElement instanceof GrVariable) {
            inferredType = ((GrVariable)originalElement).getTypeGroovy();
        }
        String typeLabel = inferredType != null ? GroovyBundle.message("documentation.inferred.type.label", new Object[0]) : GroovyBundle.message("documentation.cannot.infer.type.label", new Object[0]);
        GroovyDocumentationProvider.appendStyledSpan(buffer, "[" + typeLabel + "]", "color: #909090");
        if (inferredType != null) {
            buffer.append(" ");
            GroovyDocumentationProvider.appendTypeString(buffer, inferredType, originalElement, isRendered);
        }
    }

    private static void generateModifiers(@Nls StringBuilder buffer, PsiModifierListOwner element) {
        String modifiers = PsiFormatUtil.formatModifiers((PsiModifierListOwner)element, (int)16384);
        if (!modifiers.isEmpty()) {
            GroovyDocumentationProvider.appendStyledSpan(buffer, GroovyDocHighlightingManager.getInstance().getKeywordAttributes(), modifiers);
            buffer.append(" ");
        }
    }

    private static void newLine(StringBuilder buffer) {
        buffer.append(LINE_SEPARATOR);
    }

    @Nls
    @NotNull
    private static String generateClassInfo(@NotNull PsiClass aClass) {
        @Nls StringBuilder buffer = new StringBuilder();
        GroovyFile file = (GroovyFile)aClass.getContainingFile();
        GroovyDocHighlightingManager highlightingManager = GroovyDocHighlightingManager.getInstance();
        String packageName = file.getPackageName();
        if (!packageName.isEmpty()) {
            GroovyDocumentationProvider.appendStyledSpan(buffer, highlightingManager.getClassNameAttributes(), packageName);
            buffer.append(LINE_SEPARATOR);
        }
        String classString = aClass.isInterface() ? GroovyBundle.message("groovy.term.interface", new Object[0]) : (aClass instanceof PsiTypeParameter ? GroovyBundle.message("groovy.term.type.parameter", new Object[0]) : (aClass.isEnum() ? GroovyBundle.message("groovy.term.enum", new Object[0]) : GroovyBundle.message("groovy.term.class", new Object[0])));
        GroovyDocumentationProvider.appendStyledSpan(buffer, highlightingManager.getKeywordAttributes(), classString);
        buffer.append(" ");
        GroovyDocumentationProvider.appendStyledSpan(buffer, highlightingManager.getClassDeclarationAttributes(aClass), aClass.getName());
        JavaDocumentationProvider.generateTypeParameters((PsiTypeParameterListOwner)aClass, (StringBuilder)buffer, (JavaDocHighlightingManager)highlightingManager);
        JavaDocumentationProvider.writeExtends((PsiClass)aClass, (StringBuilder)buffer, (PsiClassType[])aClass.getExtendsListTypes(), (JavaDocHighlightingManager)highlightingManager);
        JavaDocumentationProvider.writeImplements((PsiClass)aClass, (StringBuilder)buffer, (PsiClassType[])aClass.getImplementsListTypes(), (JavaDocHighlightingManager)highlightingManager);
        return buffer.toString();
    }

    public static void appendTypeString(@Nls @NotNull StringBuilder buffer, @Nullable PsiType type2, PsiElement context, boolean isRendered) {
        if (type2 instanceof GrTraitType) {
            GroovyDocumentationProvider.generateTraitType(buffer, (GrTraitType)type2, context, isRendered);
        } else if (type2 != null) {
            JavaDocInfoGeneratorFactory.getBuilder((Project)context.getProject()).setHighlightingManager((JavaDocHighlightingManager)GroovyDocHighlightingManager.getInstance()).setIsGenerationForRenderedDoc(isRendered).create().generateType(buffer, type2, context);
        } else {
            GroovyDocumentationProvider.appendStyledSpan(buffer, GroovyDocHighlightingManager.getInstance().getKeywordAttributes(), "def");
        }
    }

    private static void generateTraitType(@NotNull StringBuilder buffer, @NotNull GrTraitType type2, PsiElement context, boolean isRendered) {
        GroovyDocumentationProvider.appendTypeString(buffer, type2.getExprType(), context, isRendered);
        GroovyDocumentationProvider.appendStyledSpan(buffer, GroovyDocHighlightingManager.getInstance().getKeywordAttributes(), " as ");
        @NotNull List<PsiType> types = type2.getTraitTypes();
        for (int i = 0; i < types.size(); ++i) {
            PsiType traitType = types.get(i);
            GroovyDocumentationProvider.appendTypeString(buffer, traitType, context, isRendered);
            if (i == types.size() - 1) continue;
            GroovyDocumentationProvider.appendStyledSpan(buffer, GroovyDocHighlightingManager.getInstance().getCommaAttributes(), ", ");
        }
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        List list;
        ArrayList<String> result2 = new ArrayList<String>();
        PsiElement docElement = GroovyDocumentationProvider.getDocumentationElement(element, originalElement);
        if (docElement != null) {
            ContainerUtil.addIfNotNull(result2, (Object)((String)docElement.getUserData(NonCodeMembersHolder.DOCUMENTATION_URL)));
        }
        if ((list = JavaDocumentationProvider.getExternalJavaDocUrl((PsiElement)element)) != null) {
            result2.addAll(list);
        }
        return result2.isEmpty() ? null : result2;
    }

    @Nullable
    @Nls
    public String generateDoc(PsiElement element, PsiElement originalElement) {
        String gdslDoc;
        GroovyDocHighlightingManager highlightingManager = GroovyDocHighlightingManager.getInstance();
        if (element instanceof GdslNamedParameter) {
            String name = ((GdslNamedParameter)element).getName();
            if (name == null) {
                return null;
            }
            StringBuilder buffer = new StringBuilder("<pre>");
            String parameterTypeText = ((GdslNamedParameter)element).myParameterTypeText;
            GroovyDocumentationProvider.appendStyledSpan(buffer, highlightingManager.getParameterAttributes(), name);
            if (parameterTypeText != null) {
                GroovyDocumentationProvider.appendStyledSpan(buffer, highlightingManager.getOperationSignAttributes(), ":");
                buffer.append(" ");
                GroovyDocumentationProvider.appendStyledSpan(buffer, highlightingManager.getClassNameAttributes(), parameterTypeText);
            }
            buffer.append("</pre>");
            String docString = ((GdslNamedParameter)element).docString;
            if (docString != null) {
                buffer.append("<p>").append(HtmlChunk.text((String)docString)).append("</p>");
            }
            return buffer.toString();
        }
        if (element instanceof GrReferenceExpression) {
            return GroovyDocumentationProvider.getMethodCandidateInfo((GrReferenceExpression)element);
        }
        if ((element = GroovyDocumentationProvider.getDocumentationElement(element, originalElement)) == null) {
            return null;
        }
        String standard = GroovyDocumentationProvider.generateExternalJavaDoc(element);
        if (element instanceof GrVariable && ((GrVariable)element).getDeclaredType() == null && standard != null) {
            String truncated = StringUtil.trimEnd((String)standard, (String)BODY_HTML);
            @Nls StringBuilder buffer = new StringBuilder(truncated);
            buffer.append("<p style='padding-left:8px;'>");
            if (originalElement != null) {
                GroovyDocumentationProvider.appendInferredType(originalElement, (GrVariable)element, buffer, false);
            } else if (element.getParent() instanceof GrVariableDeclaration) {
                GroovyDocumentationProvider.appendInferredType(element.getParent(), (GrVariable)element, buffer, false);
            }
            if (!truncated.equals(standard)) {
                buffer.append(BODY_HTML);
            }
            standard = buffer.toString();
        }
        if ((gdslDoc = (String)element.getUserData(NonCodeMembersHolder.DOCUMENTATION)) != null) {
            if (standard != null) {
                String truncated = StringUtil.trimEnd((String)standard, (String)BODY_HTML);
                String appended = truncated + "<p>" + gdslDoc;
                if (truncated.equals(standard)) {
                    return appended;
                }
                return appended + BODY_HTML;
            }
            return gdslDoc;
        }
        return standard;
    }

    private static GroovyDocInfoGenerator getDocInfoGenerator(@NotNull PsiElement element, boolean isGenerationForRenderedDoc) {
        return new GroovyDocInfoGenerator(element, isGenerationForRenderedDoc, DocumentationSettings.isHighlightingOfQuickDocSignaturesEnabled(), DocumentationSettings.isHighlightingOfCodeBlocksEnabled(), DocumentationSettings.getInlineCodeHighlightingMode(), DocumentationSettings.isSemanticHighlightingOfLinksEnabled(), DocumentationSettings.getHighlightingSaturation((boolean)isGenerationForRenderedDoc));
    }

    @Nls
    @Nullable
    protected static String generateExternalJavaDoc(@NotNull PsiElement element) {
        GroovyDocInfoGenerator generator = GroovyDocumentationProvider.getDocInfoGenerator(element, false);
        return JavaDocumentationProvider.generateExternalJavadoc((PsiElement)element, (JavaDocInfoGenerator)generator);
    }

    private static PsiElement getDocumentationElement(PsiElement element, PsiElement originalElement) {
        PsiElement navigationElement;
        GrDocComment doc;
        if (element instanceof GrGdkMethod) {
            element = ((GrGdkMethod)element).getStaticMethod();
        }
        if ((doc = (GrDocComment)PsiTreeUtil.getParentOfType((PsiElement)originalElement, GrDocComment.class)) != null) {
            element = GrDocCommentUtil.findDocOwner(doc);
        }
        if (element instanceof GrLightVariable && (navigationElement = element.getNavigationElement()) != null) {
            element = navigationElement;
            if (element.getContainingFile() instanceof PsiCompiledFile && (navigationElement = element.getNavigationElement()) != null) {
                element = navigationElement;
            }
            if (element instanceof GrAccessorMethod) {
                element = ((GrAccessorMethod)element).getProperty();
            }
        }
        if (element instanceof GrPropertyForCompletion) {
            element = ((GrPropertyForCompletion)element).getOriginalAccessor();
        }
        return element;
    }

    @Nls
    public String fetchExternalDocumentation(Project project, PsiElement element, List<String> docUrls, boolean onHover) {
        return JavaDocumentationProvider.fetchExternalJavadoc((PsiElement)element, (Project)project, docUrls);
    }

    public boolean hasDocumentationFor(PsiElement element, PsiElement originalElement) {
        return CompositeDocumentationProvider.hasUrlsFor((DocumentationProvider)this, (PsiElement)element, (PsiElement)originalElement);
    }

    public boolean canPromptToConfigureDocumentation(PsiElement element) {
        return false;
    }

    public void promptToConfigureDocumentation(PsiElement element) {
    }

    @Nls
    private static String getMethodCandidateInfo(GrReferenceExpression expr) {
        GroovyResolveResult[] candidates = expr.multiResolve(false);
        String text = expr.getText();
        if (candidates.length > 0) {
            @NonNls StringBuilder sb = new StringBuilder();
            for (GroovyResolveResult candidate : candidates) {
                PsiElement element = candidate.getElement();
                if (!(element instanceof PsiMethod)) continue;
                String str = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)element), (PsiSubstitutor)candidate.getSubstitutor(), (int)259, (int)2);
                sb.append("&nbsp;&nbsp;");
                GroovyDocumentationProvider.appendElementLink(sb, element, str);
                sb.append("<br>");
            }
            return CodeInsightBundle.message((String)"javadoc.candidates", (Object[])new Object[]{text, sb});
        }
        return JavaBundle.message((String)"javadoc.candidates.not.found", (Object[])new Object[]{text});
    }

    private static void appendElementLink(@NonNls StringBuilder sb, PsiElement element, String label) {
        GroovyDocumentationProvider.getDocInfoGenerator(element, false).appendMaybeUnresolvedLink(sb, element, label, element.getProject(), false);
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (object instanceof GroovyResolveResult) {
            return ((GroovyResolveResult)object).getElement();
        }
        if (object instanceof NamedArgumentDescriptor) {
            return ((NamedArgumentDescriptor)object).getNavigationElement();
        }
        if (object instanceof GrPropertyForCompletion) {
            return ((GrPropertyForCompletion)((Object)object)).getOriginalAccessor();
        }
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return JavaDocUtil.findReferenceTarget((PsiManager)psiManager, (String)link, (PsiElement)context);
    }

    public PsiComment findExistingDocComment(PsiComment contextElement) {
        GrDocCommentOwner owner;
        if (contextElement instanceof GrDocComment && (owner = GrDocCommentUtil.findDocOwner((GrDocComment)contextElement)) != null) {
            return owner.getDocComment();
        }
        return null;
    }

    @Nullable
    public Pair<PsiElement, PsiComment> parseContext(@NotNull PsiElement startPoint) {
        for (PsiElement e = startPoint; e != null; e = e.getParent()) {
            if (!(e instanceof GrDocCommentOwner)) continue;
            return Pair.create((Object)e, (Object)((GrDocCommentOwner)e).getDocComment());
        }
        return null;
    }

    public String generateDocumentationContentStub(PsiComment contextComment) {
        PsiTypeParameterList typeParameterList;
        if (!(contextComment instanceof GrDocComment)) {
            return null;
        }
        GrDocCommentOwner owner = GrDocCommentUtil.findDocOwner((GrDocComment)contextComment);
        if (owner == null) {
            return null;
        }
        CodeDocumentationAwareCommenter commenter = (CodeDocumentationAwareCommenter)LanguageCommenters.INSTANCE.forLanguage(owner.getLanguage());
        StringBuilder builder = new StringBuilder();
        if (owner instanceof GrMethod) {
            PsiClassType[] references;
            GrMethod method = (GrMethod)owner;
            JavaDocumentationProvider.generateParametersTakingDocFromSuperMethods((StringBuilder)builder, (CodeDocumentationAwareCommenter)commenter, (PsiMethod)method);
            PsiType returnType2 = method.getInferredReturnType();
            if ((returnType2 != null || method.getModifierList().hasModifierProperty("def")) && !PsiType.VOID.equals((Object)returnType2)) {
                builder.append(CodeDocumentationUtil.createDocCommentLine((String)RETURN_TAG, (PsiFile)contextComment.getContainingFile(), (CodeDocumentationAwareCommenter)commenter));
                builder.append(LINE_SEPARATOR);
            }
            for (PsiClassType reference : references = method.getThrowsList().getReferencedTypes()) {
                builder.append(CodeDocumentationUtil.createDocCommentLine((String)THROWS_TAG, (PsiFile)contextComment.getContainingFile(), (CodeDocumentationAwareCommenter)commenter));
                builder.append(reference.getClassName());
                builder.append(LINE_SEPARATOR);
            }
        } else if (owner instanceof GrTypeDefinition && (typeParameterList = ((PsiClass)owner).getTypeParameterList()) != null) {
            JavaDocumentationProvider.createTypeParamsListComment((StringBuilder)builder, (CodeDocumentationAwareCommenter)commenter, (PsiTypeParameterList)typeParameterList);
        }
        return builder.length() > 0 ? builder.toString() : null;
    }

    public void collectDocComments(@NotNull PsiFile file, @NotNull @NotNull Consumer<? super @NotNull PsiDocCommentBase> sink) {
        if (!(file instanceof GroovyFile)) {
            return;
        }
        GroovyFile groovyFile = (GroovyFile)file;
        GroovyDocumentationProvider.processDocComments(PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)groovyFile, GrDocComment.class), sink);
    }

    private static void processDocComments(@NotNull List<GrDocComment> comments, @NotNull @NotNull Consumer<? super @NotNull PsiDocCommentBase> sink) {
        for (GrDocComment comment : comments) {
            GrDocCommentOwner owner;
            if (comment == null || (owner = comment.getOwner()) == null) continue;
            sink.accept((PsiDocCommentBase)comment);
            if (!(owner instanceof GrTypeDefinition)) continue;
            List nestedComments = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)((GrTypeDefinition)owner).getBody(), GrDocComment.class);
            GroovyDocumentationProvider.processDocComments(nestedComments, sink);
        }
    }

    @Nls
    @Nullable
    public String generateRenderedDoc(@NotNull PsiDocCommentBase comment) {
        PsiElement owner = comment.getOwner();
        String html = GroovyDocumentationProvider.getDocInfoGenerator((PsiElement)(owner == null ? comment : owner), true).generateRenderedDocInfo();
        return JavaDocExternalFilter.filterInternalDocInfo((String)html);
    }
}

