/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.GroovySmartEnterProcessor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;

public class GrSwitchBodyFixer
extends SmartEnterProcessorWithFixers.Fixer<GroovySmartEnterProcessor> {
    public void apply(@NotNull Editor editor, @NotNull GroovySmartEnterProcessor processor, @NotNull PsiElement psiElement) {
        GrSwitchStatement switchStatement = (GrSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, GrSwitchStatement.class);
        if (switchStatement == null || switchStatement.getLBrace() != null) {
            return;
        }
        if (!PsiTreeUtil.isAncestor((PsiElement)switchStatement.getCondition(), (PsiElement)psiElement, (boolean)false)) {
            return;
        }
        Document doc = editor.getDocument();
        PsiElement lBrace = switchStatement.getLBrace();
        if (lBrace != null) {
            return;
        }
        PsiElement eltToInsertAfter = switchStatement.getRParenth();
        String text = "{\n}";
        if (eltToInsertAfter == null) {
            eltToInsertAfter = switchStatement.getCondition();
            text = "){\n}";
        }
        doc.insertString(eltToInsertAfter.getTextRange().getEndOffset(), (CharSequence)text);
    }
}

