/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.GroovySmartEnterProcessor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public class GrLiteralFixer
extends SmartEnterProcessorWithFixers.Fixer<GroovySmartEnterProcessor> {
    public void apply(@NotNull Editor editor, @NotNull GroovySmartEnterProcessor processor, @NotNull PsiElement psiElement) {
        if (psiElement instanceof GrLiteral) {
            String text = psiElement.getText();
            if (StringUtil.startsWith((CharSequence)text, (CharSequence)"'''")) {
                if (!StringUtil.endsWith((CharSequence)text, (CharSequence)"'''")) {
                    editor.getDocument().insertString(psiElement.getTextRange().getEndOffset(), (CharSequence)"'''");
                }
            } else if (StringUtil.startsWith((CharSequence)text, (CharSequence)"'")) {
                if (!StringUtil.endsWith((CharSequence)text, (CharSequence)"'")) {
                    editor.getDocument().insertString(psiElement.getTextRange().getEndOffset(), (CharSequence)"'");
                }
            } else if (StringUtil.startsWith((CharSequence)text, (CharSequence)"\"\"\"")) {
                if (!StringUtil.endsWith((CharSequence)text, (CharSequence)"\"\"\"")) {
                    editor.getDocument().insertString(psiElement.getTextRange().getEndOffset(), (CharSequence)"\"\"\"");
                }
            } else if (StringUtil.startsWith((CharSequence)text, (CharSequence)"\"") && !StringUtil.endsWith((CharSequence)text, (CharSequence)"\"")) {
                editor.getDocument().insertString(psiElement.getTextRange().getEndOffset(), (CharSequence)"\"");
            }
        }
    }
}

