/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.handlers;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMemberReference;

public class GroovyMethodSignatureInsertHandler
implements InsertHandler<LookupElement> {
    private static final Logger LOG = Logger.getInstance(GroovyMethodSignatureInsertHandler.class);

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        int afterSharp;
        if (!(item.getObject() instanceof PsiMethod)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(context.getEditor().getDocument());
        Editor editor = context.getEditor();
        PsiMethod method = (PsiMethod)item.getObject();
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        StringBuilder buffer = new StringBuilder();
        CharSequence chars2 = editor.getDocument().getCharsSequence();
        int endOffset = editor.getCaretModel().getOffset();
        Project project = context.getProject();
        int signatureOffset = afterSharp = CharArrayUtil.shiftBackwardUntil((CharSequence)chars2, (int)(endOffset - 1), (String)"#") + 1;
        PsiElement element = context.getFile().findElementAt(signatureOffset - 1);
        CommonCodeStyleSettings styleSettings = CodeStyle.getLanguageSettings((PsiFile)context.getFile(), (Language)GroovyLanguage.INSTANCE);
        PsiDocTag tag = (PsiDocTag)PsiTreeUtil.getParentOfType((PsiElement)element, PsiDocTag.class);
        if (context.getCompletionChar() == '\t') {
            PsiDocTagValue value = tag.getValueElement();
            endOffset = value.getTextRange().getEndOffset();
        }
        editor.getDocument().deleteString(afterSharp, endOffset);
        editor.getCaretModel().moveToOffset(signatureOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
        buffer.append(method.getName()).append("(");
        int afterParenth = afterSharp + buffer.length();
        for (int i = 0; i < parameters2.length; ++i) {
            PsiType type2 = TypeConversionUtil.erasure((PsiType)parameters2[i].getType());
            buffer.append(type2.getCanonicalText());
            if (i >= parameters2.length - 1) continue;
            buffer.append(",");
            if (!styleSettings.SPACE_AFTER_COMMA) continue;
            buffer.append(" ");
        }
        buffer.append(")");
        if (!(tag instanceof PsiInlineDocTag)) {
            buffer.append(" ");
        } else {
            int currentOffset = editor.getCaretModel().getOffset();
            if (chars2.charAt(currentOffset) == '}') {
                ++afterSharp;
            } else {
                buffer.append("} ");
            }
        }
        String insertString = buffer.toString();
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)insertString);
        editor.getCaretModel().moveToOffset(afterSharp + buffer.length());
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        GroovyMethodSignatureInsertHandler.shortenReferences(project, editor, context, afterParenth);
    }

    private static void shortenReferences(Project project, Editor editor, InsertionContext context, int offset) {
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        PsiElement element = context.getFile().findElementAt(offset);
        GrDocMemberReference tagValue = (GrDocMemberReference)PsiTreeUtil.getParentOfType((PsiElement)element, GrDocMemberReference.class);
        if (tagValue != null) {
            try {
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)tagValue);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
    }
}

