/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.WordCompletionContributor;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.completion.GrAnnotationAttributeCompletionProvider;
import org.jetbrains.plugins.groovy.lang.completion.GrDummyIdentifierProvider;
import org.jetbrains.plugins.groovy.lang.completion.GrInlineTransformationCompletionProvider;
import org.jetbrains.plugins.groovy.lang.completion.GrMainCompletionProvider;
import org.jetbrains.plugins.groovy.lang.completion.GrMethodOverrideCompletionProvider;
import org.jetbrains.plugins.groovy.lang.completion.GrStatementStartCompletionProvider;
import org.jetbrains.plugins.groovy.lang.completion.GrThisSuperCompletionProvider;
import org.jetbrains.plugins.groovy.lang.completion.GroovyConfigSlurperCompletionProvider;
import org.jetbrains.plugins.groovy.lang.completion.GroovyDocCompletionProvider;
import org.jetbrains.plugins.groovy.lang.completion.MapArgumentCompletionProvider;
import org.jetbrains.plugins.groovy.lang.completion.MapKeysCompletionProvider;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public class GroovyCompletionContributor
extends CompletionContributor {
    private static final ElementPattern<PsiElement> AFTER_NUMBER_LITERAL = PlatformPatterns.psiElement().afterLeafSkipping(StandardPatterns.alwaysFalse(), (ElementPattern)PlatformPatterns.psiElement().withElementType((ElementPattern)PsiJavaPatterns.elementType().oneOf((Object[])new IElementType[]{GroovyTokenTypes.mNUM_DOUBLE, GroovyTokenTypes.mNUM_INT, GroovyTokenTypes.mNUM_LONG, GroovyTokenTypes.mNUM_FLOAT, GroovyTokenTypes.mNUM_BIG_INT, GroovyTokenTypes.mNUM_BIG_DECIMAL})));

    public GroovyCompletionContributor() {
        GrMethodOverrideCompletionProvider.register(this);
        GrThisSuperCompletionProvider.register(this);
        MapArgumentCompletionProvider.register(this);
        GroovyConfigSlurperCompletionProvider.register(this);
        MapKeysCompletionProvider.register(this);
        GroovyDocCompletionProvider.register(this);
        GrStatementStartCompletionProvider.register(this);
        GrInlineTransformationCompletionProvider.register(this);
        GrMainCompletionProvider.register(this);
        GrAnnotationAttributeCompletionProvider.register(this);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(GrLiteral.class), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
                HashSet<String> usedWords = new HashSet<String>();
                for (CompletionResult element : result2.runRemainingContributors(parameters2, true)) {
                    usedWords.add(element.getLookupElement().getLookupString());
                }
                PsiReference reference = parameters2.getPosition().getContainingFile().findReferenceAt(parameters2.getOffset());
                if (reference == null || reference.isSoft()) {
                    WordCompletionContributor.addWordCompletionVariants((CompletionResultSet)result2, (CompletionParameters)parameters2, usedWords);
                }
            }
        });
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        if (!AFTER_NUMBER_LITERAL.accepts((Object)parameters2.getPosition())) {
            super.fillCompletionVariants(parameters2, result2);
        }
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        PsiElement position;
        String identifier = new GrDummyIdentifierProvider(context).getIdentifier();
        if (identifier != null) {
            context.setDummyIdentifier(identifier);
        }
        if ((position = context.getFile().findElementAt(context.getStartOffset())) != null && position.getNode().getElementType() == GroovyTokenTypes.mDOLLAR) {
            context.getOffsetMap().addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, context.getStartOffset());
        }
    }
}

