/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style.parameterToEntry;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.style.parameterToEntry.GroovyMapParameterDialog;
import org.jetbrains.plugins.groovy.lang.psi.GrNamedElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrParameterListOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.members.GrMethodImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.refactoring.GroovyValidationUtil;

public class ConvertParameterToMapEntryIntention
extends Intention {
    private static final Logger LOG = Logger.getInstance(ConvertParameterToMapEntryIntention.class);
    @NlsSafe
    private static final String MAP_TYPE_TEXT = "Map";
    @NlsSafe
    private static final String[] MY_POSSIBLE_NAMES = new String[]{"attrs", "args", "params", "map"};

    @Override
    protected void processIntention(final @NotNull PsiElement element, final @NotNull Project project, Editor editor) throws IncorrectOperationException {
        ArrayList<PsiElement> occurrences;
        final GrParameterListOwner owner = (GrParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, GrParameterListOwner.class);
        boolean success = ConvertParameterToMapEntryIntention.collectOwnerOccurrences(project, owner, occurrences = new ArrayList<PsiElement>());
        if (!success) {
            return;
        }
        final boolean isClosure = owner instanceof GrClosableBlock;
        if (!ConvertParameterToMapEntryIntention.checkOwnerOccurrences(project, occurrences, isClosure)) {
            return;
        }
        final GrParameter firstParam = ConvertParameterToMapEntryIntention.getFirstParameter(owner);
        switch (ConvertParameterToMapEntryIntention.analyzeForNamedArguments(owner, occurrences)) {
            case ERROR: {
                GrNamedElement namedElement = ConvertParameterToMapEntryIntention.getReferencedElement(owner);
                LOG.assertTrue(namedElement != null);
                String msg = isClosure ? GroovyBundle.message("wrong.closure.first.parameter.type", namedElement.getName(), firstParam.getName()) : GroovyBundle.message("wrong.method.first.parameter.type", namedElement.getName(), firstParam.getName());
                ConvertParameterToMapEntryIntention.showErrorMessage(msg, project);
                return;
            }
            case MUST_BE_MAP: {
                if (firstParam == ConvertParameterToMapEntryIntention.getAppropriateParameter(element)) {
                    String msg = GroovyBundle.message("convert.cannot.itself", new Object[0]);
                    ConvertParameterToMapEntryIntention.showErrorMessage(msg, project);
                    return;
                }
                ConvertParameterToMapEntryIntention.performRefactoring(element, owner, occurrences, false, null, false);
                break;
            }
            case IS_NOT_MAP: {
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    @NlsSafe String[] possibleNames = ConvertParameterToMapEntryIntention.generateValidNames(MY_POSSIBLE_NAMES, firstParam);
                    GroovyMapParameterDialog dialog = new GroovyMapParameterDialog(project, possibleNames, true){

                        @Override
                        protected void doOKAction() {
                            String name = this.getEnteredName();
                            MultiMap conflicts = new MultiMap();
                            assert (name != null);
                            GroovyValidationUtil.validateNewParameterName(firstParam, (MultiMap<PsiElement, String>)conflicts, name);
                            if (isClosure) {
                                ConvertParameterToMapEntryIntention.findClosureConflictUsages((MultiMap<PsiElement, String>)conflicts, occurrences);
                            }
                            if (ConvertParameterToMapEntryIntention.reportConflicts((MultiMap<PsiElement, String>)conflicts, project)) {
                                ConvertParameterToMapEntryIntention.performRefactoring(element, owner, occurrences, this.createNewFirst(), name, this.specifyTypeExplicitly());
                            }
                            super.doOKAction();
                        }
                    };
                    dialog.show();
                    break;
                }
                ConvertParameterToMapEntryIntention.performRefactoring(element, owner, occurrences, true, new GroovyValidationUtil.ParameterNameSuggester("attrs", firstParam).generateName(), true);
            }
        }
    }

    private static void findClosureConflictUsages(MultiMap<PsiElement, String> conflicts, Collection<PsiElement> occurrences) {
        Iterator<PsiElement> iterator2 = occurrences.iterator();
        while (iterator2.hasNext()) {
            PsiElement occurrence;
            PsiElement origin = occurrence = iterator2.next();
            while (occurrence instanceof GrReferenceExpression) {
                occurrence = occurrence.getParent();
            }
            if (!(occurrence instanceof GrArgumentList)) continue;
            conflicts.putValue((Object)origin, (Object)GroovyBundle.message("closure.used.as.variable", new Object[0]));
        }
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @NlsSafe
    private static String[] generateValidNames(@NlsSafe String[] names, GrParameter param) {
        return (String[])ContainerUtil.map2Array((Object[])names, String.class, s -> new GroovyValidationUtil.ParameterNameSuggester((String)s, param).generateName());
    }

    private static void performRefactoring(PsiElement element, GrParameterListOwner owner, Collection<PsiElement> occurrences, boolean createNewFirstParam, @Nullable String mapParamName, boolean specifyMapType) {
        GrParameter param = ConvertParameterToMapEntryIntention.getAppropriateParameter(element);
        assert (param != null);
        String paramName = param.getName();
        String mapName = createNewFirstParam ? mapParamName : ConvertParameterToMapEntryIntention.getFirstParameter(owner).getName();
        Project project = element.getProject();
        Runnable runnable = () -> {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
            GrParameterList list = owner.getParameterList();
            int index = list.getParameterNumber(param);
            if (!createNewFirstParam && index <= 0) {
                return;
            }
            try {
                for (Object occurrence : occurrences) {
                    GrNamedArgument namedArg;
                    GrClosureSignatureUtil.ArgInfo<PsiElement>[] argInfos;
                    GrCall call;
                    PsiElement parent2;
                    GrSignature signature;
                    GrReferenceExpression refExpr = null;
                    GroovyResolveResult resolveResult2 = null;
                    boolean isExplicitGetterCall = false;
                    if (occurrence instanceof GrReferenceExpression) {
                        PsiElement resolved;
                        PsiElement parent3 = occurrence.getParent();
                        if (parent3 instanceof GrCall) {
                            refExpr = (GrReferenceExpression)occurrence;
                            resolveResult2 = refExpr.advancedResolve();
                            resolved = resolveResult2.getElement();
                            if (resolved instanceof PsiMethod && GroovyPropertyUtils.isSimplePropertyGetter((PsiMethod)resolved) && ((PsiMethod)resolved).getName().equals(refExpr.getReferenceName())) {
                                isExplicitGetterCall = true;
                            }
                        } else if (parent3 instanceof GrReferenceExpression && (resolved = (resolveResult2 = ((GrReferenceExpression)parent3).advancedResolve()).getElement()) instanceof PsiMethod && "call".equals(((PsiMethod)resolved).getName())) {
                            refExpr = (GrReferenceExpression)parent3;
                        }
                    }
                    if (refExpr == null || (signature = ConvertParameterToMapEntryIntention.generateSignature(owner, refExpr)) == null) continue;
                    if (isExplicitGetterCall) {
                        parent2 = refExpr.getParent();
                        LOG.assertTrue(parent2 instanceof GrCall);
                        parent2 = parent2.getParent();
                        if (parent2 instanceof GrReferenceExpression && "call".equals(((GrReferenceExpression)parent2).getReferenceName())) {
                            parent2 = parent2.getParent();
                        }
                        if (!(parent2 instanceof GrCall)) continue;
                        call = (GrCall)parent2;
                    } else {
                        call = (GrCall)refExpr.getParent();
                    }
                    if (resolveResult2.isInvokedOnProperty()) {
                        parent2 = call.getParent();
                        if (parent2 instanceof GrCall) {
                            call = (GrCall)parent2;
                        } else if (parent2 instanceof GrReferenceExpression && parent2.getParent() instanceof GrCall) {
                            PsiElement resolved = ((GrReferenceExpression)parent2).resolve();
                            if (!(resolved instanceof PsiMethod) || !"call".equals(((PsiMethod)resolved).getName())) continue;
                            call = (GrCall)parent2.getParent();
                        }
                    }
                    if ((argInfos = GrClosureSignatureUtil.mapParametersToArguments(signature, call)) == null) continue;
                    GrClosureSignatureUtil.ArgInfo<PsiElement> argInfo = argInfos[index];
                    if (argInfo.isMultiArg) {
                        if (argInfo.args.isEmpty()) continue;
                        String arg = "[" + StringUtil.join((Collection)ContainerUtil.map(argInfo.args, element1 -> element1.getText()), (String)", ") + "]";
                        for (PsiElement psiElement : argInfo.args) {
                            psiElement.delete();
                        }
                        namedArg = factory.createNamedArgument(paramName, factory.createExpressionFromText(arg));
                    } else {
                        if (argInfo.args.isEmpty()) continue;
                        PsiElement argument = (PsiElement)argInfo.args.iterator().next();
                        assert (argument instanceof GrExpression);
                        namedArg = factory.createNamedArgument(paramName, (GrExpression)argument);
                        argument.delete();
                    }
                    call.addNamedArgument(namedArg);
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            Collection references = ReferencesSearch.search((PsiElement)param).findAll();
            for (PsiReference ref : references) {
                PsiElement elt = ref.getElement();
                if (!(elt instanceof GrReferenceExpression)) continue;
                GrReferenceExpression expr = (GrReferenceExpression)elt;
                GrExpression newExpr = factory.createExpressionFromText(mapName + "." + paramName);
                expr.replaceWithExpression(newExpr, true);
            }
            if (createNewFirstParam) {
                try {
                    GrParameter newParam = factory.createParameter(mapName, specifyMapType ? MAP_TYPE_TEXT : "", null);
                    list.addAfter(newParam, null);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            param.delete();
        };
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(runnable), GroovyBundle.message("convert.parameter.to.map.entry.title", new Object[0]), null);
    }

    @Nullable
    private static GrParameter getAppropriateParameter(PsiElement element) {
        if (element instanceof GrParameter) {
            return (GrParameter)element;
        }
        if (element instanceof GrReferenceExpression) {
            GrReferenceExpression expr = (GrReferenceExpression)element;
            PsiElement resolved = expr.resolve();
            LOG.assertTrue(resolved instanceof GrParameter);
            return (GrParameter)resolved;
        }
        LOG.error("Selected expression is not resolved to method/closure parameter");
        return null;
    }

    @Nullable
    private static GrSignature generateSignature(GrParameterListOwner owner, GrReferenceExpression refExpr) {
        if (owner instanceof PsiMethod) {
            GroovyResolveResult resolveResult2 = refExpr.advancedResolve();
            PsiSubstitutor substitutor2 = resolveResult2.getSubstitutor();
            return GrClosureSignatureUtil.createSignature((PsiMethod)owner, substitutor2);
        }
        if (owner instanceof GrClosableBlock) {
            return GrClosureSignatureUtil.createSignature((GrClosableBlock)owner);
        }
        return null;
    }

    private static FIRST_PARAMETER_KIND analyzeForNamedArguments(GrParameterListOwner owner, Collection<PsiElement> occurrences) {
        boolean thereAreNamedArguments = false;
        for (PsiElement occurrence : occurrences) {
            GrCall call;
            GrArgumentList args;
            if (occurrence instanceof GrReferenceExpression && occurrence.getParent() instanceof GrCall && (args = (call = (GrCall)occurrence.getParent()).getArgumentList()) != null && args.getNamedArguments().length > 0) {
                thereAreNamedArguments = true;
            }
            if (!thereAreNamedArguments) continue;
            break;
        }
        if (thereAreNamedArguments) {
            if (ConvertParameterToMapEntryIntention.firstOwnerParameterMustBeMap(owner)) {
                return FIRST_PARAMETER_KIND.MUST_BE_MAP;
            }
            return FIRST_PARAMETER_KIND.ERROR;
        }
        return FIRST_PARAMETER_KIND.IS_NOT_MAP;
    }

    private static boolean firstOwnerParameterMustBeMap(GrParameterListOwner owner) {
        GrParameter first = ConvertParameterToMapEntryIntention.getFirstParameter(owner);
        PsiType type2 = first.getTypeGroovy();
        if (type2 == null) {
            return true;
        }
        return type2.isConvertibleFrom((PsiType)TypesUtil.createTypeByFQClassName("java.util.LinkedHashMap", owner));
    }

    @NotNull
    private static GrParameter getFirstParameter(GrParameterListOwner owner) {
        GrParameter[] params = owner.getParameters();
        LOG.assertTrue(params.length > 0);
        return params[0];
    }

    @Nullable
    private static GrNamedElement getReferencedElement(GrParameterListOwner owner) {
        PsiElement parent2;
        if (owner instanceof GrMethodImpl) {
            return (GrMethodImpl)owner;
        }
        if (owner instanceof GrClosableBlock && (parent2 = owner.getParent()) instanceof GrVariable && ((GrVariable)parent2).getInitializerGroovy() == owner) {
            return (GrVariable)parent2;
        }
        return null;
    }

    private static boolean checkOwnerOccurrences(Project project, Collection<PsiElement> occurrences, boolean isClosure) {
        boolean result2 = true;
        StringBuilder msg = new StringBuilder();
        msg.append(isClosure ? GroovyBundle.message("conversion.closure.not.allowed.in.non.groovy.files", new Object[0]) : GroovyBundle.message("conversion.method.not.allowed.in.non.groovy.files", new Object[0]));
        for (PsiElement element : occurrences) {
            PsiFile file = element.getContainingFile();
            if (file instanceof GroovyFileBase) continue;
            result2 = false;
            msg.append("\n").append(file.getName());
        }
        if (!result2) {
            @NlsSafe String message = msg.toString();
            ConvertParameterToMapEntryIntention.showErrorMessage(message, project);
            return false;
        }
        return true;
    }

    private static boolean collectOwnerOccurrences(Project project, GrParameterListOwner owner, final Collection<PsiElement> occurrences) {
        final GrNamedElement namedElem = ConvertParameterToMapEntryIntention.getReferencedElement(owner);
        if (namedElem == null) {
            return true;
        }
        final Ref result2 = new Ref((Object)true);
        Task.Modal task = new Task.Modal(project, owner instanceof GrClosableBlock ? GroovyBundle.message("find.method.ro.closure.usages", new Object[0]) : GroovyBundle.message("find.method.ro.method.usages", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                Set<PsiReference> references = Collections.synchronizedSet(new HashSet());
                Processor consumer = psiReference -> {
                    references.add(psiReference);
                    return true;
                };
                ReferencesSearch.search((PsiElement)namedElem).forEach(consumer);
                boolean isProperty = (Boolean)ReadAction.compute(() -> namedElem instanceof GrField && ((GrField)namedElem).isProperty());
                if (isProperty) {
                    GrAccessorMethod[] getters;
                    for (GrAccessorMethod getter : getters = (GrAccessorMethod[])ReadAction.compute(() -> ((GrField)namedElem).getGetters())) {
                        MethodReferencesSearch.search((PsiMethod)getter).forEach(consumer);
                    }
                }
                for (PsiReference reference : references) {
                    ApplicationManager.getApplication().runReadAction(() -> {
                        PsiElement element = reference.getElement();
                        if (element != null) {
                            occurrences.add(element);
                        }
                    });
                }
            }

            public void onCancel() {
                result2.set((Object)false);
            }

            public void onThrowable(@NotNull Throwable error) {
                super.onThrowable(error);
                result2.set((Object)false);
            }

            public void onSuccess() {
                result2.set((Object)true);
            }
        };
        ProgressManager.getInstance().run((Task)task);
        return (Boolean)result2.get();
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new MyPsiElementPredicate();
    }

    private static boolean checkForMapParameters(GrParameterListOwner owner) {
        GrParameter[] parameters2 = owner.getParameters();
        if (parameters2.length != 1) {
            return true;
        }
        GrParameter parameter = parameters2[0];
        PsiType type2 = parameter.getTypeGroovy();
        if (!(type2 instanceof PsiClassType)) {
            return true;
        }
        PsiClass psiClass = ((PsiClassType)type2).resolve();
        return psiClass == null || !"java.util.Map".equals(psiClass.getQualifiedName());
    }

    private static void showErrorMessage(@NlsContexts.DialogMessage String message, Project project) {
        CommonRefactoringUtil.showErrorMessage((String)GroovyBundle.message("convert.parameter.to.map.entry.title", new Object[0]), (String)message, null, (Project)project);
    }

    private static boolean reportConflicts(MultiMap<PsiElement, String> conflicts, Project project) {
        if (conflicts.isEmpty()) {
            return true;
        }
        ConflictsDialog conflictsDialog = new ConflictsDialog(project, conflicts);
        return conflictsDialog.showAndGet();
    }

    private static class MyPsiElementPredicate
    implements PsiElementPredicate {
        private MyPsiElementPredicate() {
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            GrParameter parameter = null;
            if (element instanceof GrParameter) {
                parameter = (GrParameter)element;
            } else if (element instanceof GrReferenceExpression) {
                GrReferenceExpression expr = (GrReferenceExpression)element;
                if (expr.getQualifierExpression() != null) {
                    return false;
                }
                PsiElement resolved = expr.resolve();
                if (resolved instanceof GrParameter) {
                    parameter = (GrParameter)resolved;
                }
            }
            if (parameter == null) {
                return false;
            }
            if (parameter.isOptional()) {
                return false;
            }
            GrParameterListOwner owner = (GrParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, GrParameterListOwner.class);
            return owner != null && ConvertParameterToMapEntryIntention.checkForMapParameters(owner);
        }
    }

    protected static enum FIRST_PARAMETER_KIND {
        IS_NOT_MAP,
        MUST_BE_MAP,
        ERROR;

    }
}

