/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.conversions.IndexedExpressionConversionPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class IndexedExpressionConversionIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new IndexedExpressionConversionPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        GrIndexProperty arrayIndexExpression = (GrIndexProperty)element;
        GrArgumentList argList = (GrArgumentList)arrayIndexExpression.getLastChild();
        assert (argList != null);
        GrExpression[] arguments2 = argList.getExpressionArguments();
        PsiElement parent2 = element.getParent();
        GrExpression arrayExpression = arrayIndexExpression.getInvokedExpression();
        if (!(parent2 instanceof GrAssignmentExpression)) {
            IndexedExpressionConversionIntention.rewriteAsGetAt(arrayIndexExpression, arrayExpression, arguments2[0]);
            return;
        }
        GrAssignmentExpression assignmentExpression = (GrAssignmentExpression)parent2;
        GrExpression rhs = assignmentExpression.getRValue();
        if (rhs.equals(element)) {
            IndexedExpressionConversionIntention.rewriteAsGetAt(arrayIndexExpression, arrayExpression, arguments2[0]);
        } else {
            IndexedExpressionConversionIntention.rewriteAsSetAt(assignmentExpression, arrayExpression, arguments2[0], rhs);
        }
    }

    private static void rewriteAsGetAt(GrIndexProperty arrayIndexExpression, GrExpression arrayExpression, GrExpression argument) throws IncorrectOperationException {
        PsiImplUtil.replaceExpression(arrayExpression.getText() + ".getAt(" + argument.getText() + ")", arrayIndexExpression);
    }

    private static void rewriteAsSetAt(GrAssignmentExpression assignment, GrExpression arrayExpression, GrExpression argument, GrExpression value) throws IncorrectOperationException {
        PsiImplUtil.replaceExpression(arrayExpression.getText() + ".putAt(" + argument.getText() + ", " + value.getText() + ")", assignment);
    }
}

