/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.geb;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.geb.GebUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ClassUtil;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;

public class GebPageMemberContributor
extends NonCodeMembersContributor {
    @Override
    protected String getParentClassName() {
        return "geb.Page";
    }

    @Override
    public void processDynamicElements(@NotNull PsiType qualifierType, @Nullable PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        GrField f;
        PsiElement contentField;
        PsiElement grClosure;
        if (!ResolveUtilKt.shouldProcessMethods(processor) && !ResolveUtilKt.shouldProcessProperties(processor)) {
            return;
        }
        if (aClass == null) {
            return;
        }
        PsiElement grCall = place.getParent();
        if (grCall instanceof GrMethodCall && (grClosure = grCall.getParent()) instanceof GrClosableBlock && (contentField = grClosure.getParent()) instanceof GrField && "content".equals((f = (GrField)contentField).getName()) && f.hasModifierProperty("static") && f.getContainingClass() == aClass) {
            Map<String, PsiMember> elements = GebUtil.getContentElements(aClass);
            for (PsiMember element : elements.values()) {
                if (element.getNavigationElement() != place) continue;
                return;
            }
        }
        GebPageMemberContributor.processPageElements(processor, aClass, state.put(ResolveUtilKt.sorryCannotKnowElementKind, (Object)true));
    }

    public static boolean processPageElements(PsiScopeProcessor processor, @NotNull PsiClass pageClass, ResolveState state) {
        Map<String, PsiClass> supers = ClassUtil.getSuperClassesWithCache(pageClass);
        String nameHint2 = ResolveUtil.getNameHint(processor);
        for (PsiClass psiClass : supers.values()) {
            Map<String, PsiMember> contentElements = GebUtil.getContentElements(psiClass);
            if (nameHint2 == null) {
                for (Map.Entry<String, PsiMember> entry : contentElements.entrySet()) {
                    if (processor.execute((PsiElement)entry.getValue(), state)) continue;
                    return false;
                }
                continue;
            }
            PsiMember element = contentElements.get(nameHint2);
            if (element == null) continue;
            return processor.execute((PsiElement)element, state);
        }
        return true;
    }
}

