/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gant;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.actions.GroovyTemplatesFactory;
import org.jetbrains.plugins.groovy.actions.NewGroovyActionBase;
import org.jetbrains.plugins.groovy.gant.GantUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class NewGantScriptAction
extends NewGroovyActionBase {
    @NotNull
    protected String getActionName(@NotNull PsiDirectory directory, @NotNull String newName) {
        return GroovyBundle.message("new.gant.script.dialog.title", new Object[0]);
    }

    @Override
    @NlsContexts.DialogMessage
    protected String getDialogPrompt() {
        return GroovyBundle.message("new.gant.script.dialog.message", new Object[0]);
    }

    @Override
    @NlsContexts.DialogTitle
    protected String getDialogTitle() {
        return GroovyBundle.message("new.gant.script.dialog.title", new Object[0]);
    }

    @Override
    protected boolean isAvailable(DataContext dataContext) {
        return super.isAvailable(dataContext) && GantUtils.isSDKConfiguredToRun(Objects.requireNonNull((Module)PlatformCoreDataKeys.MODULE.getData(dataContext)));
    }

    @Override
    protected PsiElement @NotNull [] doCreate(String newName, PsiDirectory directory) throws Exception {
        PsiElement[] psiElementArray;
        PsiFile file = NewGantScriptAction.createGantScriptFromTemplate(directory, newName, "Gant Script.gant", new String[0]);
        PsiElement lastChild = file.getLastChild();
        PsiElement child = null;
        if (lastChild instanceof GrMethodCallExpression) {
            child = lastChild;
        }
        if (child == null && file.getChildren().length > 0) {
            child = file.getLastChild();
        }
        if (child != null) {
            PsiElement[] psiElementArray2 = new PsiElement[2];
            psiElementArray2[0] = file;
            psiElementArray = psiElementArray2;
            psiElementArray2[1] = child;
        } else {
            PsiElement[] psiElementArray3 = new PsiElement[1];
            psiElementArray = psiElementArray3;
            psiElementArray3[0] = file;
        }
        return psiElementArray;
    }

    private static PsiFile createGantScriptFromTemplate(PsiDirectory directory, String className, String templateName, String ... parameters2) throws IncorrectOperationException {
        return GroovyTemplatesFactory.createFromTemplate(directory, className, className + ".gant", templateName, true, parameters2);
    }
}

