/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gant;

import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.gant.GantConfigurable;
import org.jetbrains.plugins.groovy.gant.GantUtils;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunner;
import org.jetbrains.plugins.groovy.util.GroovyUtils;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public class GantRunner
extends GroovyScriptRunner {
    private static final String UNIQUE_STRING = "d230efbae4b744ae86ef4014eef1b387";

    @Override
    public boolean shouldRefreshAfterFinish() {
        return true;
    }

    @Override
    public boolean isValidModule(@NotNull Module module) {
        return GantUtils.isSDKConfiguredToRun(module);
    }

    @Override
    public void ensureRunnerConfigured(@NotNull GroovyScriptRunConfiguration configuration) throws RuntimeConfigurationException {
        Project project = configuration.getProject();
        if (GantUtils.getSDKInstallPath(configuration.getModule(), project).isEmpty()) {
            RuntimeConfigurationException e = new RuntimeConfigurationException(GroovyBundle.message("dialog.message.gant.not.configured", new Object[0]));
            e.setQuickFix(() -> ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new GantConfigurable(project)));
            throw e;
        }
    }

    @Nullable
    private static String getGantConfPath(String gantHome) {
        String confPath = FileUtil.toSystemDependentName((String)(gantHome + "/conf/gant-starter.conf"));
        if (new File(confPath).exists()) {
            return confPath;
        }
        return GantRunner.getConfPath(gantHome);
    }

    @Override
    public void configureCommandLine(JavaParameters params, @Nullable Module module, boolean tests, VirtualFile script, GroovyScriptRunConfiguration configuration) throws CantRunException {
        String gantHome = GantUtils.getSDKInstallPath(module, configuration.getProject());
        GantRunner.addGroovyAndAntJars(params, module, gantHome);
        GantRunner.setToolsJar(params);
        GantRunner.setGroovyHome(params, gantHome);
        String confPath = GantRunner.getGantConfPath(gantHome);
        if (confPath != null) {
            params.getVMParametersList().add("-Dgroovy.starter.conf=" + confPath);
            params.getProgramParametersList().add("--conf");
            params.getProgramParametersList().add(confPath);
        }
        params.getVMParametersList().addParametersString(configuration.getVMParameters());
        params.setMainClass("org.codehaus.groovy.tools.GroovyStarter");
        if (gantHome.contains("grails")) {
            params.getClassPath().addAllFiles(GroovyUtils.getFilesInDirectoryByPattern(gantHome + "/lib", ".*\\.jar"));
        }
        GantRunner.addClasspathFromRootModel(module, tests, params, false);
        String antHome = System.getenv("ANT_HOME");
        if (StringUtil.isEmpty((String)antHome)) {
            antHome = gantHome;
        }
        params.getVMParametersList().add("-Dant.home=" + antHome);
        params.getVMParametersList().add("-Dgant.home=" + gantHome);
        params.getProgramParametersList().add("--main");
        params.getProgramParametersList().add("gant.Gant");
        params.getProgramParametersList().add("--file");
        params.getProgramParametersList().add(FileUtil.toSystemDependentName((String)configuration.getScriptPath()));
        if (configuration.isDebugEnabled()) {
            params.getProgramParametersList().add("--debug");
            params.getProgramParametersList().add("-Dd230efbae4b744ae86ef4014eef1b387");
        }
        params.getProgramParametersList().addParametersString(configuration.getProgramParameters());
    }

    private static void addGroovyAndAntJars(JavaParameters params, Module module, String gantHome) {
        String[] characteristicClasses;
        File[] libJars;
        File[] groovyJars = GroovyConfigUtils.getGroovyAllJars(gantHome + "/lib/");
        if (groovyJars.length > 0) {
            params.getClassPath().add(groovyJars[0].getAbsolutePath());
        }
        if (module == null) {
            return;
        }
        String groovyHome = LibrariesUtil.getGroovyHomePath(module);
        if (groovyHome != null && (libJars = GroovyUtils.getFilesInDirectoryByPattern(groovyHome + "/lib/", ".*\\.jar")).length > 0) {
            params.getClassPath().addAllFiles(libJars);
        }
        List classpath = params.getClassPath().getRootDirs();
        for (String someClass : characteristicClasses = (String[])ContainerUtil.ar((Object[])new String[]{"org.codehaus.groovy.control.CompilationUnit", "org.apache.tools.ant.BuildException", "org.apache.tools.ant.launch.AntMain", "org.apache.commons.cli.ParseException"})) {
            VirtualFile jar;
            if (LibraryUtil.isClassAvailableInLibrary((List)classpath, (String)someClass) || (jar = LibrariesUtil.findJarWithClass(module, someClass)) == null) continue;
            params.getClassPath().add(jar);
        }
    }
}

