/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter.blocks;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.ILazyParseableElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.formatter.FormattingContext;
import org.jetbrains.plugins.groovy.formatter.blocks.GroovyBlockGenerator;
import org.jetbrains.plugins.groovy.formatter.processors.GroovyIndentProcessor;
import org.jetbrains.plugins.groovy.formatter.processors.GroovySpacingProcessor;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTag;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLoopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;

public class GroovyBlock
implements Block,
ASTBlock {
    protected final ASTNode myNode;
    protected Alignment myAlignment = null;
    protected final Indent myIndent;
    protected final Wrap myWrap;
    protected final FormattingContext myContext;
    protected List<Block> mySubBlocks = null;

    public GroovyBlock(@NotNull ASTNode node, @NotNull Indent indent, @Nullable Wrap wrap, @NotNull FormattingContext context) {
        this.myNode = node;
        this.myIndent = indent;
        this.myWrap = wrap;
        this.myContext = context;
    }

    @NotNull
    public ASTNode getNode() {
        return this.myNode;
    }

    @NotNull
    public TextRange getTextRange() {
        return this.myNode.getTextRange();
    }

    @NotNull
    public List<Block> getSubBlocks() {
        if (this.mySubBlocks == null) {
            this.mySubBlocks = new GroovyBlockGenerator(this).generateSubBlocks();
        }
        return this.mySubBlocks;
    }

    @Nullable
    public Wrap getWrap() {
        return this.myWrap;
    }

    @NotNull
    public Indent getIndent() {
        return this.myIndent;
    }

    @Nullable
    public Alignment getAlignment() {
        if (this.myAlignment == null) {
            this.myAlignment = this.myContext.getAlignmentProvider().getAlignment(this.myNode.getPsi());
        }
        return this.myAlignment;
    }

    @Nullable
    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        return GroovySpacingProcessor.getSpacing(child1, child2, this.myContext);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ASTNode astNode = this.getNode();
        PsiElement psiParent = astNode.getPsi();
        if (psiParent instanceof GroovyFileBase) {
            return new ChildAttributes(Indent.getNoneIndent(), null);
        }
        if (psiParent instanceof GrSwitchElement) {
            new ChildAttributes(Indent.getNoneIndent(), null);
        }
        if (psiParent instanceof GrCaseSection) {
            return new ChildAttributes(GroovyIndentProcessor.getSwitchCaseIndent(this.getContext().getSettings()), null);
        }
        if (astNode.getElementType() == GroovyElementTypes.LAMBDA_EXPRESSION) {
            return new ChildAttributes(Indent.getNormalIndent(), null);
        }
        if (astNode.getElementType() == GroovyElementTypes.BLOCK_LAMBDA_BODY) {
            return new ChildAttributes(Indent.getNormalIndent(), null);
        }
        if (TokenSets.BLOCK_SET.contains(astNode.getElementType()) || org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.SWITCH_STATEMENT.equals(astNode.getElementType()) || org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.SWITCH_EXPRESSION.equals(astNode.getElementType())) {
            return new ChildAttributes(Indent.getNormalIndent(), null);
        }
        if (org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.CASE_SECTION.equals(astNode.getElementType())) {
            return new ChildAttributes(Indent.getNormalIndent(), null);
        }
        if (psiParent instanceof GrBinaryExpression || psiParent instanceof GrConditionalExpression || psiParent instanceof GrArgumentList || psiParent instanceof GrParameterList || psiParent instanceof GrListOrMap || psiParent instanceof GrAnnotationArgumentList || psiParent instanceof GrVariable || psiParent instanceof GrAssignmentExpression) {
            return new ChildAttributes(Indent.getContinuationWithoutFirstIndent(), null);
        }
        if (psiParent instanceof GrDocComment || psiParent instanceof GrDocTag) {
            return new ChildAttributes(Indent.getSpaceIndent((int)1), null);
        }
        if (psiParent instanceof GrIfStatement || psiParent instanceof GrLoopStatement) {
            return new ChildAttributes(Indent.getNormalIndent(), null);
        }
        if (psiParent instanceof GrLabeledStatement && newChildIndex == 2) {
            Indent indent = this.getContext().getGroovySettings().INDENT_LABEL_BLOCKS ? Indent.getLabelIndent() : Indent.getNoneIndent();
            return new ChildAttributes(indent, null);
        }
        return new ChildAttributes(Indent.getNoneIndent(), null);
    }

    public boolean isIncomplete() {
        return GroovyBlock.isIncomplete(this.myNode);
    }

    public static boolean isIncomplete(@NotNull ASTNode node) {
        ASTNode lastChild;
        if (node.getElementType() instanceof ILazyParseableElementType) {
            return false;
        }
        for (lastChild = node.getLastChildNode(); lastChild != null && !(lastChild.getElementType() instanceof ILazyParseableElementType) && (lastChild.getPsi() instanceof PsiWhiteSpace || lastChild.getPsi() instanceof PsiComment); lastChild = lastChild.getTreePrev()) {
        }
        return lastChild != null && (lastChild.getPsi() instanceof PsiErrorElement || GroovyBlock.isIncomplete(lastChild));
    }

    public boolean isLeaf() {
        return this.myNode.getFirstChildNode() == null;
    }

    public String toString() {
        return this.getTextRange() + ": " + this.myNode;
    }

    public FormattingContext getContext() {
        return this.myContext;
    }
}

