/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.find.findUsages.JavaFindUsagesHandler;
import com.intellij.find.findUsages.JavaFindUsagesHandlerFactory;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

public final class GroovyFieldFindUsagesHandlerFactory
extends JavaFindUsagesHandlerFactory {
    public GroovyFieldFindUsagesHandlerFactory(Project project) {
        super(project);
    }

    public boolean canFindUsages(@NotNull PsiElement element) {
        return element instanceof GrField;
    }

    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element, @NotNull FindUsagesHandlerFactory.OperationMode operationMode) {
        return new JavaFindUsagesHandler(element, this){

            public PsiElement @NotNull [] getSecondaryElements() {
                PsiMethod[] setters;
                PsiMethod[] getters;
                PsiElement element = this.getPsiElement();
                PsiField field = (PsiField)element;
                PsiClass containingClass = field.getContainingClass();
                if (containingClass != null && (getters = GroovyPropertyUtils.getAllGettersByField(field)).length + (setters = GroovyPropertyUtils.getAllSettersByField(field)).length > 0) {
                    boolean doSearch;
                    if (GroovyFieldFindUsagesHandlerFactory.arePhysical(getters) || GroovyFieldFindUsagesHandlerFactory.arePhysical(setters)) {
                        if (ApplicationManager.getApplication().isUnitTestMode()) {
                            return PsiElement.EMPTY_ARRAY;
                        }
                        doSearch = GroovyFieldFindUsagesHandlerFactory.this.getFindVariableOptions().isSearchForAccessors;
                    } else {
                        doSearch = true;
                    }
                    if (doSearch) {
                        ArrayList elements = new ArrayList();
                        if (GroovyFieldFindUsagesHandlerFactory.this.getFindVariableOptions().isSearchForBaseAccessors) {
                            for (PsiMethod getter : getters) {
                                ContainerUtil.addAll(elements, (Object[])SuperMethodWarningUtil.getTargetMethodCandidates((PsiMethod)getter, Collections.emptyList()));
                            }
                            for (PsiMethod setter : setters) {
                                ContainerUtil.addAll(elements, (Object[])SuperMethodWarningUtil.getTargetMethodCandidates((PsiMethod)setter, Collections.emptyList()));
                            }
                        }
                        Iterator iterator2 = elements.iterator();
                        while (iterator2.hasNext()) {
                            if (!(iterator2.next() instanceof GrAccessorMethod)) continue;
                            iterator2.remove();
                        }
                        return PsiUtilCore.toPsiElementArray(elements);
                    }
                    return PsiElement.EMPTY_ARRAY;
                }
                return super.getSecondaryElements();
            }
        };
    }

    private static boolean arePhysical(PsiMethod[] methods) {
        for (PsiMethod method : methods) {
            if (!method.isPhysical()) continue;
            return true;
        }
        return false;
    }
}

