/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.codeInsight.highlighting.HighlightOverridingMethodsHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public class GrHighlightOverridingMethodsHandler
extends HighlightOverridingMethodsHandler {
    private final PsiElement myTarget;
    private final GrTypeDefinition myClass;

    public GrHighlightOverridingMethodsHandler(Editor editor, PsiFile file, PsiElement target, GrTypeDefinition psiClass) {
        super(editor, file, target, (PsiClass)psiClass);
        this.myTarget = target;
        this.myClass = psiClass;
    }

    @NotNull
    public List<PsiClass> getTargets() {
        GrReferenceList list;
        GrReferenceList grReferenceList = list = GroovyTokenTypes.kEXTENDS == this.myTarget.getNode().getElementType() ? this.myClass.getExtendsClause() : this.myClass.getImplementsClause();
        if (list == null) {
            return Collections.emptyList();
        }
        Object[] classTypes = list.getReferencedTypes();
        return ContainerUtil.mapNotNull((Object[])classTypes, t -> t.resolve());
    }
}

